;"SAY-MEMORY": HEX-LISTING AKUSTISCH WIEDERGEBEN
;QUELLE: LLC1, ABGESPECKT UND AUF LC-80EX PORTIERT
;FUER TAKTFREQUENZ 1,8 MHZ
;*************************************************
;UP DES LC-80
DAK2:   EQU #0483       ;BEDIENUNG ANZEIGE 1X
DADP:   EQU #04C3
ADRSDP: EQU #04B7
;-------------------------------------------------
PIO:    EQU #F5         ;SYSPIO/B1=TAPE-LED/SPEAKER
;--------------------------------------------------
;ARBEITSZELLEN
DATLED: EQU #23F2       ;ANZEIGESPEICHER DATEN
MEM0:   EQU #2348       ;AKT. BYTE
MEM1:   EQU MEM0+1      ;AKT. ADRESSE
MEM2:   EQU MEM0+3      ;LED-FLAG
;-------------------------------------------------
ORG 2400H
;-------------------------------------------------
L01:    LD      HL,L01          ;ANFANGSADRESSE
        LD      DE,AD_1         ;ENDEADRESSE+1
        LD      IX,DATLED       ;ANZEIGESPEICHER LED
L02:    ;IN HL STEHT SPEICHERADRESSE, DEREN BYTE ZU LESEN IST
        LD      (MEM1),HL       ;MERKEN
        LD      A,(HL)          ;LESE-BYTE 
        LD      (MEM0),A        ;MERKEN
        CALL    WARTEN2         ;PAUSE ZWISCHEN BYTES
        ;OBERES NIBBLE:
        LD      A,(MEM0)        ;LESEBYTE
        RRA
        RRA
        RRA
        RRA
        AND     #0F             ;OBERES NIBBLE
        OR      A               ;WAR=0?
        JR      NZ,L03          ;NEIN=> ABLEGEN 01...0F 
        LD      A,#10           ;+10H => "NULL"
L03:    CALL    SPRICH          ;OBERES NIBBLE SPRECHEN
        CALL    WARTEN1         ;PAUSE ZWISCHEN OBEREM UND UNTEREM
        ;UNTERES NIBBLE:
        LD      A,(MEM0)        ;AKT. BYTE
        AND     A,#0F           ;UNTERES NIBBLE
        OR      A               ;WAR =0?
        JR      NZ,L04           ;NEIN => ABLEGEN 01..0F
        LD      A,#10           ;JA=+10H ("NULL")
L04:    CALL    SPRICH          ;UNTERES NIBBLE SPRECHEN
        INC     HL              ;NCHSTE ADRESSE
        PUSH    HL
        OR      A
        SBC     HL,DE           ;BIS ENDEADRESSE GELESEN?
        POP     HL
        JR      NZ,L02          ;NOCH NICHT
        JP      0               ;JA=> RCKSPRUNG IN MONITOR
;-----------------------------------------------------------
;WORT AUSGEBEN ("EINS",...,"FRIEDRICH","NULL")
;KOMMT MIT CODE 01...10H IN A
SPRICH: PUSH    BC
        PUSH    DE
        PUSH    HL
        LD      B,A             ;01...10H
        LD      HL,AD_1-#300
        LD      DE,#0300        ;LNGE 1 MUSTER
SPR0:   ADD     HL,DE
        DJNZ    SPR0            ;HL=ANFANGSADRESSE MUSTER
        ;------------------------
        LD      B,08H           ;8 DATENBITS AUDIODATEN
MP1:    NOP                     ;VERZGERUNG ZWISCHEN 2 BITS
                                ;=TONHHE FR CA. 1,8 MHZ
MP2:    RLC     (HL)            ;BITS HOLEN+SCHIEBEN
        JR      NC,MP3          ;BIT WAR=0
        ;BIT WAR=1
        IN      A,(PIO)         ;PIO1B LESEN
        OR      2               ;XXXX XXIX  ;B1=SOUNDBIT
        JR      MP4             ;=> SETZEN         
MP3:    IN      A,(PIO)         ;PIO1B LESEN
        AND     #FD             ;IIII II0I  ;B1=SOUNDBIT RCKSETZEN
MP4:    OUT     (PIO),A         ;AUSGEBEN
        DJNZ     MP1
        ;1 BYTE FERTIG AUSGEGEBEN (+RESTAURIERT)
        NOP
        NOP
        LD      B,08H
        INC     HL              ;NCHSTES AUDIO-BYTE
        DEC     DE  
        LD      A,D
        OR      E               ;AUDIODATEN FERTIG?
        JR      NZ,MP2          ;NEIN, NCHSTES BYTE
        POP     HL
        POP     DE
        POP     BC
        RET
;-------------------------------------------------
WARTEN1:PUSH    HL
        PUSH    AF
        LD      HL,#0010        ;PAUSE ZWISCHEN NIBBLES 
        XOR     A               ;KEINE LEDANZEIGE
        LD      (MEM2),A        ;ZWISCHEN NIBBLES   
        JR      WARTEN3 
WARTEN2:PUSH    HL
        PUSH    AF
        LD      HL,#0080        ;PAUSE ZWISCHEN BYTES
        LD      A,1             ;LED NUR IN PAUSE
        LD      (MEM2),A        ;ZWISCHEN DEN BYTES
WARTEN3:CALL    LED             ;LED IN PAUSE ANZEIGEN
        DEC     HL
        LD      A,H
        OR      L           
        JR      NZ,WARTEN3
        POP     AF
        POP     HL
        RET
;IN PAUSE ZWISCHEN DEN BYTES DIE LED BEDIENEN
LED:    PUSH    HL
        PUSH    DE
        LD      A,(MEM2)
        CP      0
        JR      Z,LED2 
        LD      A,(MEM0)        ;DATEN
        LD      DE,(MEM1)       ;ADRESSE
        CALL    DADP            ;DATEN BERNEHMEN
        CALL    ADRSDP          ;ADRESSE BRNEHMEN
        CALL    DAK2            ;ANZEIGE
LED2:   POP     DE
        POP     HL
        RET
;-------------------------------------------------
;AUDIODATEN JEWEILS 300H BYTES LANG FR EIN WORT
;"EINS"
AD_1:  
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FEH,3EH,3CH,7CH,0F3H,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FEH,8
DEFB 7CH,39H,0F0H,0FH,0F0H,3FH,80H,7FH,1,0FCH,3,0FCH,0FH,0F8H,1FH,0FEH
DEFB 7FH,0E0H,7,0F1H,0FFH,0,7FH,83H,0FCH,1FH,0F0H,3FH,0FDH,0FEH,10H,0FFH
DEFB 0E0H,0FFH,0,3FH,0,7CH,3,0F8H,7,0E0H,3FH,0C0H,7FH,1,0FFH,0E0H
DEFB 0FFH,0E0H,0,0,3FH,0,80H,0,0FH,0FEH,0EH,8,0FFH,80H,1CH,1FH
DEFB 0F8H,1FH,0F0H,7EH,0,60H,0,0,0,1FH,8EH,1CH,38H,0F8H,1,80H
DEFB 3FH,0E0H,0,7,0FEH,0,0,7FH,80H,0,0,0,0,7CH,38H,0F0H
DEFB 0E3H,0C0H,0CH,0,0FCH,0,0,3FH,0F0H,0,3,0F8H,0,0,0,1
DEFB 0F0H,0E3H,0C3H,0DFH,0,20H,7,0E0H,0,0,0FFH,0C0H,0,0FH,80H,0
DEFB 0,0,0FH,0C3H,8EH,0FH,0FCH,38H,0,7FH,0,0,7,0FEH,0,0
DEFB 38H,0,0,0,0,7EH,1CH,30H,3FH,0E1H,0C0H,6,78H,70H,0,7
DEFB 0F8H,0,0,70H,0,0,0,1,0F0H,70H,0C1H,0EFH,0FH,0,20H,3FH
DEFB 0C0H,0,0FH,0C0H,0,0,0,0,0,0,0FH,0C3H,80H,0FH,3CH,0F8H
DEFB 0,1,0FCH,0,0,7EH,1CH,0,0,0,0,0,0,7EH,1EH,0
DEFB 30H,7FH,0C0H,0,3,0C1H,0,1,0C1H,0F0H,0,0,0,0,0,0
DEFB 0F8H,78H,1,0C1H,0FFH,0,0,0,1FH,0,0,3,80H,0,0,0
DEFB 0,0,0,0F8H,0F8H,3,83H,0FFH,80H,0,0,70H,0,0,6,0
DEFB 0,0,0,0,0,3,0E1H,0E0H,4,0FH,7,0E0H,0,0,0,0
DEFB 0,0,0,0,0,0,0,0,0FH,87H,80H,10H,3CH,1FH,80H,0
DEFB 0,0,3,80H,0,0,0,0,0,0,0,1EH,3EH,0,40H,70H
DEFB 7FH,0,0,0,0,30H,0,0,0,0,0,0,0,0,0F1H,0F0H
DEFB 3,3,1,0FCH,0,0,0,0,0,0,0,0,0,0,0,0
DEFB 6,0FH,0E0H,0F0H,0,0,0C0H,0,0,0,0,0,0,0,0,0
DEFB 0,0,0,0,0F0H,3FH,0,0,0,0,0,0,0,0,0,0
DEFB 0,0,0,0,0,0,0,7,0FFH,80H,0,0,0,0,0,0
DEFB 0,0,0,0,0,0,0,0,0,1,0FFH,0FFH,0,0,0,0
DEFB 0,0,0,0,0,0,0,0,0,0,0,0,3FH,0FFH,0FCH,0
DEFB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7FH
DEFB 0FFH,80H,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DEFB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DEFB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DEFB 0,0,0,1CH,0,0,0,0,0,80H,30H,22H,0,0,0,0
DEFB 1,0,24H,4,0C0H,20H,0,0,0,4CH,10H,9AH,5,0A1H,36H,94H
DEFB 50H,58H,0AH,80H,9,0,0A1H,0D0H,1,82H,81H,0,0,28H,10H,10H
DEFB 2,5,13H,31H,0AAH,0F4H,9EH,45H,6AH,0D4H,0D4H,8AH,0AH,5,20H,0A2H
DEFB 50H,0AH,74H,0AH,4DH,0AH,9CH,1EH,0D6H,0EAH,0D9H,16H,49H,40H,0AH,0A2H
DEFB 0D5H,5BH,48H,96H,4AH,7FH,7AH,4AH,55H,45H,55H,0A2H,0D5H,64H,0A8H,22H
DEFB 0B0H,95H,53H,0AAH,0A5H,48H,0B4H,57H,0EAH,99H,54H,1BH,67H,0C3H,92H,0A2H
DEFB 2EH,4FH,0C8H,0A5H,95H,4DH,38H,92H,0FDH,6DH,95H,6BH,0A5H,0B4H,0EH,0FFH
;-----------------------------------------------------------------------------------
;"ZWEI"
AD_2:
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0F8H,7CH,7FH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FEH,7FH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0E7H,0F7H,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0EFH,0FFH,0FFH,0FFH,0BFH,0FFH,0FDH,0FFH,0BFH,0CFH,9FH,0AFH,0FFH
DEFB 9FH,0C7H,0F3H,9BH,8FH,0F9H,0F3H,0CFH,0F9H,79H,0FCH,7EH,65H,0F9H,0E3H,0DCH
DEFB 0DCH,0DFH,0D3H,0ACH,0CBH,0B4H,0BFH,4EH,5CH,0D4H,0D8H,0DCH,0ECH,0C9H,6BH,0A2H
DEFB 0E9H,0B9H,5AH,8BH,54H,0D6H,51H,47H,97H,28H,2DH,9DH,1BH,23H,66H,4FH
DEFB 0BEH,92H,0B6H,8BH,0E3H,66H,0CDH,9BH,0E3H,62H,0E6H,4CH,6CH,0C4H,0CCH,0CEH
DEFB 4EH,36H,66H,4CH,66H,0E6H,62H,65H,8DH,0C6H,0E6H,0C1H,0B3H,26H,0E6H,67H
DEFB 66H,72H,78H,9CH,1CH,0CEH,33H,99H,0B3H,33H,9DH,80H,0EEH,7,0D3H,0B3H
DEFB 3BH,11H,8BH,80H,1,9CH,0C6H,39H,8EH,83H,0F0H,0E2H,38H,0E7H,9EH,3FH
DEFB 9EH,38H,0F3H,8FH,0E3H,8FH,38H,70H,0F0H,0E0H,0E3H,83H,87H,7,0FFH,1BH
DEFB 0E0H,21H,0FEH,1FH,87H,8FH,81H,0FCH,18H,1EH,30H,0F0H,0FFH,0E3H,1FH,4
DEFB 1FH,0FCH,0,38H,3FH,0CEH,0F8H,30H,78H,7FH,0FEH,10H,0FFH,0E7H,0FFH,0FFH
DEFB 0C3H,80H,1CH,0,1CH,0,0,60H,0,0,3,0FFH,0FFH,0FFH,83H,0FFH
DEFB 0E3H,0FFH,0FFH,0FFH,3,0F8H,2,0,0,0,0,0,3FH,0FFH,0FFH,0F0H
DEFB 7,0F8H,1FH,0FFH,0C3H,0FFH,0FFH,0FDH,0FCH,7CH,10H,0,0,0,0,1FH
DEFB 0FFH,0FFH,0FCH,0,7CH,3,0FFH,0F8H,3FH,0FFH,0FFH,0FFH,0FFH,0FEH,0,0
DEFB 0,0,0FH,0FFH,0FFH,0F8H,0,3FH,0FFH,0FFH,0C0H,7,0FFH,0FFH,0FFH,7
DEFB 0C0H,0,0,0,0,7,0FFH,0C3H,0C0H,0,3FH,0FFH,0FFH,0,7,0FFH
DEFB 0FFH,0F8H,1,0FCH,0,0,0,0,1,0FFH,0E0H,0,0,7FH,0F8H,0
DEFB 0,0FH,0FFH,0,3CH,7,0FEH,0,0,0,0,0,7,0FFH,0,0
DEFB 3,0FFH,80H,0,0,0FFH,0C0H,0,1FH,0FFH,0,3,0C0H,0,0,0
DEFB 3,0FFH,0C0H,0,3,0FFH,80H,0,3,0FFH,80H,0,1FH,0FCH,0,1FH
DEFB 0,0,0,0,0,7FH,0F0H,0,1,0FFH,0C0H,0,1,0FFH,0,0
DEFB 7,0FCH,0,0,0,0,0,0,0,0FFH,0E0H,0,3,0FFH,0,0
DEFB 0FH,0FCH,0,0,3FH,0F0H,0,0,70H,0,0,0,0,0FFH,0E0H,0
DEFB 3,0FFH,0,0,1FH,0F0H,0,0,7FH,0E0H,0,3,0C0H,0,0,0
DEFB 0,7FH,20H,0,3,0FEH,0,0,1FH,0F0H,0,0,0FFH,0E0H,0,0
DEFB 0,0,0,0,0,0FEH,20H,0,7,0FEH,0,0,1FH,0FCH,0,0
DEFB 1FH,0E0H,0,0,0,0,0,0,0,0FEH,38H,0,7,0FFH,0C0H,0
DEFB 7,0FEH,0,0,0FH,0E0H,0,0,0,0,0,0,0,0FCH,78H,0
DEFB 7,0FFH,0C0H,0,3,0FEH,0,0,0FH,0C0H,0,0,0,0,0,0
DEFB 1,0F8H,78H,0,3,0FFH,0C0H,0,1,0FEH,0,0,0FH,9EH,0,0
DEFB 0,0,0,0,3,0F0H,0F0H,0,0,0FFH,80H,0,0,7FH,0E0H,0
DEFB 0,3CH,0,0,0,0,0,0,7,0E3H,0C0H,0,0,0FFH,0,0
DEFB 0,3FH,0C0H,0,0,60H,0,0,0,0,0,0,0FH,87H,80H,0
DEFB 3,0FFH,0,0,0,1FH,80H,0,0,0,0,0,0,0,0,0
DEFB 7CH,3EH,0,0,0FH,0FFH,0C0H,0,0,38H,70H,0,0,0,0,0
DEFB 0,0,0,1,0F0H,0F8H,0,0,3EH,7FH,0,0,0,1,0E0H,0
DEFB 0,0,0,0,0,0,0,7,0C3H,0E0H,0,0,0F1H,0FCH,0,0
DEFB 0,0FH,80H,0,0,0,0,0,0,0,0,0FH,8FH,80H,0,0FFH
;----------------------------------------------------------------------------------
;"DREI"
AD_3:
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,83H,0C7H,81H,1FH,8FH,0C3H,0C1H,0F0H,3,0FCH,0
DEFB 0FH,0,0,1FH,0,1FH,0FEH,3FH,0F8H,0,70H,0,0,0,0,0
DEFB 1DH,0FFH,0FFH,0FFH,0FFH,0FFH,0F8H,0FFH,0FFH,0C0H,0C7H,0,0,0,1,0FFH
DEFB 0FFH,0FFH,0,0FH,0FFH,0FFH,0E0H,7FH,0F8H,3,0F0H,0,0,0,0,0
DEFB 0FH,0FFH,9FH,98H,0,7EH,1FH,0FCH,0,38H,1,0FFH,0FEH,0,0,0
DEFB 0,0,0,0,0,1FH,0FFH,3FH,10H,8,7CH,3FH,0F8H,0,70H,7
DEFB 0FFH,0FCH,0,0,0F0H,0,0,0,0,1,0FFH,0F3H,0F1H,0,87H,87H
DEFB 0FFH,80H,0,0,0FFH,0FFH,0F8H,0,0,0,0,0,0,0,1FH,0FFH
DEFB 3FH,10H,1CH,78H,7FH,0F8H,0,0,7,0FFH,0FFH,80H,0,0,0,0
DEFB 0,0,0,7FH,0FCH,0FCH,60H,71H,0E1H,0FFH,0E0H,0,0,4FH,0FFH,0E0H
DEFB 0,0,0,0,0,0,0,0,0FFH,0F9H,0F0H,0C0H,0E1H,0C3H,0FFH,0C0H
DEFB 0,0,0FFH,0FFH,0C0H,0,40H,0,0,0,0,0,1,0FDH,0F1H,0F0H
DEFB 0C0H,0E3H,0C3H,0FFH,0C0H,0,1,0FFH,0FFH,80H,0,0,0,0,0,0
DEFB 0,7,0FFH,0C7H,0C3H,7,0FH,0FH,0FEH,0,0,7,0FFH,0FCH,0,0
DEFB 0,0,0,0,0,0,1FH,0FEH,3EH,18H,1CH,38H,7FH,0F8H,0,0
DEFB 3FH,0FFH,0E0H,0,0,0,0,0,0,0,0,0FDH,0F0H,0F0H,0C0H,0E1H
DEFB 0E3H,0FFH,0C0H,1,81H,0FFH,0FEH,0,0,0,0,0,0,0,0,0FH
DEFB 0DFH,0FH,0CH,0EH,3EH,3FH,0F8H,0,18H,3FH,0FFH,80H,0,0,0,0
DEFB 0,0,0,3,0FFH,0C3H,0C3H,3,8FH,87H,0C0H,0,0FH,8FH,0FFH,0
DEFB 0,0,0,0,0,0,0,1,0FFH,0E0H,0E0H,80H,0F7H,0E3H,0C0H,0
DEFB 7,0E3H,0C0H,0,0,0,0,0,0,0,0,0,7FH,0F8H,70H,0
DEFB 7FH,0F0H,40H,0,7,0F8H,0,0,1CH,0,0,0,0,0,0,0
DEFB 3FH,0FCH,1CH,0,3FH,0F8H,0,0,0FH,0FCH,0,0,38H,0,0,0
DEFB 0,0,0,0,3FH,0BCH,1CH,0,3FH,0F8H,0,0,1FH,0F0H,0,0FH
DEFB 0F8H,0,0,0,0,0,0,0,3FH,38H,18H,0,7FH,0E0H,0,0
DEFB 7FH,80H,0,3FH,0E0H,0,0,0,0,0,0,0,0FCH,70H,70H,1
DEFB 0FFH,0,0,3,0FCH,0,1,0FFH,0,0,0,0,0,0,0,3
DEFB 0F1H,0C0H,0C0H,7,0F8H,0,0,3FH,0E0H,0,3,0FCH,0,0,0,0
DEFB 0,0,0,0FH,0C3H,3,0,3FH,0C0H,0,0,0FEH,0,0,1FH,0C0H
DEFB 0,0,0,0,0,0,0,0FCH,30H,20H,7,0F8H,0,0,1FH,0C0H
DEFB 0,3,0F8H,0,0,0,0,0,0,0,0FH,0C2H,4,0,0FEH,0
DEFB 0,3,0F0H,0,0,7EH,0,0,0,0,0,0,0,3,0F0H,0C0H
DEFB 0,3FH,0,0,0,0F8H,78H,0,1CH,0,0,0,0,0,0,0
DEFB 1,0F8H,60H,0,0FH,87H,80H,0,0,0FCH,0,0,0,0,0,0
DEFB 0,0,0,0,0FCH,38H,0,7,87H,0C0H,0,0,0FEH,0,0,0
DEFB 0,0,0,0,0,0,0,0F8H,78H,0,0,0FH,0C0H,0,0,7CH
DEFB 0E0H,0,0,0,0,0,0,0,0,1,0F0H,0F0H,0,0,1FH,80H
DEFB 0,0,7,0C0H,0,0,0,0,0,0,0,0,7,0C3H,0C0H,0
DEFB 0,7CH,0,0,0,0FH,0EH,0,0,0,0,0,0,0,0,0FH
DEFB 87H,80H,0,0,0E0H,0F0H,0,0,0,3CH,0,0,0,0,0,0
DEFB 0,0,1FH,0FH,0,0,0,1,0F0H,0,0,0,7CH,0,0,0
DEFB 0,0,0,0,0,1FH,1FH,0,0,0,3,0F0H,0,0,0,78H
DEFB 0,0,0,0,0,0,0,0,1FH,0FH,80H,0,0,1,0F8H,0
DEFB 0,0,0,60H,0,0,0,0,0,0,0,7,87H,0E0H,0,0
DEFB 0,7CH,0,0,0,0,0,0,0,0,0,0,0,0,3,0C3H
DEFB 0F0H,0,0,0,0EH,0,0,0,0,0,0,0,0,0,0,0FFH
;-----------------------------------------------------------------------------------
;"VIER"
AD_4:
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0F7H,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0EFH,0FFH,0FFH,0FFH,0EFH,0C7H,0FBH,0E3H
DEFB 0F1H,0F9H,0FFH,0CFH,0DFH,0C3H,0E7H,0CFH,0FEH,0FFH,0BFH,0FFH,0DFH,0F1H,0FFH,0EFH
DEFB 0FFH,0BFH,0DFH,0FFH,0FH,8FH,35H,0E6H,0FEH,3FH,0BFH,3FH,4FH,0FFH,7FH,0FH
DEFB 0E3H,0F9H,0E7H,73H,0FFH,0FFH,0FFH,0EFH,0DFH,0FEH,1FH,31H,0FBH,1FH,0C3H,0FFH
DEFB 39H,7FH,0F0H,0F0H,7EH,1EH,59H,0F4H,31H,0FEH,3FH,7AH,7FH,0D7H,0FCH,0FCH
DEFB 13H,87H,9BH,99H,8FH,86H,38H,1FH,25H,0EDH,1EH,0FH,0EFH,0CFH,0CFH,0FEH
DEFB 7FH,0FFH,7BH,77H,8FH,21H,0DBH,49H,0CBH,5AH,5AH,52H,70H,0F0H,0F8H,18H
DEFB 1EH,1BH,0D3H,0E7H,0F7H,0FEH,0FCH,0EDH,0F4H,0F3H,0DEH,7EH,1EH,3DH,0BEH,7EH
DEFB 7EH,3EH,7,0B0H,7CH,4AH,0C7H,86H,2CH,1EH,11H,91H,0E9H,87H,47H,0C7H
DEFB 0FFH,0FFH,0CFH,0C7H,0C7H,0EFH,5FH,21H,0E0H,40H,20H,60H,16H,0FH,3,0F0H
DEFB 0FCH,33H,0C2H,0,38H,2,0,0EH,73H,0F7H,0FFH,0FFH,0FFH,9FH,0FFH,0FFH
DEFB 0FFH,0FFH,8EH,0,0,0,0,0,0,0,0,42H,70H,70H,79H,0E7H
DEFB 0E7H,0FCH,0FFH,0FFH,0FFH,0FFH,0F3H,0F3H,0FFH,0D7H,0FBH,0FFH,9FH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0C7H,0C7H,0C7H,0FH,7,8FH,0FH,0F1H,0F1H,0FEH,0FH,87H,0C1H
DEFB 0F1H,0F8H,78H,7,3,0,0,0,0,0CH,0FH,0FFH,0FFH,0FFH,0FFH,9CH
DEFB 0,0,0,0,0,0,0,0,1CH,3CH,3FH,3FH,3FH,0C0H,60H,60H
DEFB 3CH,7FH,0FFH,0FFH,0C7H,80H,0,0,0,0,1,0E1H,0E3H,0FFH,0FFH,0FEH
DEFB 1EH,6,7,87H,0FFH,0FFH,0FFH,0F8H,0,0,0,0,0,3,3,0E7H
DEFB 0FFH,0FFH,0FCH,38H,4,1,0FH,0FFH,0FFH,0FFH,0F8H,0,0,0,0,0
DEFB 0,60H,0F8H,0FFH,0FFH,0FFH,0FH,0,0,1,0FFH,0FFH,0FEH,7CH,4,0
DEFB 0,0,0,0,0EH,0FH,1FH,0FFH,0FFH,0F0H,0E0H,0,0CH,1FH,0FFH,0FFH
DEFB 0FBH,0F1H,0C0H,0,0,0,0,0,70H,0F8H,0FFH,0FFH,0FFH,7,0,0
DEFB 0E0H,0FFH,0FFH,0FFH,0FFH,86H,0,0,0,0,0,1,83H,0E3H,0FFH,0FFH
DEFB 0FCH,1CH,0,1,0C3H,0FFH,0FFH,0FFH,0FEH,0,0,0,0,0,0,7
DEFB 7,8FH,0FFH,0F9H,0F8H,30H,0,7,8FH,0FFH,0FFH,0FFH,8,0,0,0
DEFB 0,0,0,0EH,1FH,1FH,0FFH,0F3H,0E0H,60H,0,1FH,9FH,0FFH,0F7H,0E0H
DEFB 60H,20H,3CH,0,0,0,0,1CH,3EH,3FH,0FFH,0E1H,0C0H,60H,30H,3FH
DEFB 0FFH,0FFH,0C1H,0C0H,20H,3EH,3EH,0,0,0,0,78H,78H,0FEH,7FH,3
DEFB 80H,0C0H,0F8H,0FFH,0FFH,8FH,80H,0,0FCH,0FFH,0FEH,0,0,0,1,0E1H
DEFB 0E3H,0F8H,0F8H,2,3,0C3H,0FFH,0FFH,3EH,0,0,0FFH,0FFH,0FEH,0,0
DEFB 0,0,3,0C3H,0E3H,0F0H,0E0H,3,83H,0F7H,0FFH,0FEH,0,1,0CFH,0FFH
DEFB 0FFH,0,0,0,0,0,0FH,87H,0E3H,0F8H,2,3,0C3H,0FFH,0FFH,80H
DEFB 0,0FH,0BFH,0FFH,0C0H,0,0,0,0,0,0FH,8FH,0CFH,0F0H,6,3
DEFB 0FFH,0FFH,0CFH,0,0,1FH,0FFH,0F0H,0,0,0,38H,0,0,3FH,1FH
DEFB 0FFH,0F8H,6,7,0FFH,0FFH,80H,0,0FH,0FFH,0FFH,80H,0,0,0F8H,0
DEFB 0,0,3FH,0BFH,0FCH,0,3,0FFH,0FFH,80H,0,7,0FFH,0FFH,80H,0
DEFB 0FH,0FFH,80H,0,0,0,7FH,0FFH,0F8H,0,0FH,0FFH,0FFH,0,0,3FH
DEFB 0FFH,0FFH,0,3FH,0FFH,0E0H,0,0,0,0,7FH,0FFH,0F8H,1,0FFH,0FFH
DEFB 0F0H,0,3FH,0FFH,0F0H,0,0FFH,0FFH,80H,0,0,0,0,0,7FH,0FCH
DEFB 78H,0,0FFH,0FFH,0F8H,0,0FFH,0FFH,0F0H,3,0FFH,0FFH,0C0H,0,0,0
DEFB 0,0,7FH,0FCH,38H,0,0FFH,0F8H,60H,0,0FFH,0FDH,0C0H,7,0FFH,0F8H
DEFB 0,0,0,0,0,0,7FH,0F8H,0,0C0H,0FFH,0F8H,0,0,7FH,0FCH
DEFB 0,3FH,0FFH,0F8H,0,30H,0,0,0,0,7FH,0F8H,1,0E0H,0FFH,0FFH
;-----------------------------------------------------------------------------------
;"FNF"
AD_5:
DEFB 0FFH,0FEH,3FH,0F8H,10H,80H,1CH,1EH,8,1EH,0,38H,0,0,0,0
DEFB 1FH,7FH,0FFH,0FFH,0F8H,0F8H,7,0C3H,0FFH,0FEH,7FH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 80H,0,3FH,0FFH,0FFH,0FFH,0C0H,6,3,0F3H,0E7H,0FFH,0FFH,0FFH,0FFH,0F0H
DEFB 0CH,0EH,0FH,80H,0,0CH,0,0,0,0,0,0CH,0,0,7FH,0FFH
DEFB 0FCH,0,0,0,0FH,0FFH,0FFH,0FFH,0FFH,0FFH,0FCH,1,0FFH,0FFH,0FFH,0F0H
DEFB 0,0,0,7,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0,0,0,0,0,0,0,0,0,0,0
DEFB 0,0,0,0,0,0,0,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FEH,0,3,0FFH,0FFH,0E0H,0,0,0FH,0FFH,0FFH,0,0
DEFB 0FH,0FFH,0F0H,0,0,0,0,0,7,0FFH,0FFH,0C0H,0,1,0FFH,0FFH
DEFB 0FEH,0,0,3FH,0FFH,0F8H,0,0,0,0,0,0,0FH,0DFH,0FFH,86H
DEFB 0,7,0FFH,0FFH,0F8H,0,0,7FH,0FFH,0F8H,0,0,0,0F0H,0,0
DEFB 0FH,0CFH,0FFH,86H,0,0FH,0FFH,0FFH,0F8H,0,1,0FFH,0FFH,0F8H,0,0
DEFB 77H,0E0H,0,0,7,0E7H,0FFH,7,0,1FH,0FFH,0FEH,0,0,1FH,0FFH
DEFB 0FFH,0C0H,0,0,0FEH,0,0,0,7,0E7H,0FFH,7,0,3FH,0FFH,0FCH
DEFB 0,0,0FH,0FFH,0FFH,80H,0,1EH,0CH,0,0,0,7,0C7H,0FEH,1EH
DEFB 0,7FH,0FFH,0FFH,0C0H,0,0FH,0FFH,0FFH,8CH,0,0,0,0,0,0
DEFB 1FH,1FH,0FCH,7CH,31H,0FFH,0FFH,0FFH,80H,0,0FH,0FFH,0FFH,0FFH,0FFH,80H
DEFB 0,0,0,0,0,7,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FCH,0,0,7
DEFB 0FFH,0FFH,0FFH,0E0H,0,0,0,0,41H,0F7H,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0,0,7,0FFH,0FFH,0FFH,0F8H,0,0,0,0,0,7FH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0E0H,4,0,7FH,0FFH,0FFH,0FEH,0,0,0,0,4,1FH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0F0H,0,0,1FH,0FFH,0FFH,0FFH,80H,0,0
DEFB 0,0,83H,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FEH,0,0FH,4BH,0FFH,0FFH,0FFH
DEFB 0E0H,0,0,0,0,30H,7FH,0FFH,0FFH,0FFH,0FFH,0FFH,0E7H,0C0H,7,0F1H
DEFB 0FFH,0FFH,0FFH,0C0H,0,0,0,0,3,0FH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0F8H,0,7EH,7FH,0FFH,0FFH,80H,0,0,0,0,0,0C3H,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FEH,0,1FH,0FFH,0FFH,0FFH,0E0H,0,0,0,0,0,6
DEFB 3FH,0FFH,0FFH,0FFH,0FFH,0FFH,0E3H,80H,0,7FH,0FFH,0FFH,0FEH,0,0,0
DEFB 0,0,0,1,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0CFH,80H,0,7,8FH,3FH
DEFB 0CH,0,0,0,0,0,0,7,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FEH,0FFH,0FFH,0FBH,0EFH,48H,0,0,0,1,83H,38H,0E3H,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,1EH,76H,3CH,2FH,43H,79H,0FFH
DEFB 0BFH,0FFH,0FFH,0FDH,0FDH,0E8H,70H,0F0H,69H,0E1H,0F2H,0F8H,0F9H,0FFH,0FFH,0CFH
DEFB 0FDH,0F4H,0FDH,9FH,0BFH,7EH,4FH,5EH,3EH,7CH,3CH,3FH,0EH,0F9H,0FAH,0DFH
DEFB 0EFH,8FH,0E7H,0EEH,5DH,0E5H,3CH,37H,0F2H,0F1H,0FFH,7FH,0F1H,0F1H,0E1H,0FFH
DEFB 93H,0FFH,0CFH,0E3H,0FBH,0FFH,0F3H,0F7H,0C7H,0CCH,0FCH,0F0H,3FH,7EH,7CH,3CH
DEFB 38H,78H,0F8H,0F9H,0F1H,0E3H,87H,0E8H,0F4H,0F1H,0F1H,0E3H,0CFH,0C7H,0E3H,0D0H
DEFB 0FDH,0F0H,6CH,1EH,0FCH,0E3H,0C3H,0C7H,0BFH,1EH,1EH,1FH,94H,1CH,38H,78H
DEFB 70H,0E1H,81H,0E0H,8FH,0FH,87H,9CH,0FH,0FEH,1FH,87H,0F0H,30H,3CH,37H
DEFB 0FEH,0FFH,0E7H,0C7H,0C1H,0F1H,0F1H,0E1H,0E2H,0FH,0A5H,0EH,1EH,0EH,1CH,3DH
DEFB 0C1H,0F0H,0D1H,0C3H,0EDH,0EAH,17H,0C1H,0FDH,0A3H,0C3H,0E1H,0F7H,0C3H,0C7H,0FH
DEFB 0,78H,63H,0C3H,0E3H,87H,2,0,1,9,3,47H,98H,0F7H,0DFH,0FFH
DEFB 0FEH,0F2H,0F3H,0F3H,0E3H,0F5H,0CFH,0E3H,8FH,0FH,0BDH,0F1H,0F1H,0E3H,0CBH,83H
DEFB 83H,3,8EH,2,81H,7,0E7H,8EH,1EH,0EH,0,0,0,0CH,3DH,3AH
DEFB 1FH,5,0F8H,3CH,7BH,0E1H,0E9H,0FCH,38H,53H,1,0C1H,3CH,1EH,0FCH,3CH
DEFB 70H,0F8H,0F1H,0F9H,0F7H,8FH,38H,20H,0E0H,83H,0F0H,0FCH,1FH,8FH,92H,0F5H
DEFB 0FH,8EH,0F8H,1EH,7,81H,0E0H,10H,0C1H,83H,8FH,0BEH,7EH,0FFH,7DH,0FFH
;-----------------------------------------------------------------------------------
;"SECHS"
AD_6:
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0F7H,0F3H,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0BFH,7FH,0F3H,0E7H,0CFH,37H,87H,5FH,63H,0E6H,7CH,0EDH,0FDH,0FBH
DEFB 0B7H,33H,0FCH,0BEH,1FH,47H,0F3H,0E6H,0E9H,0EEH,6FH,0EH,0C7H,19H,0B3H,39H
DEFB 0FBH,37H,0E7H,91H,99H,75H,73H,3BH,6FH,93H,37H,7AH,6FH,64H,0CEH,6FH
DEFB 7DH,0BAH,0C9H,0DCH,8EH,0D7H,26H,6DH,0CCH,0C9H,2EH,0C5H,0C9H,0D9H,59H,3BH
DEFB 29H,59H,0B3H,26H,66H,64H,6BH,19H,0EAH,66H,76H,0DAH,46H,75H,0D6H,33H
DEFB 0B3H,33H,2BH,0DBH,0C6H,4FH,0B9H,3FH,9FH,9BH,6FH,0ECH,9EH,9FH,0CFH,0F3H
DEFB 93H,0E3H,0C2H,0ECH,0FCH,0CEH,0B3H,9BH,67H,0CCH,0E9H,0F8H,0F9H,9BH,90H,0DBH
DEFB 83H,0C3H,0F8H,7FH,30H,0FFH,0E1H,0EBH,0F9H,0E1H,97H,82H,7CH,0,9FH,0DBH
DEFB 83H,81H,0FEH,0FH,20H,70H,78H,45H,0C7H,0C3H,0EFH,0FH,4,8,7FH,71H
DEFB 0F0H,0,3,0,7,0,8,3FH,0FFH,0FFH,0FFH,0C0H,0,3,0FFH,9FH
DEFB 0,0,0,0,0,7EH,7FH,0F8H,0E0H,0,0F1H,0CFH,0FFH,9FH,0,3CH
DEFB 7FH,0FFH,0F0H,0,0,0,0,0,0FCH,7FH,0F0H,0E0H,1,0E3H,0DFH,0C6H
DEFB 1CH,7,0FFH,0FFH,0E0H,0,0,1,80H,0,3,0E3H,0FFH,87H,0,0FH
DEFB 9FH,0FCH,0,0,3FH,0FFH,0F0H,0,3,0E8H,0CH,0,0,7,0E3H,0FFH
DEFB 7,0,3FH,9FH,0F8H,0,1,0FEH,0FFH,0,0,1FH,80H,0,0,0
DEFB 1,0F1H,0F1H,81H,80H,1FH,0C7H,0C0H,4,3,0FCH,3FH,0,60H,1FH,0
DEFB 0,0,0,1,0F0H,0F9H,0C1H,0C0H,1FH,87H,0C0H,4,7,0F8H,3CH,0
DEFB 0C0H,7CH,0,0,0,0,0,0F8H,78H,41H,0C0H,7FH,8FH,0C0H,0,0FH
DEFB 0E1H,0F8H,0,0,0E0H,0,0,0,0,1,0F0H,0F0H,3,81H,0F0H,7FH
DEFB 0,0,1CH,1FH,0C1H,0C0H,0,0,0,0,0,0,7,0C3H,0C1H,8
DEFB 0EH,3,0F8H,1CH,0,0,0FCH,3FH,0,0,0,0,0,0,0,1FH
DEFB 0FH,87H,0C0H,30H,0FH,0FH,0E0H,0,0,1,0F8H,78H,0,0,0,0
DEFB 0,0,1CH,1EH,0FH,81H,0C0H,20H,3CH,6FH,0,0,0,3,0C0H,0
DEFB 0,0,0,0,7,87H,0C3H,0E0H,70H,18H,0CH,7,3,80H,0,0
DEFB 0,0,0,0,0,0,3,83H,0C1H,0E0H,70H,10H,8,4,3,1
DEFB 80H,0,0,0,0,0,0,0,0,0,18H,1CH,0EH,0,0,0
DEFB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DEFB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DEFB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DEFB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DEFB 0,0,0,0,0,0,0,0,0EH,0,0,0,0,0,0,0
DEFB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DEFB 0,0,0,0,0,0,1FH,81H,0E0H,0FH,1,0E0H,1CH,3,80H,60H
DEFB 0CH,0,0,0,0,0C0H,0E0H,4,4,0,0,0,0C0H,60H,8,0
DEFB 0,20H,40H,20H,30H,1,0,4,0,0C0H,38H,0CH,0,80H,81H,0C0H
DEFB 28H,6,40H,24H,8,0,62H,2,0,0,20H,0,0,0,0,18H
DEFB 0,8,1,1,0,0,0,0,2,0,40H,0,0,0,0,0
DEFB 4,0,80H,40H,11H,2,42H,0A4H,20H,24H,40H,41H,12H,90H,0,0A0H
DEFB 0A2H,14H,22H,84H,0,2,2,4,0,1,12H,85H,1,11H,22H,52H
DEFB 54H,15H,54H,0CDH,9,8,89H,18H,15H,0AH,10H,81H,80H,81H,51H,2BH
DEFB 22H,0,88H,48H,0C2H,57H,23H,20H,55H,2,74H,0DH,49H,5DH,5AH,0A5H
DEFB 6AH,0C1H,62H,54H,0AH,91H,18H,32H,0A5H,0C6H,0A6H,2CH,0C5H,0E8H,0B5H,0FFH
;"SIEBEN"
AD_7:
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0F7H
DEFB 0E3H,0FEH,1EH,6,30H,0E0H,0C7H,9FH,0FFH,0FFH,0FFH,0F8H,0EFH,99H,0E7H,9CH
DEFB 73H,0DCH,0FFH,0FFH,0FFH,0AFH,78H,7CH,0D3H,0C9H,0EEH,78H,9FH,39H,0EFH,0F8H
DEFB 0EFH,73H,8FH,0E3H,0D3H,0CEH,7BH,0CFH,8FH,18H,0E1H,0C7H,98H,0E7H,0EH,79H
DEFB 0E3H,0F9H,0FDH,0B8H,0E3H,9EH,47H,0B1H,0E3H,3DH,3CH,7BH,0DEH,1FH,94H,71H
DEFB 0EBH,53H,0E7H,0E1H,0FCH,0FBH,98H,0F5H,0EBH,0C7H,0E7H,9CH,7BH,0C7H,98H,0E7H
DEFB 27H,63H,3EH,78H,5CH,0F8H,0E5H,87H,0C7H,0F8H,3DH,0EH,21H,0E0H,77H,1EH
DEFB 43H,0C8H,70H,5FH,89H,0F7H,0BCH,2CH,73H,0F3H,9EH,87H,82H,0F0H,0B0H,5FH
DEFB 43H,0D1H,0FEH,1CH,1FH,0C0H,0E0H,0FEH,1DH,0F8H,0E1H,0F9H,0E6H,0E1H,0F0H,3CH
DEFB 2EH,1EH,0CFH,32H,0BCH,3EH,67H,0B8H,0FEH,1EH,0FH,87H,9CH,7CH,3CH,63H
DEFB 0C3H,0C3H,8EH,1FH,1EH,79H,0F8H,0F3H,0C7H,86H,1CH,0,20H,0,20H,0
DEFB 0,1FH,8FH,9FH,0FFH,0FCH,78H,3CH,0FH,0C7H,0E3H,0C0H,0,0,0,0
DEFB 0,1,0C3H,0C3H,0CFH,0FFH,1EH,1EH,0,0,0F0H,0F0H,0FFH,0FFH,0FFH,86H
DEFB 0,0,0,0,0,7,0FH,0FH,0BFH,0FFH,0F8H,70H,20H,0,0FH,8FH
DEFB 0FFH,0FFH,0F0H,0E0H,0,0,0,0,0EH,0EH,1FH,3FH,0FFH,0F0H,0F0H,40H
DEFB 18H,1EH,3FH,0FFH,0FFH,0F1H,0,0,0,0,0,1CH,3CH,3CH,7FH,0FFH
DEFB 0E1H,0C1H,80H,70H,3CH,3FH,0FFH,0FFH,0E0H,0,0,0,0,0,70H,78H
DEFB 0F8H,0FFH,0FFH,87H,80H,80H,0C0H,78H,0FFH,0FFH,0FFH,0CH,0,0,0,0
DEFB 0,0E1H,0E1H,0F0H,0FCH,0FFH,87H,1,0C0H,0E0H,78H,7FH,7FH,0F7H,0E0H,60H
DEFB 0,0,0,0,70H,78H,3FH,9FH,0F8H,0F8H,0,0,0,7,0FFH,0FEH
DEFB 0,0,1EH,78H,0,0,0,0,0,0,0,7FH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0F0H,0,0,0,0,0,0,0,0,0,0,0,0,0,1FH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,80H,0,0,0,0,0,0,0,0,0,0
DEFB 0,0,0,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0F0H,0,0,0,0,0,6
DEFB 0,0,0,0,0,0,0,1FH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,80H,0
DEFB 0,0,0,0,0,0,0,0,0,0,0,3,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FCH,0,0,0,0,3,0FFH,0C3H,0C0H,0,0,0,0,0
DEFB 1FH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FCH,0,0,0,7FH,0FFH,0FFH,0E0H,0
DEFB 0,0,0,0,1FH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0CFH,0FFH,0C7H,0E0H,7FH
DEFB 0F8H,0FCH,7FH,0DFH,0C0H,0,0,78H,7FH,0FFH,0FFH,7CH,7FH,84H,4,0
DEFB 7,0FFH,0FFH,0F8H,0F0H,60H,0,0,0,0F0H,0FFH,0E7H,0FCH,61H,0F0H,7FH
DEFB 0FFH,0FCH,3EH,21H,0FFH,0FFH,0F1H,0C0H,0,0,0,0F0H,0FFH,0C1H,0F0H,1
DEFB 0E1H,0FFH,0FFH,0E0H,18H,1,0FFH,0FFH,0E0H,0,0,0,80H,87H,7,5EH
DEFB 0FH,0,8FH,0FH,70H,7,0,0C0H,0DFH,1EH,18H,0,80H,0,0,0
DEFB 0C0H,0,0,0,0,78H,78H,0C1H,0E0H,0C7H,0C3H,0C0H,2,3,0C4H,0CH
DEFB 1,0E0H,7CH,0,0,0,0,3,0C3H,0CEH,0EH,0EH,3EH,1CH,0,30H
DEFB 38H,60H,40H,3,3,80H,0,0,0,0,3EH,1EH,60H,70H,63H,0F0H
DEFB 0E0H,1,1,6,0,0,18H,10H,0,0,0,0,1,0E0H,0F3H,7
DEFB 80H,0FH,86H,0,0,0,30H,0,0,0,0,0,0,0,0,0FH
DEFB 0FH,38H,38H,0,0FCH,20H,40H,0,0,0C0H,3,0,0,0,0,0
DEFB 0,0,38H,38H,40H,60H,1,0F0H,1,80H,0,0,0,7,0,0
DEFB 0,0,0,0,0,0,20H,71H,0F3H,0E3H,0E3H,0C3H,87H,0,0,0
DEFB 0,0,0,0,0,0,0,0,0CH,1CH,7CH,78H,0F8H,0F0H,0E1H,0C0H
DEFB 0,0,0,0,0,0,0,0,0,0,3,3,8FH,1FH,3FH,3EH
DEFB 3CH,78H,0,0,0,0,0,0,0,0,0,0,0,0C0H,0E3H,0C7H
DEFB 0CFH,0CFH,8FH,1EH,0,0,0,0,0,0,0,0,0,0,10H,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
;"ACHT"
AD_8:
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,87H,0FFH,0FFH,0FFH,0E7H
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FEH,0FFH,0FFH,0FFH,0FFH,8FH,0FFH
DEFB 7FH,0FFH,0FFH,0FFH,0E7H,0FFH,0F0H,7FH,0FFH,0FFH,0FFH,0FFH,0FCH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,1FH,0FFH,1DH,0FFH,0C1H,0FFH,0FFH,0FDH,4FH,0FFH,0FH,0FEH,7,0FFH
DEFB 0,7FH,0F8H,1FH,0FCH,0FFH,0F7H,0FFH,0FFH,0FH,0FFH,0F8H,7FH,0F0H,7FH,0FEH
DEFB 0,0FDH,0CFH,0E0H,0FH,0FCH,3,0FFH,0,7FH,0C0H,3FH,0C0H,1FH,0F8H,3
DEFB 0FFH,0C1H,0FCH,3,0FFH,0,3FH,0F0H,0FH,0E0H,1FH,0E7H,0FFH,0,7FH,0FFH
DEFB 0C3H,0FFH,0FCH,1,0FFH,0,0,0,0,3,0FFH,80H,0FH,0FCH,78H,0
DEFB 1FH,0FCH,0,3FH,0FFH,0F0H,1,0FFH,80H,0,0,0,3,0FFH,0C0H,0FH
DEFB 0FEH,7CH,40H,7,0FEH,0,18H,7FH,0FCH,0,3FH,0F0H,0,0,0,0
DEFB 0,3,0FFH,80H,0FH,0FEH,38H,0,7,0FEH,0,1CH,0FFH,0FEH,0,3FH
DEFB 0E0H,0,0,0,0,1FH,0FCH,0,7FH,0F3H,0C0H,0,3FH,0F0H,0,3
DEFB 0FFH,0E0H,3,0FEH,0,0,0,0,3,0FFH,80H,7,0FEH,3CH,0,3
DEFB 0FFH,0,0,7FH,0F8H,0,3FH,0C0H,0,0,0,0,0FFH,0E0H,1,0FFH
DEFB 8EH,0,0,0FFH,0C0H,0,3FH,0FCH,0,0FH,0E0H,0,0,0,0,7FH
DEFB 0F0H,0,0FFH,0CFH,0,0,7FH,0E0H,0,1FH,0FCH,0,7,0E0H,0,0
DEFB 0,0,0FFH,0E0H,1,0DFH,9FH,0,0,0FFH,0C0H,0,1FH,0F8H,0,3
DEFB 0C0H,0,0,0,1,0FFH,0C0H,3,9EH,3EH,0E0H,0,0FFH,0C0H,0,38H
DEFB 0,0,0,0,0,0,0,7,0FFH,0,0EH,0F8H,73H,0C0H,0,0FFH
DEFB 80H,1,80H,0,0,0,0,0,0,0,1FH,0FCH,0,1FH,0C0H,1FH
DEFB 80H,1,0FEH,0,0CH,0,0,0,0,0,0,0,0,0FH,0FEH,0
DEFB 1FH,0C0H,7,0E0H,0,0FEH,0,0,0,0,0,0,0,0,0,0
DEFB 1,0FFH,80H,3,0F8H,0,1EH,0,7,0C0H,0,0,0,0,0,0
DEFB 0,0,0,0,7,0F8H,0,0,0,0,0,0,0,0,0,0
DEFB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DEFB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DEFB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DEFB 0,0,0,0,0,0,0,0,3,0,0,10H,0,1,0C0H,0
DEFB 0,0,0,0,0,0,0,0,80H,2,0,0,0,0,0,0
DEFB 0,0,0,20H,0,1,80H,0,40H,0,6,0,0,0,0,0
DEFB 0,0,0,0,0,0,0,0,0,0,3,0,0,30H,0,1
DEFB 80H,0,0,0,0,0,0,0,0,30H,0,0,0,0,0,0
DEFB 0,0,0,0,0,0,0,0,0,0,0,1,8CH,0,16H,0
DEFB 1FH,0C0H,0,40H,0,10H,0,0,0,0,0,0,0C0H,0,0CH,30H
DEFB 0,0,0,0,3,0,18H,20H,40H,20H,0,1,0E1H,3,3BH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0C0H,0EH,3FH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
;"NEUN"
AD_9:
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FEH,0,0,0,0
DEFB 0,0,0,60H,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0,1,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0F0H,0,0,0,0,0,0,7,0FFH,0FFH,0FFH,0FFH,80H,1,0C7H
DEFB 0FFH,0FFH,0FFH,0FFH,0FEH,0,0,0,0,0,0,0,0EH,0FH,0FFH,0FFH
DEFB 0FFH,0FFH,0F3H,0E0H,6,0FH,1FH,0FFH,0FFH,0FFH,0FFH,0E0H,0,0,0,0
DEFB 0,0,18H,7FH,0FFH,0FFH,0FFH,0FFH,80H,0,3FH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0E0H,0,0,0,0,7,7,0FFH,0FFH,0FFH,0FFH,0F8H,0E0H,0,7,87H
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,80H,0,0,0,0,0E0H,0F3H,0FFH,0FFH,0FFH,0FFH
DEFB 0CH,0,0,0F3H,0FFH,0FFH,0FFH,0FFH,0FFH,0F0H,0,0,0,0,30H,39H
DEFB 0FFH,0FFH,0FFH,0FFH,0C0H,0,0,70H,0E3H,0EFH,0FFH,0FFH,0FFH,0F8H,0,0
DEFB 0,0,18H,3BH,0E3H,0FFH,0CFH,9FH,0EH,3CH,10H,70H,63H,0E3H,0FFH,8EH
DEFB 3CH,0,60H,0,0,0,0F0H,0F3H,0E3H,87H,83H,0FFH,6,1CH,1CH,0F8H
DEFB 7FH,0E1H,0FFH,83H,0FEH,0,0,0,0,0,0F8H,71H,0F1H,0C3H,0E1H,0CFH
DEFB 0C0H,7,7,3FH,1CH,7CH,1FH,0FCH,61H,0C0H,0,80H,0,0,1FH,1EH
DEFB 3CH,30H,7CH,70H,0F8H,0,0F1H,0E3H,0F0H,3,0FFH,8FH,0C0H,2,0,0
DEFB 0,0,1FH,9FH,1EH,18H,3FH,3CH,3CH,0,3EH,0F8H,0F8H,40H,0FFH,0F3H
DEFB 0E0H,0,0,0,0,0,1FH,0CFH,0FH,8,1FH,0FCH,1EH,0,1FH,0FCH
DEFB 7CH,20H,3FH,0FCH,0,0,3,80H,0,0,7,0E3H,0C3H,0C1H,7,0FFH
DEFB 3,80H,7,0FFH,0FH,80H,1FH,0FEH,0,0,7,0C0H,0,0,3,0F1H
DEFB 0E1H,0E0H,3,0F3H,0C3H,0C0H,3,0FFH,0CFH,0C0H,0FH,0FFH,80H,0,7,80H
DEFB 0,0,0,0FCH,78H,78H,11H,0FCH,7CH,70H,19H,0FCH,0FFH,0E0H,3FH,0FFH
DEFB 0F8H,0,0,0,0,0,0,0FCH,7CH,78H,38H,0FCH,7EH,30H,1CH,7FH
DEFB 0FFH,8,3FH,0FFH,0FCH,0,0,0CH,0,0,3,0F0H,0F8H,0E0H,0F8H,0F1H
DEFB 0F8H,30H,30H,7FH,0FEH,7CH,1FH,0FEH,7CH,0,0,0,0,0,0FH,87H
DEFB 0C7H,87H,0C3H,0FFH,0C1H,0E0H,1,0F1H,0F9H,0F8H,0F8H,0FDH,0F0H,60H,0,0
DEFB 0,0,0F8H,7CH,3CH,78H,3FH,1FH,1EH,0FH,7,9FH,8FH,0C7H,0E7H,0CFH
DEFB 0C1H,80H,0,0,0,0FH,87H,0C3H,0C3H,83H,0E1H,0F0H,0E0H,0C0H,78H,0FFH
DEFB 0FCH,0FCH,3EH,0EH,30H,0,0,0,1,0F0H,0F8H,7CH,3CH,78H,3EH,1EH
DEFB 0,0EH,0FH,9FH,0FFH,0CFH,81H,0C0H,0,0,0,0,1EH,0FH,0FH,87H
DEFB 0DCH,3FH,87H,0C1H,80H,43H,0E3H,0FFH,0FFH,0F4H,0,0,0,0,0,3
DEFB 0E1H,0F0H,0F0H,0FFH,87H,0C1H,0F0H,0F8H,0EH,1FH,0FFH,0FFH,0FFH,0C0H,0,0
DEFB 0,0,0,3CH,1EH,1FH,0FH,0F8H,7CH,1EH,0FH,0C0H,0F0H,7EH,7FH,0FFH
DEFB 0F0H,0,0,0,0,0,1,0E1H,0F0H,0F8H,0FFH,0C3H,0E0H,0F0H,7,83H
DEFB 0F1H,0FFH,0CFH,0E3H,0FFH,0FFH,0E0H,0,0,0,0,81H,0F3H,0FFH,0FFH,0FFH
DEFB 0FFH,0E0H,0C0H,1,0C1H,0F1H,0FFH,0FFH,0FFH,0FFH,0,0,0,0,10H,1EH
DEFB 7FH,0FFH,0FFH,0FFH,0F8H,38H,0,70H,7CH,0FFH,0FFH,0FFH,0FFH,0E1H,0,0
DEFB 0,3,3,0EFH,0FFH,0FFH,0FFH,0FFH,87H,80H,0FH,0FH,0CFH,0FFH,0FFH,0FFH
DEFB 0FEH,70H,0,0,0,30H,3DH,0FFH,0FFH,0FFH,0FFH,0F8H,78H,1,0F0H,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0C6H,0,0,0,7,7,0DFH,0FFH,0FFH,0FFH,0FFH,87H
DEFB 0,1EH,0FH,0FFH,0FFH,0FFH,0FFH,0FCH,0,0,0,0,70H,7DH,0FFH,0FFH
DEFB 0FFH,0FFH,0F8H,0F1H,0C1H,0F1H,0FFH,0FFH,0FFH,0FFH,0FFH,0F0H,0,0,0,7
DEFB 7,0CFH,0FFH,0FFH,0FFH,0FFH,8EH,1CH,1FH,0FH,0FFH,0FFH,0FFH,0FFH,0FFH,80H
DEFB 0,0,0,30H,3EH,0FFH,0FFH,0FFH,0FFH,0FCH,0E1H,0E0H,0F8H,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0F8H,0,0,0,3,83H,0EFH,0FFH,0FFH,0FFH,0FFH,0FEH,1EH,0FFH
;"ANTON"
AD_A:
DEFB 0FCH,7DH,0FFH,0F1H,0FFH,0E7H,0FFH,80H,0CFH,7FH,0F8H,1,0FFH,3,0FFH,0
DEFB 0E0H,0,0FH,0FEH,4,3EH,0F9H,0E0H,7,0FFH,80H,0CH,7FH,0FFH,0C0H,3FH
DEFB 0FCH,0,0,1,0FFH,0C0H,87H,0DFH,3CH,0,0FFH,0E0H,0,7,0FFH,0
DEFB 7FH,0F8H,40H,0,0C0H,0,0FH,0FEH,6,3CH,7FH,0E0H,7,0FFH,80H,0
DEFB 7FH,0F8H,0,0FFH,0F0H,0,0,0,0FEH,0E0H,0F3H,0C7H,0FEH,3,0FFH,0EH
DEFB 0,1FH,0FFH,80H,7,0FEH,0,0,0,3FH,18H,3CH,0F1H,0F8H,1,0FFH
DEFB 8FH,0C0H,0FH,0FFH,0F8H,1,0FFH,0,0,0,1FH,88H,1CH,39H,0F8H,0
DEFB 0E1H,0FFH,0C0H,0FH,0FFH,0F8H,1,0FFH,0C0H,0,0,1FH,0C4H,1EH,1FH,0FCH
DEFB 0,0,7FH,0C0H,0,1FH,0FCH,0,3,0F0H,0,0,0FH,0C7H,0EH,0FH
DEFB 0FCH,3CH,0,7FH,0E7H,0C0H,1FH,0FFH,0F0H,0,0,0,0,0FH,8FH,1CH
DEFB 1FH,0FCH,0FCH,0,61H,0FFH,0C1H,0FCH,3FH,0F0H,40H,0,0,0,3EH,3EH
DEFB 70H,79H,0FFH,0F0H,0,3,0FFH,0FFH,0C3H,0F8H,0FFH,0,0,0,0,0FCH
DEFB 7FH,0E1H,0F1H,0EFH,0E3H,0FCH,0FH,1FH,0FFH,0FFH,0FFH,0FFH,8CH,0,0,0
DEFB 0,18H,7FH,0FFH,0FFH,0FFH,0FFH,0E0H,0FH,0FFH,0FFH,0FFH,0F0H,0,0,0
DEFB 0,0,7,0FFH,0FFH,0FFH,0FFH,0FCH,1,0FFH,0FFH,0FFH,0FFH,0,0,0
DEFB 0,0,0,3FH,0FFH,0FFH,0FFH,0FFH,0E0H,7,9FH,0FFH,0FFH,0FEH,0,0
DEFB 0,0,0,0,0FFH,0FFH,0FFH,0FFH,0FFH,80H,0,7FH,0FFH,0FFH,0FCH,0
DEFB 0,0,0,0,1,0FFH,0FFH,0FFH,0FFH,0FFH,0,0,7FH,0FFH,0FFH,0F8H
DEFB 0,0,0,0,0,0,7FH,0FFH,0FFH,0FFH,0FFH,0E0H,0,0FH,0FFH,0FFH
DEFB 0FEH,0,0,0,0,0,0,3,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0,0
DEFB 0,0,0,0,0,0,7,0,1,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 80H,0,0,0,3FH,0F0H,0,7CH,0,0,1CH,0,3,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0E0H,0FH,0FFH,0C0H,0E0H,0,0,0,0FFH,0FFH,0FFH,0FEH
DEFB 0,1FH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,9FH,0E3H,80H,0FFH,87H,0FFH,0FFH,0FFH
DEFB 0FFH,0C0H,0,0,1FH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FCH,7,0E0H,0,7FH,0FFH,0FFH,0FFH,1FH,0FFH,0F3H,0FEH,3FH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0F0H,3FH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0F8H,0FCH,0FH,3,0FFH,0BEH,3FH,0F0H,3,1,0E1H,81H,0F0H,7EH,0FH,80H
DEFB 60H,19H,0C1H,0E0H,0,0,0,0FH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FBH
DEFB 0E1H,0E1H,80H,0,0,0,0,0FFH,0FFH,0FFH,0FFH,0F3H,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0,0,0,0,0,0FH,0FFH,0FFH,0F8H,0,7,0FFH,0FFH,0FFH
DEFB 0FEH,1,0FFH,0FFH,0C0H,0,0,0,3,0FFH,0FFH,0F0H,0,0,7FH,0FFH
DEFB 0FFH,80H,0FH,0FFH,0FFH,0C0H,0,0,0,0,7FH,0FFH,0FFH,80H,0,0FH
DEFB 0FFH,0FFH,0,0,3FH,0FFH,0FFH,80H,0,0,0,0,1FH,0FFH,0FFH,0C0H
DEFB 0,7FH,0FFH,0FFH,0,0,0FH,0FFH,0FFH,80H,0,0,0,0,3,0FFH
DEFB 0E7H,0F8H,0,1FH,0FFH,0FFH,0F0H,0,0,7FH,0FFH,0E0H,0,0,3EH,0
DEFB 0,3,0FFH,0EFH,0FCH,0,0FH,0FFH,0FFH,0E0H,0,0,3FH,0FFH,0E0H,0
DEFB 0,3FH,0,0,0,0FFH,0F3H,0FFH,80H,3,0FFH,0FFH,0F8H,0,0,7FH
DEFB 0FFH,0F0H,0,0,3FH,0C0H,0,0,3FH,0FEH,7FH,0E0H,0,0FFH,0FFH,0FEH
DEFB 0,0,7,0FFH,0FEH,0,0,0FH,0F0H,0,0,0FH,0FFH,1FH,0F8H,0
DEFB 3FH,0FFH,0FFH,80H,0,0,0FFH,0FFH,0FEH,0,7,0E0H,0,0,3,0FFH
DEFB 0E7H,0F8H,0,3,0C7H,0FFH,0C0H,0,0,7FH,0FFH,0FFH,0,0,0,30H
DEFB 0,0,0FFH,0FBH,0F8H,0,0,27H,0FFH,0FBH,0E0H,0,7FH,0FFH,0FFH,0
DEFB 0,0,0C0H,0,0,3EH,0FDH,0FEH,0,30H,0FH,0FFH,0FFH,0E0H,0,7
DEFB 0FFH,0FFH,0F0H,0,0,0,0,0,3FH,3FH,0FCH,0,38H,3FH,0FFH,0FEH
DEFB 0,0FH,0FFH,0FFH,0FFH,0,1FH,0C3H,0,0,0,3FH,3FH,0FCH,7,80H
DEFB 7FH,0FFH,0F8H,0,1,0FFH,0FFH,0F8H,0,3,0FCH,0,0,0,3EH,3FH
DEFB 0F8H,7EH,1,0FFH,0FFH,0E0H,0C0H,7,0FFH,0FFH,0FCH,1FH,0FFH,0FCH,0,0
;"BERTA"
AD_B:
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,7,3FH,0FFH,0FFH,0E0H,0,0,1,0FFH,0FEH,0,0,0
DEFB 7FH,0F0H,0,0,0,0,0,7CH,3EH,38H,70H,3FH,0FFH,0FCH,78H,1
DEFB 0FFH,0FFH,0FFH,80H,3FH,0FFH,0C0H,0,0,3FH,1FH,80H,18H,1FH,0FFH,0F8H
DEFB 0,1,0FFH,0FFH,0,0,0FFH,80H,0,0,1,0F8H,7CH,0,0E1H,0FFH
DEFB 0C3H,80H,1FH,0FFH,0F8H,0,3,0FCH,0,0,0,0,0FCH,3CH,20H,0F1H
DEFB 0EFH,0C0H,0,0FH,0FEH,3CH,1,0FFH,0FEH,0,0,0,0,7,0E1H,0E3H
DEFB 3,0FFH,3FH,0,3FH,0FFH,0F0H,3,0FFH,0FCH,0,20H,0,0,0,0FEH
DEFB 18H,70H,3FH,0F1H,83H,1,0FFH,80H,0,3FH,0F0H,1,7,0,0,0
DEFB 0FH,0E0H,7,0,7FH,0E0H,30H,0C3H,0FFH,0,3FH,0FFH,0E0H,7,0E0H,0
DEFB 0,0,0FFH,0C0H,30H,3,0FFH,0,1EH,3FH,0FEH,0,0FFH,0C3H,80H,7
DEFB 0E0H,0,0,1FH,0FCH,0,70H,7FH,0F8H,0,0FFH,0FFH,0FCH,1,0FFH,0C0H
DEFB 80H,0,0,0,0FH,0FFH,0,8,0FH,0FFH,0C0H,3,0FFH,0FFH,0E0H,3
DEFB 0FCH,0,0,0,0,7,0FFH,0C0H,1CH,0,7FH,0FFH,81H,0FFH,7,0FFH
DEFB 3FH,0FFH,0FFH,0FCH,0,0,0,0,3,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0F8H,0,3,0E1H,0E0H,0,0EH,0,0,1FH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0F3H,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0E7H,0C7H,0E0H,0F8H,3FH,7,0C1H
DEFB 0,0,0,0,0,0,0FH,0F7H,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,83H,0
DEFB 0,0,0,3FH,0FFH,0FFH,0F8H,0,7FH,0FFH,0FFH,0F8H,0,0E0H,0,0
DEFB 0,0,1FH,0FFH,0B0H,70H,0,0FFH,0FEH,0EH,0,7FH,0F8H,0,0,0
DEFB 0,0,0FFH,0F0H,3,0,1FH,0FEH,0,0,0FH,0FFH,0,1FH,0FFH,0
DEFB 0,1,0FFH,0E0H,3,0,0FFH,0F8H,0,0,3FH,0FCH,0,7FH,0FFH,0
DEFB 0,0,3FH,0F8H,1,0C0H,7FH,0F8H,1,0C0H,1FH,0FCH,1,0FEH,7FH,0C0H
DEFB 0,0,3,0FFH,80H,4,7,0FFH,80H,8,3,0FFH,80H,3FH,0E7H,0FCH
DEFB 0,0,0,7,0FFH,0,0,1FH,0FEH,0,0,1FH,0FEH,0,0FFH,0FFH
DEFB 0E0H,0,0,0,0FH,0FEH,0,38H,1FH,0FEH,0,3FH,0FFH,0FEH,0,0FFH
DEFB 0C0H,70H,0,0,0,0FH,0FCH,0,0F0H,3FH,0FCH,0,0FFH,0FFH,0FCH,1
DEFB 0FFH,80H,78H,0,0,0,1FH,0FCH,1,0F0H,7FH,0F8H,0,0FFH,0FFH,0F8H
DEFB 3,0FFH,0,7EH,0,0,0,3FH,0F0H,3,0E0H,0FFH,0F0H,1,0FFH,0FFH
DEFB 0F0H,7,0FEH,0,0FEH,0,0,0,0FFH,0E0H,0FH,83H,0FFH,0E0H,7,0FFH
DEFB 0FFH,0E0H,0FH,0FCH,3,0F8H,0,0,7,0FFH,0,3EH,1FH,0FFH,0,1FH
DEFB 0FFH,0FFH,80H,3FH,0E0H,0FH,0E0H,0,0,1FH,0FCH,1,0F8H,0FFH,0FCH,0
DEFB 7FH,0FFH,0FEH,1,0FFH,80H,3FH,0,0,0,0FFH,0E0H,7,0E7H,0FFH,0E0H
DEFB 3,0FFH,0FFH,0F0H,7,0FEH,0,0FCH,0,0,7,0FFH,80H,7CH,0FFH,0FFH
DEFB 0,0FH,0FFH,0FFH,80H,3FH,0F0H,3,0C0H,0,0,7FH,0F8H,3,8FH,0FFH
DEFB 0F8H,0,0FFH,0FFH,0F8H,3,0FFH,80H,8,0,0,7,0FFH,80H,38H,7FH
DEFB 0FFH,80H,7,0FFH,0FFH,0C0H,1FH,0FCH,0,0,0,0,3FH,0FCH,3,83H
DEFB 0FFH,0FCH,0,7FH,0FFH,0FEH,0,0FFH,0C0H,0,0,0,3,0FFH,0E0H,18H
DEFB 1,0FFH,0E0H,3,0FFH,0FFH,0F0H,3,0FFH,3EH,0,0,0,1FH,0FFH,0FFH
;"CSAR"
AD_C:
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FEH,1FH,9FH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0F1H,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FBH,0FDH,0FFH
DEFB 0FFH,0DFH,7FH,0FFH,0FFH,7FH,0FEH,0FFH,0AFH,0FEH,5FH,0D5H,4FH,0DDH,0FFH,0EBH
DEFB 0E9H,0FFH,0FFH,0BBH,0F3H,0FEH,0DFH,0D7H,0FEH,6FH,0E3H,0F6H,4EH,8CH,0F8H,0FDH
DEFB 0BFH,0BBH,0FFH,0FH,7,0D0H,0FCH,3FH,0E3H,0F5H,7FH,5FH,0F0H,78H,76H,0ECH
DEFB 0CDH,87H,0F0H,0F9H,0BFH,0FCH,0F8H,36H,7DH,0B7H,0FEH,0F2H,0F7H,0B7H,0E6H,0E6H
DEFB 0F4H,17H,7,87H,0F1H,0F7H,0E2H,7,9CH,3CH,36H,67H,0F2H,6DH,0FFH,0CFH
DEFB 0FFH,0F1H,0FBH,0E3H,0E0H,1EH,39H,80H,0F0H,0F8H,0EH,1FH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0C1H,0FEH,0EH,0,0,0,0,0FFH,0FFH,0F7H,0F0H,7,87H,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0F0H,0,0,0,0,0FCH,0FFH,0E1H,0C0H,7,8FH,0FFH
DEFB 0FFH,0,7BH,0FFH,0FFH,0E0H,0,0,0,3,0F9H,0FFH,83H,80H,1FH,0FFH
DEFB 0FCH,10H,0,7FH,0FFH,0FCH,0,0,0,0,1,0F8H,0FFH,0C3H,80H,1FH
DEFB 0FFH,0FCH,0,0,0FFH,0FFH,0FCH,0,0,0,0,0,7CH,7FH,0E0H,0E0H
DEFB 7,0FFH,0FEH,0,0,7FH,0FFH,0E0H,0,7,0,0,0,1FH,8FH,0F8H
DEFB 18H,0,0FFH,0FFH,0C0H,0,0FH,0FFH,0FEH,0,0,0F8H,0,0,1,0F8H
DEFB 0FFH,0C1H,80H,0FH,0FFH,0FCH,0,0,0FFH,0FFH,0E0H,0,7,0E0H,0,0
DEFB 0FH,0CFH,0FCH,0CH,0,0FFH,0FFH,0C0H,0,7,0FFH,0FFH,0,0,3EH,0
DEFB 0,0,3EH,3FH,0F0H,60H,3,0FFH,0FFH,0,0,1FH,0FFH,0FCH,0,0
DEFB 0F8H,0,0,3,0F3H,0FFH,83H,0,1FH,0FFH,0FCH,0,0,0FFH,0FFH,0E0H
DEFB 0,0,0,0,0,3FH,3FH,0F8H,78H,1,0FFH,0FFH,0E0H,8,3,0FFH
DEFB 0FFH,0F0H,0,0,0,0,3,0F3H,0FFH,83H,0,0FH,0FFH,0FFH,0F0H,0
DEFB 7,0FFH,0FFH,0,0,0,0,0,3FH,0BFH,0FCH,31H,0C0H,7FH,0FFH,0FFH
DEFB 7,0F8H,7FH,0FFH,0F0H,16H,0,0,0,0,0FFH,0FFH,0FFH,87H,0C1H,0FFH
DEFB 0FFH,0FEH,1FH,0FFH,0FFH,0F9H,0B2H,10H,22H,0,0,0,7FH,0FFH,0FFH,0FFH
DEFB 0F7H,7FH,0FFH,0FFH,7CH,0FFH,7BH,0F6H,0DAH,49H,68H,48H,0,0,3,0FFH
DEFB 7FH,0FFH,0FFH,0FFH,0FFH,0FFH,0FEH,0DBH,0B7H,0B4H,0B6H,64H,6DH,64H,0CH,2
DEFB 0,1,0FFH,0FFH,0FFH,0DFH,0FFH,7FH,0FFH,0DFH,0DAH,0FEH,0FFH,7FH,0B7H,0ECH
DEFB 2,0,0,0,7,0EFH,0FFH,0FFH,0BFH,0FDH,0BFH,0FFH,0FFH,0FFH,0FFH,0F6H
DEFB 0DCH,0A6H,49H,60H,0,0,1,0FFH,8FH,0FEH,1FH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0C0H,20H,0,0,1,0FFH,0FFH,0FEH,0,1FH,0FFH,0FFH,0F0H
DEFB 3,0FFH,0FEH,0,0,0,0,0,1FH,0FEH,0,0E0H,1,0FFH,0F8H,1EH
DEFB 0,1FH,0FFH,0E0H,0,70H,0,0,3,0FFH,0C0H,0EH,0,7FH,0F8H,0
DEFB 0E0H,7,0FFH,0F0H,0,7FH,80H,0,0,3FH,0F8H,0,0E0H,0FH,0FFH,0
DEFB 1FH,0F3H,0FFH,0FEH,8,0,0,0,0,1,0FFH,0C0H,7,80H,7FH,0FCH
DEFB 0,7FH,0E3H,0FFH,0C0H,7FH,80H,3,0,0,0,0FFH,0F0H,1,0FCH,7FH
DEFB 0FFH,0,0FH,0FCH,7FH,0FFH,0FFH,0E0H,3,0F8H,0,0,3,0FFH,0E0H,3
DEFB 0FFH,1FH,0FEH,0,3FH,0F8H,1FH,0FFH,0FEH,0,1FH,0F0H,0,0,3,0FFH
DEFB 0E0H,3,0FEH,0FH,0FFH,80H,0FH,0FCH,7,0FFH,0F0H,0,3FH,80H,0,0FFH
;"DORA"
AD_D:
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FEH,3FH,3,0FFH,0F3H,0C0H,3CH,1
DEFB 0F0H,3,80H,0,0,0,0,0,0,0,3,1,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0F0H,0,0,0,0,0,0,0,3FH,0FFH,0FFH,0FFH,0FCH
DEFB 0,0,3,0FFH,0FFH,0FFH,0FFH,0FFH,1,0FEH,0,0,0,0,0,0
DEFB 3FH,0FFH,0FFH,0FFH,0E0H,0,0,1FH,0FFH,0FFH,0FCH,0,3,0FFH,0FFH,0FEH
DEFB 0,0,0,0,0,0,7FH,0FFH,0FFH,0FEH,0,0,0,7FH,0FFH,0FFH
DEFB 0F0H,0,0FFH,0FFH,0FFH,0F8H,0,0,0,0,0,0,7FH,0FFH,0FFH,0FFH
DEFB 0,0,0,3FH,0FFH,0FFH,0FFH,0,7,0FFH,0FFH,0FFH,0C0H,0,0,0
DEFB 0,0,7,0FFH,0FFH,0FFH,0F8H,0,0FH,0FCH,0FFH,0FFH,0E0H,0,0,1FH
DEFB 0FFH,0FEH,0,0,0,0,0,0,0,3FH,0FFH,0FFH,0FFH,0C0H,0,0FH
DEFB 0FFH,0FFH,0FFH,0C0H,0,0FH,0FFH,0FFH,0FCH,0,0,0,0,0,0,0
DEFB 7FH,0FFH,0FFH,0FFH,80H,0,3FH,0FFH,0FFH,0FFH,0C0H,0,1FH,0FFH,0FFH,80H
DEFB 0,0,0,7EH,0,0,0,0FFH,0FFH,0FFH,0E0H,0,0,3FH,0FFH,0FEH
DEFB 0,0,0,3FH,0FFH,0FCH,0,0,0,0,1EH,0,0,1,0FFH,0FFH
DEFB 0E0H,0,0,0,1FH,0FFH,0FCH,0,0,7,0FFH,0FFH,0FEH,0,0,1
DEFB 80H,0,0,0,0,3FH,0FFH,0F8H,0,0,1,8FH,0FFH,0FFH,80H,0
DEFB 0FH,0FFH,0FFH,0FFH,0,0,3,0FFH,80H,0,0,0,1,0FFH,0FFH,0E0H
DEFB 0,7,0FFH,0FFH,0FFH,0FCH,0,0,7FH,0FFH,0FFH,0,0,0,3FH,0FEH
DEFB 0,0,0,0,3,0FFH,0FFH,0F0H,0,3,0FFH,0FFH,0FFH,0FCH,0,0
DEFB 0FFH,0FFH,0FFH,80H,0,0FH,0FEH,20H,0,0,61H,0,0,3FH,0FFH,0FFH
DEFB 80H,6,1FH,1FH,0FFH,0FEH,0,1,0FFH,0FFH,0FFH,0F8H,0,1FH,0FFH,0E0H
DEFB 3,0FFH,0C6H,0FH,0FFH,0,3FH,0FFH,0FFH,0C0H,7,0FFH,87H,0FFH,0FEH,0
DEFB 7FH,0FFH,0FFH,0F3H,0C7H,0FFH,0FFH,0EFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0CFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0F1H,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0CFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0F7H
DEFB 0E7H,0FFH,0FFH,3EH,70H,7,0FFH,0FEH,18H,7CH,0E1H,0FFH,0FFH,8FH,0FFH,0F8H
DEFB 0FH,0FFH,80H,0FH,0C0H,0FH,0FCH,6,1EH,70H,0,3FH,0FFH,0F0H,43H,0C0H
DEFB 1FH,0FFH,0C0H,3,0FFH,0FFH,0FEH,0,7FH,0F8H,0,1CH,0,0EH,0,0
DEFB 0,3FH,0FFH,0E0H,3,0E7H,0FFH,0FEH,0,3FH,0FFH,0FFH,0F8H,1,0FFH,0E0H
DEFB 1,0F0H,0,3CH,0,0,0,7FH,0FCH,0,0CFH,0FFH,0FFH,0E0H,1,0FFH
DEFB 0F0H,0FFH,0E0H,1FH,0FEH,0,7FH,80H,0,0,0,0,1,0FFH,0E0H,3
DEFB 0FFH,0FFH,0FCH,0,3FH,0FEH,0,9FH,0FFH,0FCH,0,0FFH,0C0H,0,0,0
DEFB 0,0,1FH,0FFH,0,3FH,0FFH,0FFH,0C0H,7,0FFH,80H,0,3FH,0FEH,0
DEFB 7FH,0F0H,0,0,1FH,80H,0,0,0FFH,0F0H,3,0FFH,0FFH,0F8H,0,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0F1H
DEFB 0F1H,0FBH,0FFH,0CFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
;"EMIL"
AD_E:
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,9FH,9FH,0E3H,0C3H
DEFB 87H,0FFH,0FFH,0F1H,0E0H,0,0,0FH,1EH,3FH,0EFH,87H,87H,0DFH,0FFH,0F7H
DEFB 0C0H,0,7FH,0FFH,0FFH,0FFH,0FFH,0E3H,87H,8FH,80H,0,0,2,0,13H
DEFB 0C7H,8FH,0BDH,0F1H,0E1H,0E3H,0FFH,0FDH,0F8H,0E0H,3FH,0FFH,0FFH,0FFH,80H,0
DEFB 0,0,0,3CH,3CH,79H,0CFH,1EH,1EH,1FH,0E7H,0C7H,8FH,0E1H,0F3H,0FFH
DEFB 0FFH,0FCH,70H,0,0,0,0,0,1CH,3CH,7DH,0EFH,0EH,1EH,1FH,0E7H
DEFB 0C7H,8FH,0,0E3H,0FFH,0FFH,0FCH,0E0H,0,0,0,0,0,70H,0F1H,0E7H
DEFB 0FCH,38H,78H,7FH,0DFH,1EH,3CH,3,0FFH,0FFH,0FFH,0F0H,0,0,0,0
DEFB 0,1,0E1H,0E3H,0CFH,0F8H,0F0H,0E1H,0FFH,0FEH,3CH,78H,4FH,0FFH,0FFH,0FFH
DEFB 0E0H,0,0,0,0,0,1EH,1EH,3CH,7FH,0C7H,8FH,0FH,9FH,0E3H,0C7H
DEFB 87H,0FFH,0FFH,0FFH,0FFH,80H,0,0,0,0,0,0FH,0FH,1EH,3FH,0E3H
DEFB 87H,87H,8FH,0F9H,0E1H,0C3H,0CFH,0FFH,0FFH,0FFH,0C0H,0,0,0,0,0
DEFB 1,0E1H,0E3H,0C7H,0FCH,0F0H,0F0H,0F1H,0EFH,3CH,38H,78H,0FFH,0FFH,0FFH,0F8H
DEFB 0,0,0,0,0,0,70H,0F1H,0E3H,0FFH,0F8H,78H,78H,71H,0CFH,1EH
DEFB 1FH,0FFH,0FFH,0FFH,0FCH,0,0,0,0,0,1,0C3H,0C7H,0C7H,0EFH,0FFH
DEFB 0FCH,38H,78H,38H,0F3H,0FFH,0FFH,0FFH,0FFH,0E0H,0,0,0,0,0,0
DEFB 78H,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,1CH,0EH,1FH,0FFH,0FFH,0FFH,0FFH,0FFH,0F8H
DEFB 0,0,0,0,0,4,0FH,0FFH,0FFH,0FFH,0FFH,0FFH,0EEH,0,0,0FH
DEFB 0FFH,0FFH,0FFH,0FFH,0F8H,0,0,0,0,0,0,1FH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,8,0,0,3FH,0FFH,0FFH,0FFH,0FFH,0F0H,0,0,0,0,0,8
DEFB 3FH,0FFH,0FFH,0FFH,0FFH,0FFH,18H,0,0,1FH,0FFH,0FFH,0FFH,0FFH,0F8H,0
DEFB 0,0,0,0,0,1FH,0FFH,0FFH,0FFH,0FFH,0FFH,0,0,0,1FH,0FFH
DEFB 0FFH,0FFH,0FFH,0FCH,0,0,0,0,0,0,1FH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 8CH,0,0,0FH,0FFH,0FFH,0FFH,0FFH,0FEH,0,0,0,0,0,0,0FH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0CCH,0,0,7,0FFH,0FFH,0FFH,0FFH,0FFH,80H,0
DEFB 0,0,0,10H,3CH,7FH,0FFH,0FFH,0FCH,78H,30H,30H,70H,78H,0FFH,0FFH
DEFB 0FFH,0FFH,0E3H,80H,0,0,0,0,0,7,8FH,1FH,0FFH,0FFH,0C7H,87H
DEFB 3,3,0C3H,0E7H,0FFH,0FFH,0FFH,0FFH,0F0H,0,0,0,0,0,0CH,3CH
DEFB 78H,0FFH,0FFH,3EH,3CH,1CH,0EH,0EH,1FH,1FH,9FH,9FH,7FH,0FFH,8EH,0
DEFB 0,0,0,0,30H,0F1H,0E3H,0FFH,0F8H,0F8H,0F0H,3CH,38H,3CH,3EH,3FH
DEFB 3FH,7FH,0FFH,0FFH,1EH,0,0,0,0,0,20H,0F1H,0E7H,0FEH,0FCH,0F8H
DEFB 0F8H,1CH,1CH,3CH,1FH,1FH,9FH,0BFH,0FFH,0DFH,87H,0,0,0,0,0
DEFB 38H,78H,0F9H,0FFH,0FFH,1EH,1EH,0FH,3,83H,0C3H,0E7H,0FFH,0FFH,0FFH,0FFH
DEFB 0FEH,0,0,0,0,0,6,0FH,1EH,3FH,0FFH,0F3H,0E3H,0C0H,0C0H,38H
DEFB 3CH,7FH,0FFH,0CFH,0CFH,0EFH,0F1H,0E0H,0,0,0,0,1,0C1H,0E3H,0E7H
DEFB 0FFH,0FCH,7CH,38H,7,7,87H,0C7H,0F9H,0F9H,0FFH,0FFH,0FEH,0CH,0,0
DEFB 0,0,0,78H,78H,0F9H,0FFH,9FH,8FH,7,40H,0F0H,0F0H,0FFH,3FH,3FH
DEFB 0FFH,0FFH,0FFH,0E0H,0,0,0,0,0,0FH,1FH,1FH,3FH,0F3H,0E1H,0E0H
DEFB 1CH,1EH,1FH,0FH,0E3H,0FFH,0FEH,0FFH,0FFH,8FH,0,0,0,0,0,3
DEFB 0C3H,0C7H,0EFH,0FCH,7CH,3CH,3,0C3H,0E1H,0F8H,7EH,3FH,0E7H,0E7H,0FFH,0F8H
DEFB 0,0,0,0,0,0,1CH,3EH,3FH,0FFH,0E3H,0E1H,0E0H,1EH,1FH,8FH
DEFB 0E0H,0F0H,0FFH,0FFH,0FFH,0FFH,0,0,0,0,0,0,0FH,0FH,8FH,0FFH
DEFB 0,7FH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,80H,1FH,0FFH,0FFH,0CFH,0FFH,0FFH
DEFB 0FFH,0FH,0FFH,0FFH,0FFH,0FCH,0FFH,0F7H,0FCH,7,0FFH,0FEH,1FH,0C1H,80H,40H
;"FRIEDRICH"
AD_F:
DEFB 0DCH,0,0E0H,0FH,7,80H,0FH,1EH,0,0F8H,7BH,0FFH,0EFH,0C0H,1,0F0H
DEFB 0,0,1,0E0H,0,0,0,0,3,0C0H,3FH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FCH,0,0,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0E0H,0,0,0,0,1EH,0,0,0,7FH,0FFH,0FFH,0
DEFB 0,1,0FFH,0FFH,0FFH,81H,0FFH,1FH,0E0H,0,0,0,0,0,1,0E3H
DEFB 0C7H,8EH,1EH,10H,0FH,3CH,0FFH,0E3H,0FEH,7,0FFH,0EFH,80H,0,0,0
DEFB 0,0,3CH,78H,0F1H,0E3H,0C0H,3,0C3H,9FH,3FH,0F8H,3,8FH,0FFH,0FFH
DEFB 0,0,0,0,0,3,0C3H,0C7H,8FH,1EH,1EH,0CH,3CH,79H,0FFH,0FCH
DEFB 1,0FFH,0FFH,0F0H,0,0,0,0,1,0E1H,0E3H,0C7H,8FH,7,7,0EH
DEFB 3CH,7FH,0FCH,70H,0FFH,9FH,0BCH,0,0,0,0,3,0C3H,0C7H,8FH,0FH
DEFB 0EH,0EH,1CH,7DH,0FFH,0F9H,0E1H,0FFH,3FH,30H,0,0,0,0,1EH,1EH
DEFB 3CH,78H,0F8H,70H,70H,0E3H,0FFH,0FFH,0FEH,1EH,7DH,0F0H,0C0H,0,0,0
DEFB 7,87H,87H,9FH,1FH,0EH,1CH,3CH,0FFH,0FFH,0FFH,87H,8FH,3CH,1CH,0
DEFB 0,0,3,0C3H,0C3H,0CFH,8FH,87H,0EH,1EH,7FH,0FFH,0F9H,0E7H,87H,9EH
DEFB 1CH,0,0,0,3,0C3H,0C3H,0CFH,8FH,87H,0EH,1EH,1FH,0FFH,0F9H,0FFH
DEFB 8FH,8FH,0CH,0,0,0,3,83H,0C7H,0CFH,9FH,0EH,0EH,1EH,1EH,7CH
DEFB 0F9H,0FCH,7FH,87H,80H,0,0,0,3,0C3H,0C3H,0FFH,8FH,87H,0EH,0FH
DEFB 0FH,3EH,7EH,3EH,78H,0F0H,60H,0,0,0,0,78H,7CH,0FFH,0F9H,0F0H
DEFB 0F1H,0F1H,0F1H,0E3H,0E3H,0E3H,0E7H,0FFH,0FFH,0CFH,80H,0,0,0,0,78H
DEFB 79H,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0C0H,40H,7,0FH,0FFH,0FFH,0FFH,7EH
DEFB 0,8,18H,7FH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0F8H,0FFH,0FEH,18H,3FH,0FEH,1FH,83H
DEFB 0E1H,0F0H,0F8H,0FH,83H,0F0H,7FH,7,1CH,1FH,7,0E0H,0FCH,0FH,8FH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0F9H,0FEH,1FH,3,80H,0,20H,0,3,0E1H,0FFH
DEFB 0FFH,0E3H,0C7H,0C7H,0E3H,0FFH,0FFH,0FFH,0FFH,9FH,0FH,1EH,4,0,1,0F0H
DEFB 0F9H,0FFH,0F0H,0F0H,0E1H,0E1H,0F9H,0F3H,0F3H,0FFH,0E7H,0E7H,0C7H,0,0,0
DEFB 3,0C3H,0E3H,0FFH,83H,0C3H,87H,87H,0C7H,0CFH,8FH,8FH,9FH,0BFH,1CH,0
DEFB 0,0,0FH,87H,0C7H,0FFH,0FH,87H,0FH,0FH,8FH,9EH,1EH,0FH,0BFH,0FFH
DEFB 18H,0,0,0,3,0E1H,0F1H,0F7H,0C3H,0C1H,0C3H,0C7H,0E3H,0F7H,8FH,3
DEFB 0FFH,0FFH,0F8H,0,0,0,0,78H,3CH,3CH,78H,0F0H,78H,70H,0F9H,0FFH
DEFB 0F3H,83H,1FH,0FFH,0FEH,0,0,0,0,7,0C3H,0C3H,0C7H,8FH,0FH,0FH
DEFB 0FH,3FH,0F1H,0F0H,70H,0FFH,0FFH,0CEH,0,0,0,0,1FH,0FH,0FH,0EH
DEFB 38H,38H,38H,7DH,0FFH,0C7H,83H,83H,0FFH,0FCH,78H,0,0,0,0,7
DEFB 87H,0C3H,0C7H,9CH,3CH,3CH,3FH,0E7H,0C3H,0C3H,0C0H,0FCH,7EH,7CH,0,0
DEFB 0,0,0,3CH,3CH,3EH,1FH,0C1H,0C3H,0C3H,0FEH,7CH,3EH,1CH,1FH,1FH
DEFB 8FH,80H,0,0,0,0,0,0F0H,0F8H,7CH,7FH,0EH,0EH,1,0F9H,0FCH
DEFB 7CH,3CH,1CH,1CH,0,0,0,0,0,0,0,7,0DFH,0EFH,0CFH,0C7H
DEFB 80H,1,0E3H,0FFH,0FFH,0FFH,0FFH,0,0,0,0,0,0,3,83H,87H
DEFB 7,3,0FFH,0FFH,0FFH,0EFH,0C3H,81H,0E3H,0FFH,0FFH,0FFH,0F1H,0C0H,0,1
DEFB 0F9H,0FBH,0FFH,0F0H,0FFH,0FFH,0FFH,0FH,1FH,1FH,1FH,0FFH,0FFH,0CFH,0FFH,0FFH
DEFB 0FFH,0E7H,87H,0FH,0FFH,0CFH,8FH,8FH,3BH,0F1H,0F9H,0CFH,87H,1EH,79H,0FFH
DEFB 0C7H,0E7H,9CH,7DH,0FBH,0C7H,0CFH,0FFH,0FDH,0E7H,1FH,7CH,0FFH,0FFH,0C0H,31H
DEFB 0FFH,0FCH,0F8H,0F1H,0FCH,3FH,0F9H,0F3H,86H,79H,0FFH,87H,0FFH,0FFH,0FFH,0F7H
DEFB 1FH,0FFH,0FFH,0C7H,0C7H,0F8H,7FH,8FH,0FEH,0F8H,1FH,0FCH,30H,0E1H,0E7H,9FH
DEFB 0F8H,0F1H,0FFH,0FFH,80H,38H,0F0H,0C7H,1EH,38H,0F0H,0FEH,0EH,7FH,0E3H,9EH
DEFB 3EH,3,0F1H,0C7H,0FEH,77H,0FFH,8FH,9EH,78H,70H,0E7H,0FFH,0DFH,0FFH,0FH
;"NULL"
AD_0:
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,80H,0,1FH,0FFH,0FFH,0FFH,0C0H,0,0,0
DEFB 0,0,1,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0F0H,0,1,0FFH,0FFH,0FFH,0FCH
DEFB 0,0,0,0,0,0,3FH,0FFH,0FFH,0FFH,0FFH,0FFH,0FCH,0,0,1FH
DEFB 0FFH,0FFH,0FFH,0C0H,0,0,0,0,0,3,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 80H,0,3,0FFH,0FFH,0FFH,0F8H,0,0,0,0,0,0,7FH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0C0H,0,0,3FH,0FFH,0FFH,0FFH,80H,0,0,0,0,0
DEFB 7,0FFH,0FFH,0FFH,0FFH,0FFH,0FCH,0,0,0,0FFH,0FFH,0FFH,0F8H,0,0
DEFB 0,0,0,0,7FH,0FFH,0FFH,0FFH,0FFH,0FFH,0C2H,0,0FH,0DFH,0FFH,0FFH
DEFB 0F0H,0,0,0,0,1,83H,0FFH,0FFH,0FFH,0FFH,0FEH,0,0,0,31H
DEFB 0FFH,0FFH,0FFH,0FFH,0,0,0,0,0,7,8FH,0FFH,0FFH,0FFH,0FEH,78H
DEFB 0,38H,0FH,0FFH,0FFH,0FFH,0FFH,0F8H,0,0,0,0,0,7,0DFH,0FFH
DEFB 0FFH,0FFH,0FCH,1EH,0,1EH,1,0FFH,0FFH,0FFH,0FFH,0FEH,0,0,0,0
DEFB 0,3,0FFH,0FFH,0FFH,0FFH,0FFH,7,80H,7,0C7H,0BFH,0FFH,0FFH,0FFH,0FFH
DEFB 80H,0,0,0,0,0,7FH,0FFH,0FFH,0FFH,0FFH,0E0H,0F0H,0,0F8H,0E7H
DEFB 0FFH,0FFH,0FFH,0FFH,0F8H,0,0,0,0,0,3,0FFH,0FFH,0FFH,0FFH,0FEH
DEFB 7,80H,7,0CFH,0FFH,0FFH,0FFH,0FFH,0FFH,80H,0,0,0,0,0,1FH
DEFB 0FFH,0FFH,0FFH,0FFH,8,1EH,0,3EH,0FH,0FFH,0FFH,0FFH,0FFH,0FFH,0,0
DEFB 0,0,0,0,1FH,0FFH,0FFH,0FFH,0FEH,0CH,38H,1,0FCH,1FH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0F8H,0,0,0,0,0,0FH,8FH,0FFH,0FFH,0FFH,0FH,8
DEFB 7,0,3FH,0FFH,0FFH,0FFH,0FFH,0FFH,0F0H,0,0,0,0,0,7,0E7H
DEFB 0FFH,0FFH,0FFH,7,0C0H,7,80H,7FH,0FFH,0FFH,0FFH,0FFH,0FFH,0F8H,0,0
DEFB 0,0,0,1,0F1H,0FFH,0E7H,0FFH,0C7H,0E0H,3,80H,7FH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0C0H,0,0,0,0,0,7EH,3FH,0FCH,0FFH,0F1H,0F8H,1
DEFB 0E0H,3FH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0E0H,0,0,0,0,8,7,0E1H
DEFB 0FFH,0CFH,0FFH,1FH,80H,3CH,0FH,0FBH,0FFH,0FFH,0FFH,0FFH,0FFH,0FEH,0,0
DEFB 0,0,0,78H,1FH,8FH,0FEH,3FH,0F8H,0FCH,18H,0E0H,7DH,8FH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0E0H,0,0,0,0,7,0C0H,7EH,1FH,0F8H,0FDH,0E3H,0F0H
DEFB 7BH,83H,0E0H,3FH,0FFH,0FFH,0FFH,0FFH,0FFH,8EH,0,0,0,0,3CH,0
DEFB 0F8H,7FH,0E3H,0F3H,0FFH,83H,0C0H,0FH,3,0FFH,7FH,0FFH,0FFH,0FFH,0FFH,0F0H
DEFB 0,0,0,1,0E3H,3,0F0H,0FFH,0C7H,0E7H,0FFH,7,80H,1EH,0FH,0FDH
DEFB 0FFH,0FFH,0FFH,0FFH,0E7H,0C0H,0,0,0,0,0,0FH,87H,0FFH,3FH,0BFH
DEFB 0F8H,3CH,0,0F0H,7FH,0FFH,0FFH,0FFH,0FFH,0FFH,3CH,0,0,0,0,6
DEFB 0,1FH,0FH,0FEH,7EH,7FH,0F0H,70H,3,0C1H,0FFH,0DFH,0FFH,0FFH,0FFH,0F0H
DEFB 0F0H,0,0,0,0,0,0,7CH,3FH,0FFH,0FFH,0FFH,0C3H,80H,0EH,0FH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0C0H,0,0,0,0,0,0,0FH,87H,0FFH,0FFH
DEFB 0FFH,0F8H,70H,1,0C1H,0FFH,0FFH,0FFH,0FFH,0FFH,0F0H,20H,0,0,0,0
DEFB 0,0,0E3H,0FFH,0FFH,0FFH,0FCH,1CH,0,0,7FH,0FFH,0FFH,0FFH,0FFH,0FCH
DEFB 0,0,0,0,0,0,0,78H,0FFH,0FFH,0FFH,0FFH,80H,0,0CH,1FH
DEFB 0FFH,0FFH,0FFH,0FFH,0FEH,6,0,0,0,0,0,0,1FH,3FH,0FFH,0FFH
DEFB 0FFH,0C0H,0,3,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0E7H,0F0H,0,0,0,0
DEFB 0,3,0FFH,0FFH,0FFH,0FFH,0FCH,0,0,7FH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0,0,0,0,0,0,7,0FFH,0FFH,0FFH,0FFH,0FEH,0FH,0C1H,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FEH,0,0,0,0,0,0,3FH,0EFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FEH,0,0,0,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
DEFB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH

