;SPRACHAUFZEICHNUNG UND WIEDERGABE
;MIKRO MIT VERSTRKER AN DER TONBANDBUCHSE
;AUFNAHMEDAUER ABGHNGIG VOM VERFGBAREN SPEICHER
;QUELLE: LLC1, ABGESPECKT UND AUF LC-80EX PORTIERT
;FUER TAKTFREQUENZ 1,8 MHZ
;------------------------------------------------- 
SPIOBDATA:EQU   #F5             ;B0=TAPE IN
                                ;B1=TAPE OUT
DAK1:   EQU     #045A           ;ANZEIGE FORTLAUFEND, WARTEN AUF TASTE
DAK2:   EQU     #0483           ;BEDIENUNG ANZEIGE 1X
DATLED: EQU     #23F2           ;ANZEIGESPEICHER DATEN
RAM_A:  EQU     #2400           ;RAM-ANFANG
;-------------------------------------------------
ORG     #2000
;-------------------------------------------------
        JP      START
RAMEND: DEFW    #7FF0           ;RAM-ENDE
START:  LD      HL,MSG1         ;MELDUNG "RECORD"
        CALL    COPYTXT         ;    
        CALL    DAK1            ;ANZEIGE + WARTEN AUF TASTE
        CP      #10             ;+ GEDRCKT?
        JP      NZ,0            ;NEIN, RESET
        CALL    RECORD          ;JA, AUFZEICHNUNG BEGINNT
        ;ENDE WENN SPEICHER VOLL!
LOOP:   LD      HL,MSG2         ;MELDUNG PLAY
        CALL    COPYTXT         ;UMLADEN
        CALL    DAK1            ;ANZEIGE, WARTEN 
        CP      #10             ;"+" ?
        JR      Z,PL1           ;JA=> ABSPIELEN
        CP      #11             ;"-" ? 
        JR      Z,START         ;JA=> NEUE AUFNAHME
        JP      0               ;ANSONSTEN RESET
PL1:    CALL    PLAY            ;WIEDERGABE DES GERADE GESPROCHENEN TEXTES
        JR      LOOP
;-------------------------------------------------        
RECORD: LD      DE,(RAMEND)     ;ENDEADRESSE WORT
        LD      HL,RAM_A        ;ANFANGSADRESSE WORT
        LD      B,08H
MR1:    NOP              		;VERZGERUNGS-FLLBEFEHLE
        NOP 
        NOP         
LESEN:  IN      A,(SPIOBDATA)   ;PIO LESEN
        BIT     0,A             ;PEGEL VOM TONBAND
        JR      NZ,ML1          ;
        SLA     (HL)            ;ABLEGEN+ROTIEREN
        JR      ML2
ML1:    SCF                     
        RL      (HL)            ;ABLEGEN+ROTIEREN
        NOP
ML2:    DEC     B
        JR      NZ,MR1      
        INC     HL
        LD      B,08H
        LD      A,L
        CP      E
        JR      NZ,LESEN    
        LD      A,H
        CP      D               ;ENDADRESSE ERREICHT?
        JR      NZ,LESEN        ;NEIN
        RET
;-------------------------------------------------
;AUSGEBEN WORT AB ADRESSE 
PLAY:   LD      DE,(RAMEND)
        LD      HL,RAM_A
        LD      B,08H           ;8 BITS
MP1:    NOP
MP2:    RLC     (HL)            ;HOLEN+ROTIEREN
        JR      NC,MP3      
        IN      A,(SPIOBDATA)   ;PIO LESEN
        OR      00000010B       ;SOUNDBIT SETZEN
        JR      MP4             
MP3:    IN      A,(SPIOBDATA)   ;PIO LESEN
        AND     11111101B       ;SOUNDBIT RCKSETZEN        
MP4:    OUT     (SPIOBDATA),A 
        DEC     B
        JR      NZ,MP1          ;BYTE NOCH NICHT FERTIG AUSGEGEBEN
        NOP
        NOP
        INC     HL              ;NCHSTES SOUNDBYTE
        LD      B,08H
        LD      A,L
        CP      E
        JR      NZ,MP2           
        LD      A,H
        CP      D               ;FERTIG AUSGEGEBEN?
        JR      NZ,MP2          ;NEIN
        RET
;-------------------------------------------------
;SCHREIBE STRING IN ANZEIGESPEICHER
;KOMMT MIT HL=TEXTANFANG 
COPYTXT:LD      DE,DATLED  
        LD      BC,0006H
        LDIR
        LD      IX,DATLED       ;
        RET
;-------------------------------------------------
MSG1:   DEFB    #e9,#48,#e8,#c6,#ce,#48 ;RECORD
MSG2:   DEFB    #00,#00,#ab,#6f,#c2,#4f ;PLAY  
