;LC-80ex SIO-Test V2
;Autor: KK Chemnitz
;Januar 2015

;Funktionstest der seriellen Schnittstelle des LC-80ex
;Baudrate und Modus knnen zum Programmstart per Taste gewhlt werden.
;ausgelegt fr 921,6 kHz Taktfrequenz

;Baudraten:
;	1 - 300 Baud
;	2 - 600 Baud
;	3 - 1200 Baud
;	4 - 2400 Baud
;	5 - 4800 Baud
;	6 - 9600 Baud

;Funktionsmodi:
;	1 - Empfang, empfngt fortlaufend Zeichen und zeigt sie an
;	2 - Senden, wartet auf Tastendruck und sendet den Hex-Code der Taste
;	3 - Loopback, empfngt fortlaufend Zeichen und sendet sie sofort wieder


						;Unterprogramme des LC-80 Monitors
monmus:     equ 04eah	;Anfangsmusik
dak1:       equ 045ah	;Displayanzeige/Tastenabfrage mit Warten
dak2:       equ 0483h	;Displayanzeige/Tastenabfrage ohne Warten
oneseg:     equ 04cah	;wandelt unteres Nibble von A in 7-Segment-Code
twoseg:     equ 04d9h	;wandelt beide Nibbles von A in 7-Segment-Code
dadp:       equ 04c3h	;beschreibt den Datenanzeigespeicher
adrsdp:     equ 04b7h	;beschreibt den Adressanzeigespeicher
ramchk:     equ 0452h	;testet, ob Adresse im RAM liegt
sound:      equ 0376h	;gibt Ton aus
sound1k:    equ 0370h	;gibt 1kHz Ton aus
sound2k:    equ 0374h	;gibt 2kHz Ton aus
music:      equ 04eeh	;spielt Musik ab

vram:       equ 23f2h	;Adresse Anzeigespeicher

						;I/O-Adressen der Peripherie
define spioactrl=0f6h	;System-PIO A Control
define spiobctrl=0f7h	;System-PIO B Control
define spioadata=0f4h	;System-PIO A Daten
define spiobdata=0f5h	;System-PIO B Daten
define upioactrl=0fah	;User-PIO A Control
define upiobctrl=0fbh	;User-PIO B Control
define upioadata=0f8h	;User-PIO A Daten
define upiobdata=0f9h	;User-PIO B Daten
define sioactrl=0deh	;SIO A Control
define siobctrl=0dfh	;SIO B Control
define sioadata=0dch	;SIO A Daten
define siobdata=0ddh	;SIO B Daten
define ctc0=0ech		;CTC Kanal 0
define ctc1=0edh		;CTC Kanal 1
define ctc2=0eeh		;CTC Kanal 2
define ctc3=0efh		;CTC Kanal 3

define ctc0ctrl=00000111b	;Kanalsteuerwort CTC 0 (EI,M,V,F,T,TC,R,I)

org 2000h                	;Startadresse
main:         

menue:                      ;Auswahlmen
          ld hl,string_baud ;Schreibe String fr Baudrate in Anzeigespeicher
          ld de,vram        ;
          ld bc,0006h       ;
          ldir              ;
		  
menue1:						;Auswahl der Baudrate
          ld ix,vram		;lade Adresse Anzeigespeicher
          call dak1         ;zeige an und warte auf Taste
		  ld ix,timeconst0	;lade Adresse Zeitkonstante CTC0 nach IX
		  inc ix			;inkrementiere IX (Zeiger Wertetabelle)
		  cp 1				;Taste 1 gedrckt?
          jr z,menue2       ;wenn ja, weiter bei menue2    
          inc ix
		  cp 2				;Taste 2 gedrckt?
          jr z,menue2
		  inc ix
 		  cp 3				;Taste 3 gedrckt?
		  jp z,menue2
		  inc ix
		  cp 4				;Taste 4 gedrckt?
		  jr z,menue2           
          inc ix
		  cp 5				;Taste 5 gedrckt?
          jr z,menue2
		  inc ix
 		  cp 6				;Taste 6 gedrckt?
		  jp z,menue2
          jr menue1         ;ansonsten zurck 		  

menue2:		  
		  ld a,(ix)			;lade der Baudrate entprechende Zeitkonstante
		  ld ix,timeconst0	;aus Tabelle und schreibe sie in die
		  ld (ix),a			;Speichervariable (wird in init_ctc verwendet)
		  
		  call init_ctc		;CTC initialisieren
		  nop
		  call init_sio		;SIO initialisieren
          sub a				;A lschen
          ld (rec_flag),a	;Receive Flag lschen
		  
		  ld hl,string_func ;Schreibe String fr Funktion in Anzeigespeicher
          ld de,vram        ;
          ld bc,0006h       ;
          ldir              ;
menue3:						;Auswahl Funktionsmodus
          ld ix,vram		;lade Adresse Anzeigespeicher
          call dak1         ;zeige an und warte auf Taste
          cp 1
          jr z,rx           ;wenn "1" gehe zu Empfang (rx)
          cp 2
          jr z,tx           ;wenn "2" gehe zu Senden (tx)
 		  cp 3
		  jp z,loopb     	;wenn "3" gehe zu Loopback (loopb)
          jr menue3         ;ansonsten zurck 

rx:                        	;empfngt fortlaufend Zeichen und zeigt sie an
          ld hl,string_rec 	;Schreibe String fr Empfang in Anzeigespeicher
          ld de,vram       	;
          ld bc,0006h      	;
          ldir             	;
          ld a,00000011b	;SIO Register WR3 auswhlen
          out (siobctrl),a
          ld a,11000001b	;8 Datenbits Rx, Empfngerfreigabe
          out (siobctrl),a
rx1:
          call rec_char    	;Unterprogramm 1 Zeichen empfangen
          ld c,a           	;sichere A nach C
          ld  a,(rec_flag) 	;lade Receive Flag in A
          cp 1             	;Flag gesetzt?
          jr nz,rx2        	;wenn nicht weiter bei rx2
          ld a,c           	;restore A aus C
          call dadp        	;schreibe Inhalt von A in Datenanzeigespeicher
          sub a            	;lsche A
          ld (rec_flag),a  	;lsche Receive Flag
rx2:
          ld ix,vram       	;lade Adresse Anzeigespeicher
          call dak2        	;Unterprogramm Anzeige
          jr   rx1

tx:                        	;wartet auf Tastendruck und sendet den Code
							;der gedrckten Taste hexadezimal
          ld hl,string_send	;Schreibe String fr Senden in Anzeigespeicher
          ld de,vram		;
          ld bc,0006h		;
          ldir				;
		  ld a,00000101b	;SIO Register WR5 auswhlen
          out (siobctrl),a
          ld a,01101000b	;8 Datenbits Tx, Senderfreigabe
          out (siobctrl),a
tx1:
          ld ix,vram       	;lade Adresse Anzeigespeicher
          call dak1        	;Anzeige und Warten bis Taste gedrckt
          ld c,a           	;lade C aus A zur spteren Verwendung
          call dadp
          call send_char   	;Unterprogramm Zeichen senden
          jr tx1

		  
loopb:                  	;empfngt ein Zeichen und sendet es wieder         
		  ld a,00000011b	;SIO Register WR3 auswhlen
          out (siobctrl),a
          ld a,11000001b	;8 Datenbits Rx, Empfngerfreigabe
          out (siobctrl),a
		  ld a,00000101b	;SIO Register WR5 auswhlen
          out (siobctrl),a
          ld a,01101000b	;8 Datenbits Tx, Senderfreigabe
          out (siobctrl),a
loopb1:         
          call rec_char		;Unterprogramm Zeichen empfangen
          ld c,a			;sichere A in C
          ld  a,(rec_flag)	;lese Receive Flag
          cp 1				;Flag gesetzt?
          jr nz,loopb1		;wenn nicht, polle weiter
          ld a,c			;restore A aus C
          call send_char	;sende Inhalt von A (vorher empfangenes Zeichen)
          sub a				;lsche A
          ld (rec_flag),a	;lsche Receive Flag
          jr   loopb1

init_ctc:
          ld a,ctc0ctrl		;lade Kanalsteuerwort CTC 0 nach A
          out (ctc0),a		;schreibe in CTC Kanal 0
		  ld ix,timeconst0	;lade Adresse Zeitkonstante
          ld a,(ix)			;lade Zeitkonstante CTC 0 nach A
          out (ctc0),a		;schreibe in CTC Kanal 0
          ret

init_sio:
          ld a,00011000b	;Kanal rcksetzen
          out (siobctrl),a
          nop
          ld a,00000100b	;Register WR4 auswhlen
          out (siobctrl),a
          ld a,00000100b	;1 Stopbit, keine Paritt, Vorteiler 1
          out (siobctrl),a
          ld a,00000011b	;Register WR3 auswhlen
          out (siobctrl),a
          ld a,11000000b	;8 Datenbits Rx
          out (siobctrl),a
          ld a,00000101b	;Register WR5 auswhlen
          out (siobctrl),a
          ld a,01100000b	;8 Datenbits Tx
          out (siobctrl),a
          ret

send_char:
          ld a,00000000b	;Register RR0 auswhlen
          out (siobctrl),a
          in a,(siobctrl)	;Register RR0 lesen
          bit 2,a			;Sendepuffer leer?
          jr z, send_char	;wenn nicht, weiter pollen
          ld a,c			;lade zu sendendes Byte aus C
          out (siobdata),a	;sende Byte
          ret

rec_char:
          ld a,00000000b	;Register RR0 auswhlen
          out (siobctrl),a
          in a,(siobctrl)	;Register RR0 lesen
          bit 0,a			;Zeichen empfangen?
          ret z				;wenn nicht, verlasse Unterprogramm
          ld a,1
          ld (rec_flag),a	;setze Receive Flag
          in a,(siobdata)	;lese empfangenes Byte
          ret

rec_flag:
          defb 0			;Receive Flag, signalisiert Empfang eines Bytes
		  
timeconst0:
		  defb 0			;Zeitkonstante CTC0 
							;Wertetabelle (fr 921,6 kHz Taktfrequenz)
		  defb 0C0h			;C0h = 300 Baud
		  defb 060h			;60h = 600 Baud
		  defb 030h			;30h = 1200 Baud
		  defb 018h			;18h = 2400 Baud
		  defb 00Ch			;0Ch = 4800 Baud
		  defb 006h			;06h = 9600 Baud
		  
string_send:
          defb 0			;blank
          defb 0			;blank
          defb 233			;"d"
          defb 104			;"n"
          defb 206			;"E"
          defb 174			;"S"
          
string_rec:
          defb 0			;blank
          defb 0			;blank
          defb 0			;blank
          defb 200			;"c"
          defb 206			;"E"
          defb 72			;"r"

string_func:
          defb 16			;"."
          defb 202			;"t"
          defb 200			;"c"
          defb 104			;"n"
          defb 224			;"u"
          defb 78			;"F"
 
string_baud:
		  defb 0			;blank
          defb 0			;blank
		  defb 233			;"d"
		  defb 224			;"u"
		  defb 111			;"A"
		  defb 234			;"b"
		  
		