;*************************************************
;LC-80ex-Timekeeper 
;*************************************************
;TIMRAM: equ 1000h  ;M48T02=2k sRAM+Uhr
TIMRAM: equ 2000h   ;M48T08=8k sRAM+Uhr

RAMADR: equ 6000h   ;Speicher auf 6000...
;Start:
;ADR 6000: normaler Start (Anzeige)
;           Uhrzeit wird stndig in der LED-Anzeige akltualisiert
;           Abbruch durch RESET 
;ADR 6003: Stellen (Abfrage Datum/Zeit, immer mit + weiter)
;           JAH.xx
;           MON.xx
;           TAG.xx
;           WOT.xx
;           STD.xx
;           MIN.xx
;           SEK.xx => Uhr luft nun an
;*************************************************
;UP DES LC-80
DAK1:   EQU 045AH       ;BEDIENUNG ANZEIGE FORTLAUFEND, WARTEN AUF TASTE
DAK2:   EQU 0483H       ;BEDIENUNG ANZEIGE 1X
ONESEG: EQU 04CAH
TWOSEG: EQU 04D9H
DADP:   EQU 04C3H
ADRSDP: EQU 04B7H
RAMCHK: EQU 0452H
;--------------------------------------------------
;ARBEITSZELLEN
DATLED: EQU 23F2H       ;ANZEIGESPEICHER DATEN
ADRLED: EQU 23F4H       ;ANZEIGESPEICHER ADRESSE
;-------------------------------------------------
RAMEND: equ RAMADR+TIMRAM-1 ;Jahr
;-1                         ;Monat
;-2                         ;Tag
;-3                         ;Wochentag
;-4                         ;Stunde
;-5                         ;Minute
;-6                         ;Sekunde
;-7                         ;Control
;-------------------------------------------------
ORG RAMADR
;-------------------------------------------------
A6000:  JP      RUN             ;Endlosanzeige
A6003:  JP      SETZE           ;Stellen der Uhr    
A6006:  JP      DISPLAY         ;Zeit abrufen in LED
;-------------------------------------------------
SETZE:  LD      HL,RAMEND-7
        SET     7,(HL)          ;Aktualisierung stoppen

        CALL    JAHR            ;Anzeige JAH 16
        CALL    DAT_EIN         ;Daten JAHR eingeben
        LD      (RAMEND),A      ;ablegen
        
        CALL    MONAT           ;Anzeige MON 16
        CALL    DAT_EIN         ;Daten MONAT eingeben
        LD      (RAMEND-1),A    ;ablegen
        
        CALL    TAG             ;Anzeige TAG 01
        CALL    DAT_EIN         ;Daten TAG eingeben
        LD      (RAMEND-2),A    ;ablegen
        
        CALL    WOTAG           ;Anzeige WOT 00
        CALL    DAT_EIN         ;Daten WOCHENTAG eingeben
        LD      (RAMEND-3),A    ;ablegen
        
        CALL    STUNDE          ;Anzeige STD 12
        CALL    DAT_EIN         ;Daten STUNDE eingeben
        LD      (RAMEND-4),A   ;ablegen
        
        CALL    MINUTE          ;Anzeige MIN 00
        CALL    DAT_EIN         ;Daten MINUTE eingeben
        LD      (RAMEND-5),A   ;ablegen
        
        CALL    SEKUNDE         ;Anzeige SEK 00
        CALL    DAT_EIN         ;Daten SEKUNDE eingeben
        LD      (RAMEND-6),A    ;ablegen

        ;Freigabe Aktualisierung und Anlaufen Uhr
        LD      HL,RAMEND-7
        RES     7,(HL)          ;W=0 => Aktualisierung freigeben
        INC     HL
        RES     7,(HL)          ;ST=0 => Uhr luft an
RUN:    CALL    DISPLAY         
        jr      RUN             ;stndig ausgeben
;-------------------------------------------------
;Routine fr externes Auslesen+Anzeigen der Uhrzeit
DISPLAY:ld      ix,DATLED       ;Anzeigespeicher
        LD      HL,RAMEND-7
        SET     6,(HL)          ;Aktualisierung stoppen
        ;Transfer der Uhrenwerte in Anzeigezellen:
        LD      HL,RAMEND-4     ;Stunde 
        LD      A,(HL)          ;holen
        LD      HL,ADRLED+2     ;hierhin
        CALL    TWOSEG          ;ablegen

        LD      HL,RAMEND-5     ;Minute 
        LD      A,(HL)          ;holen
        LD      HL,ADRLED       ;hierhin
        CALL    TWOSEG          ;ablegen

        LD      HL,RAMEND-6     ;Sekunde 
        LD      A,(HL)          ;holen
        LD      HL,DATLED       ;hierhin
        CALL    TWOSEG          ;ablegen

        ;Punkte ergnzen (hh.mm.ss)
        ld      hl,ADRLED 
        set     4,(hl)   
        inc     hl
        inc     hl
        set     4,(hl)     

        LD      HL,RAMEND-7
        RES     6,(HL)          ;Aktualisierung freigeben
        CALL    DAK2            ;Anzeigen
        RET
;-------------------------------------------------
;Daten eingeben (2stell.)
DAT_EIN:  CALL  DAK1            ;ANZEIGE + WARTEN AUF TASTE
          CP    #10             ;"+" GEDRCKT?
          JR    Z,D_1           ;JA=> FERTIG MIT EINGABE
          CP    #0A
          JR    NC,DAT_EIN      ;> 9? (NUR 0...9 VERARBEITEN)
          ;JETZT IST TASTENCODE 0...9 IN A
          PUSH  AF
          LD    A,(DATLED)      ;ALTE DATEN
          LD    (DATLED+1),A    ;links schieben 
          POP   AF              ;neue Daten
          CALL  ONESEG          ;CODIEREN 
          LD    (DATLED),A
          CALL  DAK2
          JR    DAT_EIN        ;WEITERE EINGEBEN
D_1:    ;EINGABE BEENDET
        ;NUN DIE IM DATENSPEICHER ABGELEGTEN 2 INTERNEN CODES
        ;IN BCD-ZAHL WANDELN:
        LD   A,(DATLED)         ;unteres Nibble
        LD   HL,SEGTAB         ;TABELLENANFANG
        LD   D,H
        LD   E,L
        LD   BC,16             ;16 WERTE
        CPIR                   ;DURCHSUCHEN
        SBC  HL,DE 
        DEC  HL
        LD      A,L             ;merken
        PUSH    AF              ;A=00...09
        LD  A,(DATLED+1)        ;HWT
        LD   HL,SEGTAB          ;TABELLENANFANG
        LD   D,H
        LD   E,L
        LD   BC,16              ;16 WERTE
        CPIR                    ;DURCHSUCHEN
        SBC  HL,DE 
        DEC  HL
        LD  A,L                 ;A=0...9
        RLCA
        RLCA
        RLCA
        RLCA
        LD  B,A
        POP AF
        OR  B       ;in A nun BCD-Code
        RET  
;-------------------------------------------------
;INFOTEXT ANZEIGEN
JAHR:   LD    HL,T_JAHR
        JR    MSG
MONAT:  LD    HL,T_MONAT
        JR    MSG
TAG:    LD    HL,T_TAG
        JR    MSG
WOTAG:  LD    HL,T_WOT
        JR    MSG
STUNDE: LD    HL,T_STUNDE
        JR    MSG
MINUTE: LD    HL,T_MINUTE
        JR    MSG
SEKUNDE:LD    HL,T_SEKUNDE
MSG:    CALL  COPYTXT         ;UMLADEN
        LD    IX,DATLED       ;
        CALL  DAK2            ;ANZEIGEN
        RET
;-------------------------------------------------
;SCHREIBE STRING IN ANZEIGESPEICHER
;KOMMT MIT HL=TEXTANFANG 
COPYTXT:  LD    DE,DATLED  
          LD    BC,0006H
          LDIR
          RET   
;-------------------------------------------------
T_JAHR:  DEFB   #EE,#21,0,#6B,#6F,#E1   ;JAH 16 
T_MONAT: DEFB   #21,#E7,0,#68,#E8,#6C   ;MON 01
T_TAG:   DEFB   #21,#E7,0,#E6,#6F,#CA   ;TAG 01  
T_WOT:   DEFB   #E7,#E7,0,#CA,#E8,#E4   ;WOT 00
T_STUNDE:DEFB   #CD,#21,0,#E9,#CA,#AE   ;STD 12
T_MINUTE:DEFB   #E7,#E7,0,#68,#20,#6C   ;MIN 00
T_SEKUNDE:DEFB  #E7,#E7,0,#CB,#CE,#AE   ;SEK 00
;-------------------------------------------------
;7-SEG-CODES FR ANZEIGESPEICHER
SEGTAB: 
   DEFB #E7      ; 0
   DEFB #21      ; 1
   DEFB #CD      ; 2
   DEFB #AD      ; 3
   DEFB #2B      ; 4
   DEFB #AE      ; 5
   DEFB #EE      ; 6
   DEFB #25      ; 7
   DEFB #EF      ; 8
   DEFB #AF      ; 9
   DEFB #6F      ; A
   DEFB #EA      ; B
   DEFB #C6      ; C
   DEFB #E9      ; D
   DEFB #CE      ; E
   DEFB #4E      ; F
   
