;RAM-TEST PC1715 org 1000 fr V.24 oder org 0 fr ROM
;Ausgabe in 4 Blcken zu 8 bit  wie
;Anordnung auf Platine Blick von vorn
;links nach rechts
;0-3ffff 4000-7fff 8000-bfff c000-ffff
;oben nach unten:
;bit0
;-
;bit7
;Anzeige:00000000 00000000 00000001 00000000
;Darstellung immer bit 0 - 7 0=OK 1=Fehler
;hier, Block3 (8000-bfff) bit 7 Fehler
;getestet werden Block 4,3,2 aus dem ROM,
;dann erfolgt eine Verschiebung in den RAM
;und Block 1 wird getestet,
;bei defekten in Block 2+3+4 wird Block1
;nur verkrzt getestet,da kein Verschieben
;erfolgt, also erst obere Blcke reparieren
;dann noch mal testen
;Wiederholung Test bei ROM mit Reset
;bei V.24 durch neu laden...
;written by D.Lepies 25.04.2010
;nach der Idee RAM-Testprogramm als Start-EPROM
;fr A5120 von H. Bretfeld/R.Kurth
;Die Nutzung des Programmes erfolgt auf eigene Gefahr!
;Es gibt Keine Gewhr fr 100%ige Funktion!
;Legende:
;V0 erste Testversion
;V0.1 Codeoptimierung, Restart bei V.24 zugefgt
rom equ 1					;Auswahl ROM(1)/V.24(0)
.z80
			.if rom=1			
			org 000h		;bei ROM
			.else
			org 1000h		;bei v.24
			.endif
;----------------------------init V.24
			ld  a, 5
			out (9), a		; CTC Kanal 1: Zeitkonstante laden
			ld  a, 1
			out (9), a		; Zeitkonstante
			ld  c, 0Fh		; SIO Kommando Kanal B
			ld  b, 9			; 9 Bytes sio init
			ld  hl,	sio_init;Tabelle
			otir 
			
;-----------------------------crt_init:
			ld a, 3Dh		; Anfangsadresse BWS F000h
			out (34h), a
			xor a
			out (19h), a		; CRT	 Reset
			ld a, 4Fh		; 80 Zeichen/Zeile
			out (18h), a		;knnte auch mit Tabelle, spart ein Byte :/
			ld a, 57h		; 2 Zeilen/VRCT-Signal; 24 Zeilen
			out (18h), a
			ld a, 0BBh		; 12 Zeichenlinien/Zeile
			out (18h), a
			ld a, 5Dh		; blinkender Strich; 14 Zeichen/HRCT-Signal
			out (18h), a
			ld a, 20h
			out (19h), a		;Start Display
;----------------------------Startbild
			ld hl, 0f2f1h		;ca Bildmitte	
			ld de, Stdispl		;Text fr Start
SendChar:
			ld a, (de)
			ex af,af'			;zu sendendes Byte retten	
SEND1:
			IN	a,(0Fh)		;puffer leer ?
			BIT	2,a
			JR	Z,SEND1
			ex af,af'
			out (0Dh), a		;V.24 Ausgabe
			cp 0ah			;Newline?
			jr z, ram1		;dann weiter
			ld (hl), a			;CRT-Ausgabe
			inc hl
			inc de
			jr SendChar		;nchstes Zeichen
ram1:
;----------------------------Pause						
			ld bc,0ffffh		;Pause fr Anzeige
count:
			cpi
			jp pe,count
;----------------------------Beginn
			ld a,0fh			;Durchlaufzhler laden
			ex af,af'			;und retten
			ld hl, 0c000h		;Startadresse RAM, Testblock4
			jr ram3
ram4:
			out (28h), a		;ROM abschalten, bei Prfung aus dem RAM
			ld hl, 0			;Startadresse RAM, Testblock1 volle Lnge
ram3:			
			ld de, 0			;Fehlerbitspeicher lschen
ram2:
			ld bc, 4000h		;Testlnge der Blcke
;----------------------------RAMtest als solcher ;)
test:
			ld(hl), 0ffh		;Testmuster FF
			ld a, (hl)			;rcklesen
			cpl			;negieren		 	
			or a, d			;Fehlerbits ermitteln
			ld d, a			;Fehlerbits nach d
			ld(hl), 55h		;Testmuster 55
			ld a, (hl)			;rcklesen
			and 0aah		;mit Fehlermaske verknpfen
			or a, d			;Fehlbits H ermitteln
			ld d, a			;Fehlerbits nach d
			ld a,(hl)			;noch mal rckladen
			cpl			;negieren
			and 55h			;mit Fehlermaske verknpfen			
			or a, d			;Fehlbits L ermitteln
			ld d, a			;Fehlerbits nach d
			ld(hl), 0aah		;Testmuster AA
			ld a, (hl)			;rcklesen
			and 55h			;mit Fehlermaske verknpfen
			or a, d			;Fehlerbits H ermitteln
			ld d, a			;Fehlerbits nach d
			ld a,(hl)			;noch mal rckladen
			cpl			;negieren
			and 0aah		;mit Fehlermaske verknpfen
			or a, d			;Fehlerbits L ermitteln
			ld d, a			;Fehlerbits nach d
			ld(hl), 0			;Testmuster 00
			ld a, (hl)			;rcklesen
			or a, d			;Fehlerbits ermitteln
			ld d, a			;Fehlerbits nach d
;----------------------------Blockdurchlufe
loop1:		
			cpi			;HL+1,BC-1
			ld a, b			;nchste  Adresse bis BC=0	
			cp 0		
			jr nz, test		;ok, jppe wre krzer,
			ld a, c			;gibt aber
			cp 0			;keine relative Adresse
			jr nz, test		;also etwas umstndlicher :(
			ex af,af'			;Durchlaufzhlbye holen
			cp 0fh			;Durchlaufkontrolle 1.Dl
			jr nz,loop2
			dec a			;Durchlaufzhlbye -1
			ex af, af'		;Durchlaufzhlbye retten
			ld e, d			;Fehlerbits nach E verschieben
			ld d, 0			;Fehlerzhler lschen
			ld hl, 8000h		;Startadresse RAM, Testblock3
			jr ram2
loop2:
			cp 0eh    		;Durchlaufkontrolle 2.Dl
			jr nz,loop3
			dec a			;Durchlaufzhlbye -1
			ex af,af'			;Durchlaufzhlbye retten
		
			exx			;Werte in die Schattenregister
			ld hl, 4000h		;Startadresse RAM, Testblock2
			jr ram3
loop3:
			cp 0dh			;Durchlaufkontrolle 3.Dl
			jr nz, loop4
			dec a			;Durchlaufzhlbye -1
			ex af,af'			;Durchlaufzhlbye retten
			ld a,d			;Fehlerbits nach A
			exx			;Schattenregister holen
			ld h, a			;Fehlerspeicher D(A) nach H
			ld l, 0			;Fehlerspeicher L lschen
			ld a, e			;ab c000 ok?	
			cp 0			
			jr nz, testd
			ld bc, 0c000h		;dann dahin
			jr reloc
testd:
			ld a, d			;ab 8000 ok?
			cp 0			
			jr nz, testh
			ld bc, 8000h		;dann dahin
			jr reloc
testh:
			ld a,h			;ab 4000 ok?
			cp 0
			jr nz, exx1		;kein geeigneter RAM -> block1 verkrzt testen
			ld bc, 4000h
			jr reloc			;Sprung zur Programmrelocation BC=RAM-Bereich
						;DE, HL = Fehlerspeicher Blcke 4-2
exx1:
			exx
			.if rom =1
			ld hl, 7ffh		;Startadresse RAM, Testblock1 verkrzt
			ld bc, 3801h		;7ffh und 3801h bei ROM
			.else
			ld hl, 11ffh
			ld bc, 2e01h		; oder 11ffh und 2e01h bei v.24!
			.endif
			ld de, 0
			jr loop1			;rel. Sprung mit "Verlngerung" 

loop4:
			ld a,d
			exx			;schattenregister aufrufen
			ld l,a			;Fehlerbits letzer Bereich
			exx			;wieder in Schattenregister retten
			jr bits
;----------------------------in RAM verschieben
reloc:
			ld a,b			; BC' nach	
			exx			;Schattenregister retten
			ld h,a			;und in
			ld l,0			;hl kopieren
			ld de,ram4		;zu kopierender Block
			add hl,de		;offset erzeugen
			ld sp, hl			;stack setzen
			push hl			;Startsdresse im RAM abspeichern
			ex hl, de		;de=HL
			ld bc,sio_init-ram4	;lnge 
			ldir			;kopieren
			ret			;Sprung in RAM
;----------------------------Ausgabe
bits:						;Anzeige Fehlerbits
			ld b,24h			;Bitzhler 4x9 bits (8Daten+Spacer)
			ld hl,0f387h		;Ausgabezeile
			jr bits1
SEND3:	
			ex af,af'	
SEND4
			IN	a,(0Fh)		 ;puffer leer ?
			BIT	2,a
			JR	Z,SEND4
			ex af,af'
			out (0Dh), a
			ld (hl), a
			inc hl
bits1:
			ld a,b			;Bitzhler nach Akku
			cp 1ch			;schon 8 durch?
			jr c, bith			;mehr -> sprung
			jr z, spacer		; = -> Spacer
			dec b			;Zhler -1
			ld a,0			;Rcksetzen Fehler
			exx			;aus dem Schattenregister holen
			rrc l			;L in den carry rotieren
			rla			;carry in A schieben
			exx			;Schattenregister wieder retten
			add a,30h		;als ASCII 30h(0) oder 31h(1) wandeln
			jr SEND3		;ausgeben
bith:			
			cp 13h
			jr c, bitd
			jr z,spacer
			dec b
			ld a,0
			exx
			rrc h			;H in den carry rotieren			
			rla
			exx
			add a,30h
			jr SEND3
bitd:
			cp 0ah
			jr c, bite
			jr z,spacer
			dec b
			ld a,0
			exx
			rrc d			;D in den carry rotieren
			rla
			exx
			add a,30h
			jr SEND3
bite:
			cp 1h
			jr c, ende
			jr z, newline
			dec b
			ld a,0
			exx
			rrc e			;E in den carry rotieren
			rla
			exx
			add a,30h
			jr SEND3
spacer:	
			ld a,20h			;Leerzeichen
			dec b			;Zhler -1
			jr SEND3		;Ausgabe
newline:
			ld a,0ah			;Newline
			dec b			;fr Ausgabe V.24
			jr SEND3		;und evtuelle Testwiederholung
ende:
			.if rom=1			
			jr ende			;loop fr ROM-Version Neustart durch Reset
			.else
			out(24h),a		;ROM  ein
			jp 0			;fr V.24 Neustart durch wiederholte bertragung
			.endif
;----------------------------Datensection
sio_init:				
			db 1Ch			; Kanal	RESET
			db 4, 49h		; WR4: Datenrate 1/16(9600!); odd; 1.5	stop bits
			db 3, 0C1h		; WR3: 8 Bits empfangen; enable	receiver
			db 1, 0			; WR1: Sperre Interrupts
			db 5, 68h		; WR5: 8 Bits senden; enable transmitter
Stdispl:
			db 53h,54h,41h,52h,54h,20h,52h,41h,4Dh,2Dh,54h,45h,53h,54h,0ah ;START RAM-TEST

