;MODUL BGDCK.MAC
;
;ZEICHENAUSGABE UEBER 80 ZEICHEN-GDC-KARTE
;-----------------------------------------
;I/O-ADRESSEN FUER GDC-KARTE
;
AKTLW	EQU	4		;AKTUELLES LAUFWERK BDOS
HWMODI	EQU	4		;LATCHADR. HARDWAREMODIFIK.
;
BAGDC	EQU	18H
STGDC	EQU	BAGDC
RDGDC	EQU	BAGDC+1
WDGDC	EQU	BAGDC
WCGDC	EQU	BAGDC+1
;
ZUGRSYN	EQU	1	;BILDSCHIRMZUGRIFFS-SYNCHRONISATION
			;1 BEI NICHTSICHTBAREN BILDSCHIRMZU-
			;  GRIFFEN;
			;0 BEI STAENDIGEN ZUGRIFFEN
;
CR	EQU	0DH
LF	EQU	0AH
FF	EQU	0CH
TAB	EQU	09H
ESC	EQU	1BH
DELL	EQU	18H
BS	EQU	08H
LBSEND	EQU	1920		;ENDE LOG. BILDSCHIRMADRESSE		
;
LCUPO:	DW	0		;LOGISCHE CURSORPOS.-ADR.
MLCUPO:	DW	0		;MERKE LOGISCHE CURSOR-POS.
MESC:	DB	0		;MERKE ESCAPE-EINLEITUNG
;
;ANFANGSEINSTELLUNG DER TEILBILDSCHIRME 1 , 2 UND 3 
;
CSAD1:	DW	0		;SAD1=0                 !ANFANGS-
	DW	0F00H		;LEN1=240 -> 24 ZEIL    !WERTE
	DW	1920		;SAD2=0 UEBERNAHME DER ST.ZEILE !
	DW	0A0H		;LEN2=1   ->KEINE ZEILE !
	DW	1920		;STATUSZEILE
	DW	0A0H	
;
;TABELLE BILDSCHIRMSTEUERZEICHEN
;
STTAB:	DB	TAB,CR,LF,BS
	DB	FF		;HOME U. CLEAR
	DB	1		;HOME
	DB	1AH		;UP(SCP), FF(ADM3A)
	DB	7FH		;DEL
	DB	14H		;EOS
	DB	15H		;RIGHT
	DB	16H		;EOL
	DB	DELL		;DELL
	DB	ESC		;CPOS ZE SP
	DB	7		;BEEP
	DB	2		;CURSOR EIN
	DB	3		;CURSOR AUS
	DB	4		;NORMAL
	DB	5		;INVERS
	DB	0FH		;ZG1
	DB	0EH		;ZG2
STTBE	EQU	$
;
	DW	CRIGH,COCR,COLF,COBS,COCLS
	DW	CHOME,COUP,CODEL,COEOS
	DW	CRIGH,COEOL,CODLL,COPOS
	DW	BEEPA,CUREIN,CURAUS
	DW	NORMAL,INVERS,ZG1,ZG2
CRTBE	EQU	$
;
;
;----------------------------------------
;INIT GDC FUER 24*80 + 1*80 ZEICHEN
;
IGDC1:	CALL	UPOUT
	DB	2		;2 BYTE AN
	DB	WCGDC		;STEUERPORT
	DB	0		;RESET
	DB	0FH		;SYNC
	DB	8		;8 BYTE AN
	DB	WDGDC		;DATENPORT
IF	ZUGRSYN
	DB	30H		;ZEICHENBETRIEB IN STRAHLRUECKLAUF
				;KANN SCHWIERIGKEITEN GEBEN, WENN
				;DATENBUS VOM GDC NICHT GETRIEBEN IST!
ELSE
	DB	20H		;IMMER SCHREIBERLAUBNIS
ENDIF
	DB	80-2		;AW (80 ZEICHEN)
	DB	6BH		;HS=12 VSL=3
	DB	34H		;HFP=14 VSH=0
	DB	22-1		;HBP=22
	DB	21-1		;VFP=21
	DB	250		;ALL=250 LINIEN
	DB	098H		;VBP=38
	DB	2		;2 BYTE
	DB	WCGDC		;AN STEUERPORT
	DB	6FH		;VSYNC
	DB	4BH		;CCHAR
	DB	3		;3 BYTE AN
	DB	WDGDC		;DATENPORT
	DB	89H		;10 LINEN/ZEICHEN
	DB	20H		;NICHT BLINKEN
	DB	49H		;CURSORGROESSE
	DB	0
	CALL	SPRAM		;SETZEN PRAM
	CALL	UPOUT
	DB	1		;1 BYTE AN
	DB	WCGDC		;STEUERPORT
	DB	46H		;ZOOM
	DB	1		;1 BYTE AN
	DB	WDGDC		;DATENPORT
	DB	0		;ZOOMFAKTOR=1
	DB	1		;1 BYTE AN
	DB	WCGDC		;STEUERPORT
	DB	49H		;CURS
	DB	2		;2 BYTE AN
	DB	WDGDC		;DATENPORT
	DB	0
	DB	0		;CURSOR-POS.
	DB	1		;1 BYTE AN
	DB	WCGDC		;STEUERPORT
	DB	47H		;PITCH
	DB	1		;1 BYTE AN
	DB	WDGDC		;DATENPORT
	DB	80		;ZEICHEN/ZEILE
	DB	1		;1 BYTE AN
	DB	WCGDC		;STEUERPORT
	DB	4CH		;FIGS
	DB	1		;1 BYTE AN
	DB	WDGDC		;DATENPORT
	DB	2		;DIR ->
        DB	1		;1 BYTE AN
	DB	WCGDC		;STEUERPORT
	DB	4AH		;MASK
	DB      1               ;1 BYTE AN
        DB      WDGDC           ;DATENPORT
        DB	0FFH		;ALLE BITS WERDEN BEEINFLUSST
	DB	2		;2 BYTE AN
	DB	WCGDC		;STEUERPORT
	DB	6BH		;START
	DB	0DH		;BCTRL DISP FREI

	DB	0
;
;ALLE TEILBILDSCHIRME LOESCHEN
;
	LD	HL,0
	CALL	SETCUP
	LD	BC,2000
	CALL	CLBWS
	JP	CORET
;
;
;--------------------------------------
;UP OUT(ANZAHL,OUTADR,PARAMETER,....0)
;
UPOUT:	POP	HL
	LD	B,M
	INC	HL
	LD	C,M
	INC	HL
	OTIR
	LD	A,M
	AND	A
	JR	NZ,$-8
	JP	(HL)
;-------------------------------------

ZAG:	LD	A,(MESC)	;MERKE ESCAPE-SEQUENZ
	OR	A
	JP	NZ,CPOS1	;POSITIONIERUNG LAEUFT
	LD	DE,(LCUPO)	;LOGISCHE CUPO
	LD	A,C		;ZEICHEN IN A
	LD	(MLZBS),A
	AND	7FH		;STEUERZ.>80H
	CP	20H		;UEBERHAUPT STEUERZEICHEN ?
	JR	NC,ZAG2		;NEIN
	LD	HL,STTAB
	LD	BC,STTBE-STTAB
	CPIR			;STEUERZEICHEN ?
	JP	Z,BS08		;JA-->AUSFUEHRUNG
	RET			;KEIN DEFINIERTES STEUERZEICHEN
				;--> IGNORIEREN
ZAG2:	LD	A,30H		;VORBEREITEN DER NACHFOLGENDEN
	OUT	(WCGDC),A	;BWS-SCHREIBOPERATION
	LD	A,(MINV)	;INVERSDARSTELLUNG?
	LD	C,A
	LD	A,(MLZBS)	;AUSZUG.ZEICHEN
	XOR	C		;ENTSPRECHEND WANDELN
	OUT	(WDGDC),A	;ZEICHEN AUF BS
;
;CURSOR RECHTS
;--------------------------------
CRIGH:	LD	DE,(LCUPO)
	INC	DE		;NAECHSTE LOG CU.POS.
	LD	HL,LBSEND-1	;BILDSCHIRM-ENDE-ADR.LOGISCH
	OR	A		;
	SBC	HL,DE		;ADR. UEBER BS-ENDE ?
	JR	C,BSROLL	;JA-->ROLLEN
	CALL	SETCU		;NEUE LOG.POS SETZEN
	RET
;
;BILDSCHIRM UM EINE ZEILE NACH OBEN ROLLEN UND LOESCHEN 
;DER LETZTEN ZEILE
;
BSROLL:	LD	HL,(SAD1)
	LD	A,H
	OR	L			;AUSGANGSSTELLUNG TBS?
	JR	NZ,BSROL3		;NEIN
	LD	(SAD2),HL		;ANF.ADR. TBS2=0
	LD	(LEN2),HL		;LAENGE TBS2=0 SIMULIEREN 
BSROL3:	LD	BC,80
	ADD	HL,BC
	LD	(SAD1),HL
	LD	BC,LBSEND
	OR	A
	SBC	HL,BC
	JR	C,BSROL1
	LD	HL,CSAD1		;ANFANGSEINSTELLUNG DER TEIL-BS
	LD	DE,SAD1		
	LD	BC,12
	LDIR				;HINEINKOPIEREN DER URWERTE
	JR	BSROL2
;
BSROL1:	LD	HL,(LEN1)
	LD	BC,0A0H			;10 LINIEN WENIGER AUF TBS 1
	OR	A
	SBC	HL,BC
	LD	(LEN1),HL
	LD	HL,(LEN2)
	ADD	HL,BC			;10 LINIEN MEHR AUF TBS 2
	LD	(LEN2),HL
	LD	HL,MOFL
	BIT	6,M			;OHNE SYNCHRONISATION?
	JR	NZ,BSROL4		;JA
BSROL2:	IN	A,(STGDC)		;STATUSREGISTER LESEN
	BIT	5,A			;VERTIKAL-LUECKE?
	JR	Z,BSROL2		;NEIN
BSROL4:	CALL	SPRAM			;NEUE POINTER FUER GDC
	LD	DE,LBSEND-80		;LOG ADR. LETZTE ZEILE
	CALL	SETCU
	LD	BC,80
	CALL	CLBWS			;LOESCHEN LETZTE ZEILE	
	CALL	SETCU			;WIEDER AUF ANFANG D. Z.
	RET

;
;UMWANDELN LOG BS-ADRESSE (DE) IN PHYSISCHE
;SETZEN CURSOR AUF PHYSISCHE ADRESSE
;
SETCU:	PUSH	HL
	PUSH	DE
	CALL	CULOPY		;WANDEL LOG. IN PHYS. CURSORPOS.
	CALL	SETCUP 		;SETZEN PHYSISCHE CURSORPOSITION
	POP	DE
	LD	(LCUPO),DE
	POP	HL
	RET	
;
;SETZEN PHYS. CURSORADR. (POS IN HL)
;
SETCUP:	LD	A,49H
	OUT	(WCGDC),A
	LD	A,L
	OUT	(WDGDC),A
	LD	A,H
	OUT	(WDGDC),A
	RET
;
;UMWANDELN LOG CURSORPOS. (DE) IN PHYSISCHE (HL)
;
CULOPY:	LD	HL,(SAD1)	;STARTADR. 1. TEIL-BS
	ADD	HL,DE
	EX	DE,HL		;DE=THEORETISCH NEUE PHYS.ADR
	LD	HL,LBSEND-1
	OR	A
	SBC	HL,DE		;NEUE CURSORPOS AM PHYS. ENDE ?
	EX	DE,HL		;HL=PHYSISCHE ADR.
	RET	NC		;PHYS.ENDE NOCH NICHT ERREICHT
	LD	DE,LBSEND-1	;
	SBC	HL,DE		;HL NEUE PHYS. ADR.	
	RET
;
;EINSTELLEN DES PRAM VON TEIL-BS 1, 2 UND 3 (STATUSZEILE)
;
SPRAM:	CALL	UPOUT		;AUSGEBEN STEUERSTRING
	DB	1		;1 BYTE AN
	DB	WCGDC		;STEUERPORT 
	DB	70H		;ADR. PARAMETERRAM PRAM BS 1
	DB	12		;12 DATENBYTE AN
	DB	WDGDC		;PRAM BS 1, 2 UND 3
SAD1:	DW	0		;SAD1=0                 !ANFANGS-
LEN1:	DW	0F00H		;LEN1=240 -> 24 ZEIL    !WERTE
SAD2:	DW	1920		;SAD2=0 UEBERNAHME DER STATUSZEILE!
LEN2:	DW	0A0H		;LEN2=0  -> KEINE DARST.!
SAD3:	DW	1920		;3. BS FEST EINGESTELLT AUF 25.ZEILE
LEN3:	DW	0A0H		;STATUSZEILE=EINE ZEILE
	DB	0		;ENDE STEUERSTRING
	RET
;
;ZUORDNEN DER ENTSPRECHENDEN ROUTINEN
;
BS08:	LD	HL,CRTBE-1
	XOR	A
	SBC	HL,BC
	SBC	HL,BC
	LD	B,M
	DEC	HL
	LD	C,M
	PUSH	BC		;ADR. BEHANDLUNGSROUTINE
	LD	L,E		;HL=DE=LOG.CURSORPOS.
	LD	H,D
	RET			;BEHANDL.CTRL
;
CORET:	LD	D,H
	LD	E,L
	CALL	SETCU
	RET			;RUECKKEHR MIT LOG. CUPO IN DE,HL
;
;CURSOR EINSCHALTEN
;-------------------------------
CUREIN:	LD	A,0FFH
	LD	(MCUR),A
CUREP:	CALL	UPOUT
	DB	1,WCGDC,4BH,3,WDGDC,89H,20H,49H,0
CUREI1:	LD	DE,(LCUPO)
	CALL	SETCU
	RET
;
;CURSOR AUSSCHALTEN
;-------------------------------
CURAUS:	XOR	A
	LD	(MCUR),A
CURAP:	CALL	UPOUT
	DB	1,WCGDC,4BH,3,WDGDC,9,20,49,0	
	RET
;
;INVERSRUECKSTELLUNG
;-------------------------------
NORMAL:	XOR	A
NRML1:	LD	(MINV),A
	RET
;
;INVERSEINSCHALTUNG
;-------------------------------
INVERS:	LD	A,80H
	JR	NRML1
;
;1. UND 2. ZEICHENGENERATOR EINSCHALTEN
;--------------------------------------
ZG1:	IN	A,(HWMODI)
	RES	5,A
ZGE:	OUT	(HWMODI),A
	RET
;
ZG2:	IN	A,(HWMODI)
	SET	5,A
	JR	ZGE

;
;DIREKTPOSITIONIERZYKLUS EINLEITEN
;---------------------------------
COPOS:	LD	A,0FFH
	LD	(MESC),A
	RET
;
;CURSORDIREKTPOSITIONIERUNG
;
CPOS1:	LD	A,1BH
	CP	C		;KONTROLLE NEUSTART ESC
	JR	NZ,CPOS2
CPOS3:	XOR	A
	LD	(MESC),A
	LD	(MSEQU),A	;CURSORPOS. SEQUENZ LOESCHEN
	RET			;ESC ABBRECHEN	
CPOS2:	LD	A,(MSEQU)
	INC	A
	LD	HL,MADM3A
	JR	Z,SPPOS		;ZEILENPOSITIONIERUNG SCHON ERFOLGT
	LD	A,C		;ZEICHEN IN C
	CP	59H		;ADM3A-TERMINAL
	JP	Z,ADM3A
	CP	3DH		;ADM3A-TERMINAL
	JP	Z,ADM3A	
	CP	5EH		;FELDATRIBUT SCP1715 (NICHT VORH.)
	JR	Z,CPOS3
	CP	5FH		;PSEUDOSATZ 1715 (NICHT VORH.)
	JR	Z,CPOS3
	CP	80H
	JR	C,CPOSZP	;ARGUMENTE BEI ADM3A < 70H
	LD	M,0		;ARGUMENT WAR GROESSER--> SCP-TERMINAL
;
;ZEILENPOSITIONIERUNG
CPOSZP:	LD	A,0FFH		;MERKE ZEILE POSITIONIERT
	LD	(MSEQU),A
	LD	A,C
	AND	7FH
	LD	C,M		;OFFSET-GROESSE
	SUB	C		;OFFSET SUBTRAHIEREN
	CP	24		;MAX ZEILENZAHL
	JR	C,ZEIPOS1
	LD	A,0
ZEIPOS1:LD	B,A
	LD	HL,0
	OR	A
	JR	Z,ZEIPOS3	;ZEILE 0
	LD	DE,80		;SPATENBREITE
ZEIPOS2:ADD	HL,DE
	DJNZ	ZEIPOS2
ZEIPOS3:LD	(LCUPO),HL
	RET
;
;SPALTENPOSITIONIERUNG
SPPOS:	LD	A,C
	AND	7FH
	LD	C,M
	SUB	C		;OFFSET SUBTRAHIEREN
	CP	80		;MAX SPALTENZAHL
	JR	C,SPPOS1
	LD	A,0
SPPOS1:	LD	HL,(LCUPO)	;ENTHAELT ADR. ZEILENPOS.
	LD	B,0
	LD	C,A
	ADD	HL,BC		;+ SPALTENPOSITION
	LD	(LCUPO),HL
	XOR	A
	LD	(MESC),A	;LETZTES AUSGEGEB. ZEICHEN
	LD	(MSEQU),A	;POS. VORGANG ZU ENDE
	JP	CORET
;
;CARIGE RETURN
;-------------------------------
COCR:	CALL	COCR1
	JP	CORET
;
COCR1:	LD	HL,LBSEND-1
	LD	BC,80
BS09:	OR	A
	SB	HL,BC
	JR	C,COCR2
	PUSH	HL
	SBC	HL,DE		;DE=ALTE LOG.CURSORPOS
	POP	HL
	JR	NC,BS09
COCR2:	INC	HL
	RET
;
;LINEFEED
;-------------------------------
COLF:   LD	HL,LBSEND-81
	OR	A
	SBC	HL,DE		;LOG. CU-POS GROESSER ?
	JP	C,BSROLL	;JA-> BS ROLLEN
	LD	HL,80
	ADD	HL,DE
	JP	CORET
;
;ZEICHEN LOESCHEN UND CURSOR LINKS (DEL)
;----------------------------------------
CODEL:	LD	A,20H
	OUT	(WDGDC),A	;ZEICHEN LOESCHEN 
;
;CURSOR NACH LINKS
;--------------------------------
COBS:	LD	A,D
	OR	E
	RET	Z		;CURSOR SCHON AM BS-ANFANG
	DEC	HL
	JP	CORET
;
;CLEAR SCREEN
;--------------------------------
COCLS:	LD	HL,0
	CALL	SETCUP		;SETZEN PHYSISCHE CURSORPOS.
	CALL	CURAP		;CURSOR AUS
	LD	BC,1920
COCLS1:	IN	A,(STGDC)	;STATUS
	BIT	5,A		;VERTIKAL-SYNC ?
	JR	Z,COCLS1	;NEIN
	CALL	CLBWS		;PHYSISCHES LOESCHEN BWS
	LD	HL,CSAD1	;ANFANGSEINSTELLUNG DER TEIL-BS
	LD	DE,SAD1		
	LD	BC,12
	LDIR			;HINEINKOPIEREN DER URWERTE
COCLS2:	IN	A,(STGDC)
	BIT	5,A		;WIEDER SYNCH. MIT VERTIKAL-SYNC
	JR	Z,COCLS2
	CALL	SPRAM		;GDC-POINTER NEU SETZEN
	CALL	ASTL		;AUSGABE STATUSZEILE
	LD	A,(MCUR)
	OR	A		;WAR CURSOR VORHER AUS?
	CALL	NZ,CUREP	;CUSOR WIEDER EINSCH. WENN VORHER GEW.
	LD	HL,0
	JP	CORET
;
;CLEAR VON CURSOR BIS BS-ENDE
;--------------------------------
COEOS:	LD	HL,LBSEND
	LD	(MLCUPO),DE	;RETTEN ALTE CUPO
	OR	A
	SBC	HL,DE		;HL=ANZAHL ZU LOESCHENDER ZEICHEN
	LD	A,20H
	LD	(MLZBS),A	;LOESCHBYTE
	PUSH	HL
	CALL	CURAP		;CURSOR AUS
	POP	HL
COEOS1:	PUSH	HL
	CALL	ZAG2
	POP	HL
	DEC	HL
	LD	A,H
	OR	L		;ALLE POS GELOESCHT?
	JR	NZ,COEOS1	;NEIN
	LD	A,(MCUR)
	OR	A
	CALL	NZ,CUREP	;CURSOR WIEDER EIN
	LD	HL,(MLCUPO)	;ALTE LOG POS EINSTELLEN
	JP	CORET
;
;CURSOR HOME
;--------------------------------
CHOME:	LD	HL,0
	JP	CORET
;
;CURSOR HOCH
;--------------------------------
COUP:	LD	A,(MADM3A)
	CP	20H
	JP	Z,COCLS		;CODE BEI ADM3A FUER BS-LOESCHEN
	LD	HL,80
	SCF
	SBC	HL,DE
	RET	NC		;BS ANFANG UEBERSCHRITTEN
	CCF
	LD	HL,80
	EX	DE,HL
	SBC	HL,DE		;- SPALTENANZAHL
	JP	CORET
;
;DELLINE
;--------------------------------
CODLL:	CALL	COCR
;
;LOESCHEN ZEILENREST
;--------------------------------
COEOL:	PUSH	DE
	CALL	COCR1
	ADD	HL,BC		;+ SPALTENANZAHL
	OR	A
	SBC	HL,DE
	LD	B,0		;ANZAHL IN C
	LD	C,L
	CALL	CLBWS
	POP	HL
	JP	CORET
;
;CLEAR BWS AB CURSOR (BC)MAL MIT 20H (0A0H)
CLBWS:	PUSH	HL
	PUSH	BC
	PUSH	BC
	POP	HL
	LD	A,30H
	OUT	(WCGDC),A
	LD	A,(MINV)
	ADD	A,20H
	LD	B,A
	LD	C,WDGDC
	CALL	CLBWS1
	POP	BC
	POP	HL
	RET	

CLBWS1:	LD	A,H
	OR	L		;HL=0?
	RET	Z		;HL=0
CLBWS2:	IN	A,(STGDC)
	BIT	1,A
	JR	NZ,CLBWS2
	OUT	(C),B
	DEC	HL
	JR	CLBWS1

;
;REALISIERUNG DER BEEP-FUNKTION
;
BEEPA:	
;	LD	BC,9080H
;	CALL	PEEP
;DUMMY:	
	RET


;
;AKTUALISIEREN DER STATUSZEILE UND AUSGABE DIESER
;----------------------------------------------------------------
ASTL:   PUSH	HL
	CALL	ALWSTL		;WELCHES AKTUELLE LAUFWERK?
	CALL	ANZTF		;WELCHE TAKTFREQUENZ?
IF	RTC
	CALL	TIME		;WELCHE UHRZEIT?
	CALL	DATE		;WELCHES DATUM?
ENDIF
	LD	HL,PUFSTL	;PUFFER STATUSZEILE
	CALL	OSTATL		;AUSGEBEN DER AKTUALISIERTEN STATUSZEILE
	POP	HL
        RET

;
;UNTERPROGRAMM ZUM AUSGEBEN DER STATUSZEILE /OUTPUT STATUS-LINE
;INPUT: HL=ADRESSE DES 80-ZEICHEN-STRINGPUFFERS
;       ABSCHLUSS DES STRINGS MIT 0, DANACH MIT SPACE AUFGEFUELLT
;----------------------------------------------------------------
OSTATL:	PUSH	AF
	PUSH	HL
	PUSH	BC
	PUSH	DE
	PUSH	HL
	LD	HL,MOFL
	BIT	6,M		;OHNE SYNCHRONISATION?
	JR	NZ,OSTAT6	;JA
OSTAT5:	IN	A,(STGDC)
	BIT	5,A		;SYNC-LUECKE?
	JR	Z,OSTAT5	;NEIN
OSTAT6:	LD	HL,(SAD3)
	CALL	SETCUP		;SETZEN CURSOR PHYSISCH AUF (HL)
	LD	A,30H		;WDAT
	OUT	(WCGDC),A
	LD	B,80		;LAENGE STATUSZEILE
	LD	C,WDGDC		;DATENPORT
	POP	HL
OSTAT1:	LD	D,M
	LD	A,D
	OR	A		;STRING ZU ENDE ?
	JR	NZ,OSTAT2	;NEIN
OSTAT3:	LD	A,(MINV)
	LD	D,' '		;REST MIT SPACE
	XOR	80H
	XOR	D
	OUT	(C),A
	DJNZ	OSTAT3
	JR	OSTAT4
OSTAT2:	LD	A,(MINV)
	XOR	80H		;STATUSZEILE INVERS GEGEN REST
	XOR	D
	OUT	(C),A
	INC	HL
	DJNZ	OSTAT1
OSTAT4:	LD	DE,(LCUPO)
	CALL	SETCU		;CURSOR AUF ALTE POS. SETZEN
	POP	DE
	POP	BC
	POP	HL
	POP	AF
	RET
;
;ANZEIGE DER TAKTFREQUENZ AUF DER STATUSZEILE
;
ANZTF:	PUSH	AF
	IN	A,(HWMODI)
	BIT	7,A
	JR	NZ,F36MHZ		;3 ODER 6 MHz
	BIT	6,A
	LD	A,'4'
	JR	NZ,FREQUA
	LD	A,'2'
	JR	FREQUA
F36MHZ:	BIT	6,A
	LD	A,'4'        ;'6'
	JR	NZ,FREQUA
	LD	A,'2'        ;'3'
FREQUA:	LD	(FREQU),A
	POP	AF
	RET	
;
;AUSGABE LW AUF STATUSZEILE
;
ALWSTL:	PUSH	AF
	LD	A,(AKTLW)	;AKTUELLES LAUFWERK IM BDOS
	ADD	A,'A'
	LD	(PUFST1),A
	LD	A,(DEV)		;AKTUELLES LAUFWERK IM BIOS
	ADD	A,'A'
	LD	(PUFST1+2),A
	POP	AF
	RET
;
;
PUFSTL:	DB	' akt.LW (    ):'
PUFST1:	DB	'A/A'      
	DB	'   '
FREQU:	DB	'4'
	DB	' MHz'
;
IF ERRVAR
;
derrms:	db	'  R/W-Err.: '
derrrw: db      'X '
derrcd: db      'X; T,Si,Se='
derrtr: db      'XX'
derrts: db      'XX'
derrsc: db      'XX   '

ELSE
	DB	'  * CP/M 2.2 BIOS-6.0 (Y22VJ) *   '
ENDIF
IF	RTC
GDCDATE: DB	'dd.mm.yy '
	DB	'/ '
GDCZEIT: DB     'hh:mm:ss '
ELSE
	DB	'aut.Formaterkennung '
ENDIF
;
ADM3A:	LD	A,20H		;OFFSET BEI ADM3A
	LD	(MADM3A),A
	RET
;
;ARBEITSZELLEN FUER GDC U82720
;
MLZBS:	DB	0		;MERKE LETZTES ZEICHEN-BS
MSEQU:	DB	0		;MERKE SEQUENZ
MINV:	DB	0		;MERKE INVERS
MCUR:	DB	0FFH		;CURSOR EIN/AUS
MADM3A:	DB	0		;ADM3A TERMINAL MERKEN
MOFL:	DB	0		;MODFLAGS
;
;ENDE MODUL BGDCK.MAC
;

