;***  Modul biopdsk ***

;********************************************
;  logischer Diskettentreiber fuer Minifloppy
;   - Umkleidung des physischen Transfers -
;********************************************

; Kaltstart-Initialisierung
;==========================

mfl.kalt::         ;Adressen in dph und ixtab eintragen
        ld      hl,dphfl0       ;Mini Drive 0 (links)
        ld      (dpha),hl       ; e:
        ld      hl,ixmfl0
        ld      (ixtab+('a'-'a')*2),hl
        ld      hl,dphfl1       ;Mini Drive 1 (rechts)
        ld      (dphb),hl       ; f:
        ld      hl,ixmfl0
        ld      (ixtab+('b'-'a')*2),hl
        ret


; Warmstart-Initialisierung
;==========================
mfl.warm::
	call	dbtrw		;;Diskettenpuffer ausgeben
	ld	a,0ffh
	ld	(dbdev),a	;;Puffer ist nicht aktiv
	ret
;
	IF	@write
;
; Schreiben Sektor
;=================
; Register C (vom BDOS gestellt):
;	=0, wenn normales write
;	=1, wenn directory-write (sofort ausgeben)
;	=2, wenn Beginn eines neuen Datenblocks (kein preread)

mflwr::
	push	bc		;retten Reg. C
	ld	a,(dev)
	ld	c,a
	call	dgetpb		;ix:=dpb(dev)
	pop	de
	jr	z,drwerr	;Geraet ex. nicht

	ld	hl,dflg
	set	dfwr,(hl)	;Write-Flag setzen

	IF	dbufsz gt 7	;gepufferte Disk E/A
	ld	hl,dbflg
	set	dfbprr,(hl)	;Annahme preread notwendig
	ld	a,e		;A:= Write-Typ
	ld	(dwrtyp),a	;merken Write-Typ
	cp	2		;write to unallocated?
	jr	nz,chkuna	;nein
	ld	a,(ix+dpbblm)	;Zahl der 128-Sekt. im Block -1
	inc	a
	ld	(unbcnt),a	;fuer diese Sekt. kein preread
	ld	hl,unbdev
	ld	(hl),c
	ld	a,(trk)
	ld	(unbtrk),a
	ld	a,(sec)
	ld	(unbsec),a
chkuna:	ld	a,0
unbcnt	equ	$-1
	or	a		;noch nicht geschr. Sekt. da?
	jr	z,alloc		;nein
	dec	a		;sonst Restzahl -1
	ld	(unbcnt),a
	ld	a,0ffh
unbdev	equ	$-1
	cp	c		;gleiches Geraet?
	jr	nz,alloc	;nein
	ld	a,0ffh
unbtrk	equ	$-1
	ld	hl,trk
	cp	(hl)		;gleiche Spur?
	jr	nz,alloc	;nein
	ld	e,0
unbsec	equ	$-1
	ld	a,(sec)
	cp	e		;gleicher Sektor?
	jr	nz,alloc	;nein
; Vorbereiten naechsten unalloc write-Aufruf
	cp	(ix+dpbspt)	;neue Spur?
	jr	c,unatr1	;nein
	ld	hl,unbtrk
	inc	(hl)		;unbtrk +1
	xor	a		;Sektor auf Spuranfang
unatr1:	inc	a		;naechster Sektor
	ld	(unbsec),a
	ld	hl,dbflg
	res	dfbprr,(hl)	;anzeigen kein preread notw.
	ENDIF
	jr	drw

	ENDIF	;@write

; Abbruch read/write mit E/A-Fehler
drwerr:	ld	a,1
	ret


; Lesen Sektor
;=============

mflrd::
	ld	a,(dev)
	ld	c,a
	call	dgetpb		;ix:=dpb(dev)
	jr	z,drwerr	;Geraet ex. nicht

	ld	hl,dflg
	res	dfwr,(hl)	;Lesen anzeigen

	IF	dbufsz gt 7
	ld	hl,dbflg
	set	dfbprr,(hl)	;preread notwendig
	ld	a,2
	ld	(dwrtyp),a

alloc:	IF	@write
	xor	a
	ld	(unbcnt),a	;Ende unalloc
	ENDIF

	ENDIF
drw:	ld	a,(sec)
	dec	a		;ab 0 zaehlen
	jp	m,drwerr	;<0, Fehler
	cp	(ix+dpbspt)	;<dpbspt?
	jr	nc,drwerr	;nein
drwsok:	IF	dbufsz gt 7	;gepufferte Disk E/A
	ld	b,a		;retten sec-1
	IF	dbufsz lt 12	;<2**12 =4K Puffer
	ld	a,(ix+dpbslc)	;phys. Sektorlaenge 128?
	or	a		;d.h. mit Sektorversatz?
	jp	z,drwsec	;ja, keine Pufferung sinnvoll
	ENDIF
	ld	a,(ix+dpbflg)
	and	dpbfsm		;Anzahl der abweich. 128er Spuren
	ld	d,a
	ld	a,(trk)	;verlangte Spur
	cp	d		;im abweichenden Spurformat?
	jp	c,drwsec	;ja, Sektorlaenge 128
	ld	a,b
	ld	d,(ix+dpbbfm)	;Puffermaske
	and	d		;rel. Sekt.nr. des
;				BDOS-Blocks zum Pufferanfang
	push	af		;merken fuer move
	xor	b		;a ist Sektornr. des Puff.anf.
drwbnr:	srl	a		;ermitteln Puffernr in Spur
	rr	d		;noch Bits in Puffermaske?
	jr	nz,drwbnr	;ja
; Test, ob dieser Puffer da ist
	push	af		;merken Puffernummer
	cp	0ffh		;richtige Puffernummer?
dbnb	equ	$-1
	jr	nz,dbn		;nein
	ld	a,(dbtrk)
	ld	d,a
	ld	a,(trk)	;geforderte Spur
	cp	d		;richtige Spur?
	jr	nz,dbn
	ld	a,(dbdev)	;zum Puffer gehoeriges Geraet
	cp	c		;richtiges Geraet?
	jr	z,dbmat		;ja, Sektor steht im Puffer

dbn:	push	bc		;retten dev
	call	dbtrw		;veraenderten Puffer ausgeben
	pop	bc		;c:=dev
	ld	hl,dbdev
	ld	(hl),c
	ld	a,(trk)
	ld	(dbtrk),a
	call	dgetpb		;ix:=dpb(c)
	ld	b,(ix+dpbslc)
	ld	hl,dbslc
	ld	(hl),b
	ld	a,(ix+dpbbfm)	;Zahl der 128er Sektoren -1
	inc	a
	add	a,a		;CY:=0
	inc	b		;fuer djnz, falls dpbslc=0
dbsnbz:	rrca			;Zahl der phys. Sekt. im Puff.
	djnz	dbsnbz
	ld	d,a		;merken
	xor	a
	pop	bc		;b:=geforderte Puffernr.
	push	bc
	ld	hl,dbnb
	ld	(hl),b
	inc	b
	dec	b		;Puffernr. 0?
	jr	z,dbsec0	;ja
dbsecz:	add	a,d		;0. phys. Sekt. im Puffer
	djnz	dbsecz		;=dbsnb.*Puffernr.
dbsec0:	ld	e,a		;merken Pufferanf.-Sektor
	ld	b,(ix+dpbslc)
	ld	a,(ix+dpbspt)
	inc	b		;wegen djnz
	add	a,a
dbsecm:	srl	a		;phys. Sektoranzahl
	djnz	dbsecm
	sub	e		;Restsektorzahl auf Spur
	cp	d		;>= Zahl zu transferierender?
	jr	nc,dbseco	;ja
	ld	d,a		;sonst nur Restsektorzahl
dbseco:	inc	e		;Sektoren zaehlen ab 1
	ld	(dbsec),de	;hinterlegen Sektor, Sektorzahl
	ld	hl,dbflg
	res	dfbwr,(hl)
	bit	dfbprr,(hl)	;muss neuer Puffer gel. werden?
	jr	nz,dbprr	;ja
; nur dann kein preread, wenn Rest BDOS-Block >= phys. Puff.
; und Rest BDOS-Block auf Pufferanfang beginnt
	ld	a,(unbcnt)
	cp	(ix+dpbbfm)	;Restzahl-1 >= Puffergr.-1 ?
	jr	c,dbprr		;nein, preread
	ld	a,(sec)	;Sektornr.
	dec	a		;ab 0 zaehlen
	and	(ix+dpbbfm)	;rel. Sekt.nr. des
;				BDOS-Blocks zum Pufferanfang
	jr	nz,dbprr
	ld	(dberrf),a	;fehlerfrei gel. anzeigen
dbprr:	call	nz,dbtran	;Puffer lesen
dbmat:	

; Sektor in/aus Puffer holen
;===========================
	pop	af		;Puffernr. in Spur wegschm.
	pop	af		;128-er Index im Puffer
	push	af
	rra			;Sektornb*128 berechnen
	ld	b,a
	ld	c,0
	rr	c
	ld	hl,dbuf
	add	hl,bc		;Adresse im Puffer
	ld	de,(dma)	;Nutzer-DMA
	ld	a,(dflg)
	bit	dfwr,a		;Schreiben?
	jr	z,dsmove	;nein
	ld	a,(dbflg)
	set	dfbwr,a		;anzeigen Puffer beschrieben
	ld	(dbflg),a
	ex	de,hl
dsmove:	ld	bc,128
	ldir
	pop	af		;128-Index im Puffer
	cp	(ix+dpbbfm)	;letzter Sektor im Puffer
	jr	z,dmovew	;ja, Puffer ausgeben
	ld	a,0ffh
dwrtyp	equ	$-1
	cp	1		;write to directory?
dmovew:	call	z,dbtrw		;ja, veraend. Puffer ausgeben
	ld	a,0
dberrf	equ	$-1		;Ergebnisflag letztes dbtran
	ret

; Schreiben Puffer, wenn notw.
;=============================
dbtrw:	ld	hl,dbflg
	bit	dfbwr,(hl)	;Puffer veraendert?
	ret	z		;nein, Schreiben unterdruecken
	ENDIF	;dbufsz gt 7

	IF	format or (dbufsz gt 7)
; gemeinsamer Zweig Lesen/Schreiben Puffer
;=========================================
dbtran:	
	ld	hl,dbcdb
	IF	dbufsz gt 7
	call	diskio
	ld	(dberrf),a	;Fehlerflag stellen
	ld	hl,dbflg
	res	dfbwr,(hl)	;Puffer ist nicht beschrieben
	ret
	ELSE
	jp	diskio	
	ENDIF

	ENDIF

	IF	format
; Lesen beliebigen Sektor-Id.
;===========================
dsidtt:	ld	(dfrmtr),a	;Eingang fuer Spur in A
dsidtr:	ld	hl,dfrcdb
	jp	diskio		;belieb. SektId lesen
	ENDIF

; gemeinsamer Zweig Read/Write 128-Sektor einzeln
;================================================
drwsec:
        ld      hl,dflg

dsktra: ;Aufruf diskio vom BIOS

diskio: ;Aufruf ueber Sprungvektor von BIOS-Erweiterung

;*********************************************************
; Umkleidung des physischer Disketten-Transfers
;*********************************************************

; Parameter: HL auf CDB mit folgender Struktur:
; +0: cdbfl     ;Flags  
diof00  equ     0       ;- Bit 0 **frei**
diofhd  equ     1       ;- Bit 1 =1, wenn Kopf hochnehmen ("headup")
diofwr  equ     2       ;- Bit 2 =1, wenn Schreiben
diofvf  equ     3       ;- Bit 3 =1, wenn Verify nach Schreiben
diofid  equ     4       ;- Bit 4 =1, wenn nur Sektid. zu lesen
dioftr  equ     5       ;- Bit 5 =1, wenn keine Fehlermeldung (und -behandlg)
diofps  equ     6       ;- Bit 6 =1, wenn nicht 'dpbstr' zu benutzen
dioffm  equ     7       ;- Bit 7 =1, wenn temporaer FM-Format erzwungen

; ab hier unwichtig bei Bit 1 in cdbfl =1 (headup)
; +1: cdbdev    ;logisches Geraet 0 .. dphnb-1
; +2: cdbtrk    ;Spur
; +3: cdbsec    ;erster zu uebertr. phys. Sektor
; +4: cdbsnb    ;Anz. zu uebertr. ph. Sekt. (<=4, wenn =0, so nur position.)
; +5: cdbslc    ;Sektorlaengencode (0=128, 1=256, 2=512, 3=1024)
; ab hier nur wichtig, wenn Bit 4 in cdbfl =0:
; +6,7: cdbdma  ;Transferadresse

; Return, falls nicht Bit 1 in cdbfl =1:
;       A=0 (ret z) bei fehlerfrei, sonst A=1 (ret nz) bei cdbfl, Bit 5 =0
;       oder Returncode phys. Transfer
;       E:=trk, D:=sid ,L:=sec, H:=len
;       BC,IX unveraendert

        bit     diofhd,(hl)     ;Kopf hochnehmen?
        jp      nz,headup       ;ja, kein Transfer

        push    bc
        push    ix
diorty:                ;interne Wiederholung diskio
        push    hl              ;merken hl
	inc	hl
	ld	c,(hl)		;logisches Laufwerk
	call	dgetpb		;IX auf DPB stellen
	pop	hl		;wiederherstellen hl
	push	hl
	ld	a,(ix+dpbsid)	;5"/8", FM/MFM, 40/80
	and	(1 shl 5)+(1 shl 4)+(1 shl 3)	;aus DPB uebernehmen
        bit     diofid,(hl)     ;Sekt.id lesen?
        jr      z,dionid        ;nein
        set     1,a             ;setzen Sektid lesen
dionid: set     0,a             ;setzen lesen
        bit     diofwr,(hl)     ;schreiben?
        jr      z,dionwr 	;nein, lesen
        bit     diofvf,(hl)     ;mit verify?
        jr      nz,diownv       ;ja
        res     0,a             ;loeschen lesen (nur schreiben)
diownv: set     2,a
dionwr:
if	pc1715
	or	16+8
endif
        ld      (ft.kom),a
        inc     hl

	ld	a,(ix+dpbdnr)	;physische LW-Nr.
	ld	(ft.lwn),a

	ld	a,(ix+dpbstp)	;Anzahl der Stepimpulse
	ld	(ft.stp),a

        ld      a,(ix+dpbsti)   ;Schrittzeit
        ld      (ft.sti),a

; Track und Side entpsr. Diskettenformat setzen
        inc     hl
        ld      d,(hl)          ;Track
        ld      e,d             ;merken
        inc     hl
        ld      c,(hl)          ;Sektornummer ab 1
        dec     c               ;Sektornr. ab 0
        bit     dpbf86,(ix+dpbflg)      ;Fortsetzung Dsk. auf Ruecks.?
        jr      nz,diots2       ;ja
        bit     dpbfds,(ix+dpbflg)      ;ungerade Spuren auf Rueckseite?
        jr      z,diotrs        ;nein, einseitig
        srl     d               ;Spur halbieren
        jr      nc,diotrs       ;gerade Spur, Vorderseite
        jr      diots1          ;auf Rueckseite
diots2: ld      b,(ix+dpbtrk)   ;log. Spurzahl
	srl	b		;Spuren auf Vorderseite
	ld	a,d
        sub     b               ;Spur auf Vorderseite?
        jr      c,diotrs        ;ja, Spur in d unveraendert lassen
                                ;40 ->  0; 41 ->  1; ...; 79 ->  39
                                ;77 ->  0; 78 ->  1; ...;153 ->  76
        bit     dpbfsv,(ix+dpbflg)      ;Ruecks. von aussen nach innen?
        jr      nz,diots4       ;ja
        cpl                     ;40 -> -1; 41 -> -2; ...; 79 -> -40
                                ;77 -> -1; 78 -> -2; ...;153 -> -77
        add     a,b             ;40 -> 39; 41 -> 38; ...; 79 ->   0
                                ;77 -> 76; 78 -> 75; ...;153 ->   0
diots4: ld      d,a
diots1: ld      a,(ft.kom)	;Versch. der Sektornr. auf Rueckseite
	set	7,a
	ld	(ft.kom),a
	ld	a,(ix+dpbsn0)
	add	a,c		;Sektornr. evtl. weiterzaehlen
	cp	c
	ld	c,a
        jr      nz,diotrs
	ld	a,1
	jr	diotss
diotrs: xor     a               ;side:=0
diotss: ld      (ft.sid),a      ;side setzen
        ld      a,d
        ld      (ft.trk),a      ;phys. Spur setzen

        ld      a,e             ;log. Spurnr. zurueck nach A
        cp      (ix+dpbofs)     ;Systemspur?
        jr      c,diossp        ;ja, Sektornummern nicht logisch
        ex      (sp),hl         ;hl auf cdbflg
        bit     diofps,(hl)		;Sektor-Nummer physisch?
        ex      (sp),hl
        jr      nz,diossp       ;ja
        ld      b,0
        add     ix,bc           ;IX entspr. Index in dpbstr
        ld      c,b             ;c:=0
diossp: ld      a,c             ;phys. Sektornr. ab 0
        add     a,(ix+dpbstr)   ;+echte Sektornr.
diossc: ld      (ft.sec),a

        inc     hl
        ld      a,(hl)          ;Anzahl zu transf. phys. Sektoren
        ld      (ft.anz),a

        inc     hl
        ld      a,(hl)          ;Sektorlaengencode
        ld      (ft.len),a

        inc     hl
        ld      e,(hl)          ;Transferadresse
        inc     hl
        ld      d,(hl)
        ld      (ft.adr),de

 IF stpvar or monitor
        call    delsps          ;Sondertasten verbieten
 ENDIF
        call    floppy          ;$$$ phys. Transfer $$$
	out	(moaus),a
 IF stpvar or monitor
        call    delspr          ;Sondertasten wieder erlauben
 ENDIF
        pop     hl              ;HL wieder auf Paramfeld-Adresse

        or      a               ;Returncode
        jr      z,dtrok         ; -> fehlerfrei
        cp      'R'             ;not ready?
        jp      z,diorty        ;ja, Wiederholung

; Fehlerprotokoll
        bit     dioftr,(hl)     ;Fehlerprotokoll unterdr.?
        jr      nz,dtrok        ;ja, keine Fehlerausgabe
 IF errvar
        ld      (derrcd),a      ;Fehlercode
        bit     diofwr,(hl)     ;war lesen?
        ld      a,'R'
        jr      z,derrr         ;ja
        ld      a,'W'
derrr:  ld      (derrrw),a
        ld      hl,ft.trk       ;phys. Spur
        ld      de,derrtr
        call    mbreco
        ld      a,(ft.sid)      ;Seite
	call	mbreco
        ld      hl,ft.sec
        call    mbreco
        ld      hl,derrms
        call    astl
 ENDIF
derrr1: ld      a,1             ;return mit Fehler

dtrok:  or      a               ;stellen Z-Flag
        ld      de,(ft.trk)     ;E:=trk, D:=sid
        ld      hl,(ft.sec)     ;L:=sec, H:=len
        pop     ix
        pop     bc
        ret

;
; IF errvar
; Fehlermeldung Disk I/O Error
;=============================
; Genau so lang (kurz), wie in Statuszeile Platz dafuer da ist!
; und das sind 17 Bytes!
;derrms:
;derrrw: db      'X'
;derrcd: db      'X;T,Si,Se='
;derrtr: db      'XX'
;derrts: db      'XX'
;derrsc: db      'XX'
;
; ENDIF
;
; CDB's
;======

        IF      format
; CDB fuer Bestimmung Spurformat
;------------------------------------
dfrflg:
dfrcdb:	db      (1 shl diofid)+(1 shl dioftr)
;               Lesen Sektorid., kein Fehlerprotokoll
dfrmdv: db      0ffh            ;Geraet
dfrmtr: db      0ffh            ;Spur
        db      1               ;Sektor (bel.)
        db      1               ;Sektoranzahl (>0)
        db      0               ;Sektorlaengencode
        ENDIF

        IF      format or (dbufsz gt 7)
; Puffer-CDB
;-----------
dbcdb:
dbflg:  db      1 shl dfbvf     ;mit Verify Schreiben
dfbprr	equ	0
;
;	equ	1		;=0 immer (Kopf bleibt)
dfbwr	equ	diofwr	;(=2)	;=1, wenn Puffer durch
;				     Schreiben veraendert
dfbvf   equ     diofvf ;(=3)    ;=1, wenn Verify Pufferschr.
;       equ     4               ;=0 immer (kein Sektid. lesen)
;       equ     5               ;=0 immer (mit Fehlerprotokoll)
;       equ     6               ;=0 immer (mit Sektortranslate)
;				     werden muss 	
dfbfm	equ	dioffm	;(=7)	;=1
dbdev:  db      0ffh
dbtrk:  db      0ffh
dbsec:  dw      0ffffh
dbsnb   equ     $-1
dbslc:  db      0ffh
        IF      dbufsz gt 7
dbdma:  dw      dbuf
	ELSE
dbdma:	dw	dirbuf	
        ENDIF
        ENDIF

; CDB fuer ungepufferte E/A
;--------------------------

dcdb:
dflg:   db      1 shl dfvf      ;mit Verify Schreiben
;       equ     1               ;=0 immer (Kopf bleibt)
dfwr    equ     diofwr ;(=2)    ;=1, wenn write-Aufruf
dfvf    equ     diofvf ;(=3)    ;=1, wenn Verify Schreiben
;       equ     4               ;=0 immer (kein Sektid lesen)
;       equ     5               ;=0 immer (mit Fehlerprotokoll)
;       equ     6               ;=0 immer (mit Sektortranslate)
dffm	equ	dioffm


 IF	format

; Stellen HL entsprechend Sektorlaengencode in (A)
;=================================================
; ret nz bei unzulaessigem
dtrsla:	or	a
	ld	hl,dtrsl0
	ret	z		;=0 (128)
	dec	a
	ld	hl,dtrsl1	;=1 (256)
	ret	z
	dec	a
	ld	hl,dtrsl2	;=2 (512)
	ret	z
	dec	a
	ld	hl,dtrsl3	;=3 (1024)
	ret

 ENDIF

;************************************************
;	Steuertabellen
;************************************************


 IF	format
; Modifizierungstabellen entspr. Sektorlaenge und LW-Typ
;-------------------------------------------------------

; Struktur:

dsltrk	equ	0		;benutzte Spuren
dslspt	equ	dsltrk+1	;Sektoren/Spur
dsldir	equ	dslspt+1	;Dir-Eintraege
dsloff	equ	dsldir+1	;2*offset
				;[+Flag fuer festes offset]
dslfo	equ	1		;festes offset
dslvo	equ	0		;offset =0, falls Directory mgl.
dslblk	equ	dsloff+1	;rel. Adr. Tab. BDOS-Blockgroesse
dsll	equ	5		;Laenge eines Eintrags

; Reihenfolge
; 5", 40 Tr, SS
; 5", 80 Tr, SS
; 5", 40 Tr, DS
; 5", 80 Tr, DS

; Zur automatischen Bestimmung des Spurformats wird dasjenige
; Format der Spur "dlgint" benutzt, alle folgenden Spuren
; muessen das gleiche Format haben!
dlgint	equ	3	;groesste Anzahl SS-Systemspuren

; 128
dtrsl0:	
	db	40,26,63,2*2+dslvo,dbl1k-$	;CP/M Standard
	db	80,26,127,2*2+dslvo,dbl2k-$
	db	80,26,127,2*0+dslfo,dbl2k-$
	db	160,26,127,2*0+dslfo,dbl2k0-$


; 256
dtrsl1:	
	db	40,32,63,2*3+dslfo,dbl2k-$	;SCP Hausformat A51xx
	db	80,32,63,2*3+dslfo,dbl2k-$	;SCP
	db	80,32,127,2*4+dslfo,dbl2k-$
	db	160,32,127,2*4+dslfo,dbl2k0-$	;SCP Hausformat PC1715


; 512
dtrsl2:	
	db	40,36,63,2*0+dslvo,dbl1k-$
	db	80,36,127,2*0+dslvo,dbl2k-$
	db	80,36,127,2*0+dslvo,dbl2k-$
	db	160,36,127,2*0+dslvo,dbl2k0-$

	
; 1024
dtrsl3:	
	db	40,40,63,2*2+dslvo,dbl1k-$	;CP/A Standard A51xx
	db	80,40,127,2*2+dslvo,dbl2k-$	;CP/A
	db	80,40,127,2*0+dslvo,dbl2k-$	;CP/A
	db	160,40,191,2*4+dslvo,dbl2k0-$	;CP/A (und SCP)


; Modifizierungstabellen fuer BDOS-Blockgroesse
dbl1k:	db	3,7,0		;Bl. Shift, Bl. Mask, Ext. Mask
dbl2k:	db	4,0fh,1
dbl2k0:	db	4,0fh,0		;fuer Kapazitaet >255

; log. Sektortranslate-Tabelle fuer 26*128
xlt:	db	1,7,13,19,25,5,11,17,23,3,9,15,21
	db	2,8,14,20,26,6,12,18,24,4,10,16,22

 ENDIF	;format
