;	modul zbrfl2.inc
;*********************************************************************
;	RAM-FLOPPY-TREIBER
;	UNTERSTUETZUNG von 2 RAM-FLOPPY 256K (nach MP 3/88)
;	(gelinkt 512K;  LW E:) 
;*********************************************************************
;
;	Grundadressen der RAM-Floppy-Platinen
;
RFL	EQU	98H
gadda	equ	98h
gaddb	equ	58h
;
;	RAM-Floppy Kaltstart
;	--------------------
rfl.kalt::
;
;	Kaltstartroutine der RAM-FL
;	Floppy-Bank 0 mit 0E5H beschreiben (in Bank 0 steht Directory)
;	bei Warmstart erfolgt Auswertung der Merkzelle CJUNGF 
;
	ld	hl,dphrfl
	ld	(dphe),hl
	ld	hl,ixrfl
	ld	(ixtab+('e'-'a')*2),hl
;
	ld	hl,rflmsg
	ld	b,rflme-rflmsg
	call	out$
	call	inchar
	res	5,a
	cp	'Y'
	jr	z,ini0
;
	ld	hl,rflm1
	ld	b,rflm1e-rflm1
	call 	out$
	ret
;
;rfloppy mit 0e5h initialisieren
ini0:	
	ld 	b,rflm2e-rflm2
	ld	hl,rflm2
	call	out$
	xor	a		;RAMFL loeschen
	ld	c,a
	out	(rfl+6),a
ini1:	xor	a
	ld	b,a
	out	(rfl+7),a   ;low-Adressteil  (DL 193)
	ld	a,0e5h
ini2:	out	(rfl+0),a   ;0. Bank beschreiben
        djnz	ini2
	inc	c
	ld	a,c
	out	(rfl+6),a   ;high-Adressteil (DS 8282)
	cp	0ffh
	jr	c,ini1
;
ini6:	ret
;
rflmsg: defb 	0DH,0AH
	defb	' RAM-Floppy im LW : E   loeschen ?   Y/(N)  : '
rflme:
;
rflm1:	db 'no',0DH,0AH
rflm1e:
rflm2:	db 'yes',0DH,0AH
rflm2e:
;
;	Lesen RAM-Floppy
;	----------------
rflrd:: ld	a,(dev)		;aktuelles Laufwerk
;
if gdck
	call	astl		;auf Statuszeile ausgeben
endif
;
	call 	adre
	inir
	xor	a		;kein fehler
	ret
;
;	Schreiben RAM-Floppy
;	--------------------
rflwr:: ld	a,(dev)
;
if gdck
	call	astl
endif
;
	call	adre
	otir
	xor	a		;kein fehler
	ret
;
;	Unterprogramm fuer RAM-Floppy
;	-----------------------------
adre::
	ld	hl,(trk)	
	ld	a,l
	cp	128		;>127 Spuren, dann 2.Karte
	ld	a,gadda
	ld	h,0
	jr	c,adr3
	ld	a,l
	sub	128
	ld	l,a
	ld	a,gaddb
adr3:	ld	(gaddr),a
	xor	a
	add	hl,hl
	add	hl,hl
	add	hl,hl	
	add	hl,hl
	ld	de,(sec)
	ld	d,0
	add	hl,de
	rr	h
	rr	l
	rra
	ld	b,a
	ld	a,(gaddr)
	add	a,7
	ld	c,a
	out	(c),b
	dec	c
	out	(c),l
	ld	a,h
adr1:	and	3
	ld	b,a
	ld	a,(gaddr)
adr2:	or	b
	ld	c,a
	ld	b,128
	ld	hl,(dma)
	ret
;
;ramfloppy beschreibungstabellen
dphrfl:	dw	0
	dw	0
	dw	0
	dw	0
	dw	dirbf
	dw	dpbrfl
	dw	csvrfl
	dw	alvrfl
;
dpbrfl:	dw	16
	db	4
	db	15
	db	0
	dw	255
	dw	127
	dw	0c0h
	dw	0
	dw	0
	db	11000000b	;kein fd,keine formaterk
;
gaddr:	db	98h		;aktuelle Grundadresse	
csvrfl:	db	0
alvrfl:	ds	50
;
; Ram Floppy Beschreibungstabelle
	db	0
	dw	rflrd
	dw	rflwr
ixrfl:	db	0
;
	

		