;MODUL BTAST.INC
;
;************************************************************
;--TASTATURABFRAGE FUER K 7652/59 MIT HARDWARE NACH MP 7/88-- 
;  MIT ZUSATZHARDWARE ZUR BILDSCHIRMUMSCHALTUNG NACH PETERS
;************************************************************
;
;MODEFLAGS
;BIT 0 : LANGE REPEATVERZ.DURCHLAUFEN
;    1 : STRINGAUSGABE
;    2 : GRAFIKMODE ON
;    3 : LEER
;    4 : CAPS
;    5 : TASTATURBEEP ON
;    6 : CRT-SPEED HIGH
;    7 : LEER
;
;VEREINBARUNGEN
;
K7652	EQU	1		;1 BEI TASTATUR K7652
K7659	EQU	0		;1 BEI TASTATUR K7659
K7669	EQU	0		;1 BEI TASTATUR K7669
LATCH	EQU	8		;TASTATURSPALTENLATCH A47
PIOBC	EQU	3		;SYSTEM-PIO, STEUERWORT
PIOBD	EQU	2		;SYSTEM-PIO, ZEILENINPUT
;

ZKPOS	EQU	6		;ZEITK. POSITIV-ENTRELLUNG
ZKNEG	EQU	6		;ZEITK. NEGATIV-ENTRELLUNG
ZKLREP	EQU	0C00H		;ZEITK. LANGE REPEATZEIT
ZKKREP	EQU	100H		;ZEITK. KURZE REPEATZEIT
;
;POINTERFELD TASTATUR
;
TAPOI:	DW	BELTAB		;TASTATURTAB.-POINTER
PO$TA:	DW	SFELD		;STRINGTAB.-POINTER
LFTB:	DW	FATAB-FTAB	;LAENGE FU-TASTENTAB
FTPOI:	DW	FTAB		;FU-TASTENPOS.-TAB.-POINTER
FTAPO:	DW	FATAB		;FU-TASTENADR.-TAB.POINTER
;
;TASTATUR-INITIALISIERUNG
;
INITAST:LD	A,0CFH		;TASTATUR-PIO BIT-MODE
	OUT	(PIOBC),A
	LD	A,7FH		;0-6 EINGABE, 7 AUSGABE
	OUT	(PIOBC),A
	LD	A,0EH		;LEDs AUF TASTATUR AUS
	OUT	(LATCH),A
	RET
;
;TASTATURSTATUS
;
STATCON:LD	A,(MSTAT)	;STATUS SCHON DURCHLAUFEN?
	OR	A
	JR	NZ,CONS6	;JA
	DEC	A
	LD	(MSTAT),A	;SETZEN STATUSDURCHLAUF
	INC	A		;A=0
	RET			;HERAUSSCHIEBEN BDOS-PUFFER
CONS6:	DI
	LD	A,0FH		;ALLE SPALTEN AKTIV
	OUT	(LATCH),A
	PUSH	HL
	IN	A,(PIOBD)
	CPL
	AND	0FH		;ZEILENINPUT-LEITUNGEN
	JR	NZ,CONS4	;TASTE GEDRUECKT
CONS7:	LD	A,(MLZ)		;VERGANGENE ABFRAGE AUCH SCHON 
	OR	A		;NEGATIV?
	JR	Z,CONS11	;JA
	LD	HL,ZKNEG*100H	;NEGATIV-ENTPRELZEIT
CONS12:	IN	A,(PIOBD)
	CPL			;ZEILE LOW AKTIV->HIGH AKTIV
	AND	0FH		;TASTE IMMER NOCH INAKTIV?
	JR	NZ,CONS4	;JA
	DEC	L
	JR	NZ,CONS12
	DEC	H
	JR	NZ,CONS12	;ENTPRELLZEIT NOCH NICHT ABGELAUFEN
CONS11:	LD	HL,ZKLREP	;LANGE REPEATZEIT
	LD	(ZZREP),HL
	XOR	A
	LD	(MZEIC),A	;LOESCHEN ZEICHEN
	LD	(MLZ),A		;LOESCHEN LETZTES ZEICH.
	LD	HL,MOFL
	RES	0,M		;REPEAT=0 INCHAR
	JR	CONS3
CONS4:	LD	HL,MZEIC
	CP	M		;WIEDER GLEIBHES ZEICHEN?
	JR	Z,CONS9		;JA
	LD	HL,ZKPOS*100H	;POSITIV-ENTPRELLZEIT 
CONS8:	IN	A,(PIOBD)	;NOCH MAL ABFRAGEN
	CPL
	AND	0FH
	JR	Z,CONS7		;KEINE TASTE GEDRUECKT
	DEC	L
	JR	NZ,CONS8	
	DEC	H
	JR	NZ,CONS8
	LD	HL,MZEIC
	CP	M		;ZEICHEN NOCH GLEICH?
	JR	NZ,CONS3	;NEIN
CONS9:	LD	HL,(ZZREP)
	LD	A,H
	OR	L		;ZAEHLZELLE SCHON AUF NULL?
	JR	NZ,CONS31	;REPEAT WURDE NICHT DURCHL.
CONS32:	LD	(MLZ),A
	INC	A
	LD	HL,ZKKREP	;ZK KLEINE REPEATVERZOEGERUNG
	LD	(ZZREP),HL
	JR	CONS3
CONS31: DEC	HL	
	LD	(ZZREP),HL
	LD	A,H
	OR	L		;REPEAT DURCHL.?
	JR	Z,CONS32	;JA
	XOR	A		;SONST STATUS=0 
CONS3:	POP	HL
	OUT	(LATCH),A	;AUSSCHALTEN SPALTEN
	OR	A	
	EI
	RET	Z
	LD	A,0FFH		;TASTE GEDR.
	LD	(TAPUF),A	;KENNZEICHEN FUER INCHAR
	RET

;
;ZEICHEN VON TASTATUR <A> MIT WARTEN AUF BETAETIGUNG
;
INCHAR:	DI
	PUSH	HL
	PUSH	DE
	PUSH	BC
	XOR	A
	LD	(MSTAT),A	;KZ STATUS RUECKSETZEN
INCHAR1: 
IF	RTC
	CALL	ASTL
ENDIF
	CALL	TAST
	OR	A
	JR	NZ,INCHAR2
	LD	B,A		;RETTEN
	LD	A,(TAPUF)	;WAR VORHER STATUS ERKANNT?
	OR	A
	LD	A,B
	JR	Z,INCHAR1	;JA, DANN MUSS ZEICHEN KOMMEN
INCHAR2:LD	HL,TAPUF
	LD	M,0
	POP	BC
	POP	DE
	POP	HL
	RET
;
;
;TASTATURPOLLING
; 
TAST:	LD	A,0FH
	OUT	(LATCH),A
	LD	HL,MOFL
	BIT	1,M		;STRINGMODE?
	JP	NZ,AUSG$
MINIT:	IN	A,(PIOBD)
	CPL
	AND	0FH		;MASKE
	JR	NZ,MSTA1
;
;KEIN ZEICHEN ERKANNT , MERKZELLEN RUECKSETZEN
;
MRETZ:	LD	HL,MOFL
	RES	0,M		;RUECKSETZEN REPEATKENNZ.
	LD	(MLZ),A
RET$:	OR	A
	RET	NZ
	LD	HL,ZKLREP	;ZEITKONSTANTE LANGE REPEAT
	LD	(ZZREP),HL	;ZK LANGE REPEAT STATUS
	OUT	(LATCH),A	;AUSSCHALTEN SPALTEN
	RET
;
MSTA1:	LD	A,(MLZ)		;LETZTES ZEICHEN=0?
	OR	A
	JR	Z,MP1
	BIT	0,M		; =1 WENN VORHER REPEAT
	JR	Z,MR0
;
;KLEINE REPEATVERZ.
;
	LD	B,28
MKV1:	LD	C,0
MKV2:	DEC	C
	JR	NZ,MKV2
	DJNZ	MKV1
	JR	MP1
;
;GROSSE REPEATVERZ.+NEGATIV ENTPRELLUNG
; 
MR0:	LD	B,0C0H
MR1:	LD	C,0
MR2:	IN	A,(PIOBD)
	CPL
	AND	0FH
	JR	Z,MR3
	DEC	C
	JR	NZ,MR2
	DJNZ	MR1
	SET	0,M
	JR	MP1
MR3:	LD	B,ZKNEG		;NEG. ENTPRELLZ. B*5ms
MR4:	LD	C,00H
MR5:	IN	A,(PIOBD)
	CPL
	AND	0FH
	JR	NZ,MR0
	DEC	C
	JR	NZ,MR5
	DJNZ	MR4
;
;SPALTENABTESTUNG
; 
MP1:	LD	B,ZKPOS		;POS-ENTPRELLZ. B*5ms
ENTPR:	LD	C,80H
	LD	A,(TAPUF)
	OR	A		;STATUS POSITIV ERKANNT?
	JR	Z,ZS1		;NEIN
	LD	BC,101H		;SONST KEINE POS. ENTPRELLUNG
ZS1:	IN	A,(PIOBD)
	CPL
	AND	0FH
	JP	Z,MRETZ		;KEINE TASTE MEHR GEDR.
	DEC	C
	JR	NZ,ZS1
	DJNZ	ENTPR
	LD	(MZEIC),A
MP0:	XOR	A
MP5:	CP	7
	JR	NZ,MP2
	INC	A
MP2:	OUT	(LATCH),A
	LD	D,A
MP3:	IN	A,(PIOBD)
	CPL
	AND	0FH
	JR	NZ,MP4
	LD	A,D
	INC	A
	CP	12		;ALLE 12 SPALTEN ABGEFRAGT?
	JR	NZ,MP5		;NEIN
	RES	0,M		;KEINE DER 12 SPALTEN WAR ES
FZUE:	XOR	A
	JP	MRETZ
;
;ERMITTLUNG TASTENPOSITION
; 
MP4:	LD	BC,708H
	OUT	(C),B		;SPALTE 7 AKT.
	SLA	D
	SLA	D
	SLA	D		;MULT.SPALTE MIT 8
	DEC	A
	ADD	A,D
	LD	E,A		;E=INTERNER TASTENCODE 0-95
	LD	(MLZ),A
;
;AUSWERTUNG SHIFT
; 
	IN	A,(PIOBD)
	AND	0FH
	XOR	8
	LD	A,E
	JR	NZ,FKTZU
	ADD	A,60H		;BEI SHIFT 96 AUF INTERNEN
	LD	E,A		;          CODE ADDIEREN
;
;FUNKTIONSZUORDNUNG
;
FKTZU:	LD	HL,(FTPOI)	;FUNKT.-TASTENTAB.-POINTER
	LD	BC,(LFTB)	;LAENGE TABELLE
	CPIR			;SUCHEN TAST.POS.
	JR	NZ,MP21
	DEC	HL
	LD	BC,(FTPOI)
	SBC	HL,BC		;HL:=GEF.POS.REL.
	SLA	L		;*2
	LD	BC,(FTAPO)	;F-TASTEN-ADRESS-TB
	ADD	HL,BC
	LD	C,M
	INC	HL
	LD	H,M
	LD	L,C		;HL=UP-ADRESSE
	LD	BC,MOFL		;MODEFLAGS
	LD	A,(BC)
	RES	0,A		;LOESCHEN LANGE REPEAT
	LD	(BC),A
	JP	(HL)
;
J100:	LD	SP,80H		;STACK INITIALISIEREN
	JP	100H
CRTW:	LD	A,(MINV)
	XOR	80H
	LD	(MINV),A
IF	GDCK
	CALL	ASTL		;STATUSZEILE INVERTIEREN
ENDIF
	XOR	A
	RET
SPEED:	LD	L,40H
	JR	AUSF
GRF:	LD	L,4		;GRAFIK FUNKTION EIN/AUS
	JR	AUSF		;IM CP/M MEIST NICHT GEBR.
BEEP:	LD	L,20H		;BEEP EIN/AUS
	JR	AUSF
SLOCK:	LD	L,10H		;CAPS EIN/AUS
AUSF:	LD	A,(BC)
	XOR	L		;ENTSPR.BIT IN MODEFL UMDREHEN
	LD	(BC),A
	XOR	A
	LD	E,A		;BEI FUNKTIOSTASTEN KEIN ZEICHEN
	JP	SETFF
MONRET:	XOR	A
	OUT	(HWMODI),A	;2 MHz, 32 Z/Z, ROM EIN
	JP	0F000H		;ROM START, ANFANGSLADER
B3264:	LD	L,80H		;UMSCHALTUNG 32/64 Z/Z
	JR	AUSF1
ZGUM:	LD	L,20H		;ZEICHENGENERATOR UMSCHALTEN
AUSF1:	IN	A,(HWMODI)
	XOR	L
	JR	AUSF2
F2MHZ:	IN	A,(HWMODI)	;2 MHz TAKT EINSCHALTEN
	AND	0BFH
	JR	AUSF2
F4MHZ:	IN	A,(HWMODI)	;4 MHz EINSCHALTEN
	OR	40H
AUSF2:	OUT	(HWMODI),A
IF	GDCK
	CALL	ASTL		;ANZEIGE TAKTFREQUENZ
ENDIF
AUSF3:	XOR	A
	RET
;
;ZEICHEN AUS TABELLE
;
MP21:	LD	HL,(TAPOI)	;TABELLENANFANG
	LD	D,0		;E=INTERNER CODE
	ADD	HL,DE		;BERECHN. TABELLENPOS.
	LD	A,M		;HOLEN ZEICHEN TABELLE 
	LD	E,A		;E=AUSZUGEBENDES ZEICHEN
;
;CONTROL FUNKTION
;
	IN	A,(PIOBD)
	AND	0FH
	CP	9		;CODE-TASTE BEI K7669
	JR	Z,SF$
	BIT	3,A		;CTRL-TASTE GEDRUECKT?
	JR	NZ,F$		;NEIN
	LD	A,E
	AND	9FH		;BIT 7 GESETZT LASSEN, DA
	LD	E,A		;SONST KEIN CODE 80H-9FH
	IN	A,(PIOBD)
	AND	0FH		;CTRL+SHIFT GEDRUECKT?
	JR	NZ,F$		;NEIN
SF$:	SET	7,E		;SONST BIT 7 SETZEN=INTERNES
	LD	A,E		;GRAFIKZEICHEN
;
;STRING FUNKTION
;
F$:	BIT	7,E
	JR	Z,MNULL		;KEINE STRINGFUNKTION EINLEITEN
	LD	(MLZ),A		;STRINGKENNZEICHEN MERKEN
	LD	HL,(PO$TA)	;ADR. STRINGFELD
F$1:	LD	A,M
	OR	A		;STRINGFELD ZU ENDE?
	JR	Z,MNULL		;JA
	INC	HL		;WEITERSUCHEN STRINGKENNZEICHEN
	CP	E
	JR	NZ,F$1		;NICHT GEFUNDEN
	LD	(NEXT$),HL	;POSITION DES STRINGS MERKEN
AUSG$:	LD	HL,(NEXT$)	;NAECHSTES STR.ZEICHEN
	LD	A,M		;ZEICHEN VOM STRING HOLEN
	INC	HL
	LD	(NEXT$),HL	;POINTER VERBESSERN
	LD	HL,MOFL		
	SET	1,M		;KENNZEICHEN STRINGMODE SETZEN
	BIT	7,A		;KZ VOM NAECHSTEN STRING?
	JR	NZ,AUSGE	;JA
	OR	A		;ENDE STRINGFELD?
	JR	Z,AUSGE		;JA
	LD	(MLZ),A		;MERKEN ZEICHEN VOM STRING
	RET			;ZEICHEN V. STRING WEITERGEBEN
AUSGE:	RES	1,M		;STRINGMODE AUS
	RES	0,M		;KEIN SCHNELLES REPEAT BEI
	XOR	A		;               STRINGS
	JP	RET$
;
;GRAFIK-MODE?
;
MNULL:	LD	HL,MOFL
	LD	A,E
	BIT	2,M		;GRAFIKMODE?
	JR	Z,MSM1		;NEIN
	ADD	A,80H		;SONST 80H ADDIEREN
	LD	E,A
;
;CAPS-TASTATURUMSCHALTUNG
; 
MSM1:	BIT	4,M
	JR	Z,MTE		;KEINE UMSCHAL. BIT 4=0
	LD	A,E
	CP	41H		;C-FLAG GES. FUER A<41H
	JR	C,MTE
;
;KONVERTIERUNG GROSS <-> KLEIN
;
MT5:	CP	5EH		;C-FLAG GESETZT FUER A<5BH
	JR	NC,MT61
	ADD	A,20H
	LD	E,A
	JR	MTE
MT61:	CP	61H		;C-FLAG GES. FUER A<61H (a)
	JR	C,MTE
	CP	7EH		;C-FLAG GES. FUER A<7BH
	JR	NC,MTE
	SUB	20H
	LD	E,A
;
;TASTATURBEEPIMPULS
; 
MTE:	LD	A,E
	LD	(MLZ),A		;LETZTES ZEICHEN 
	BIT	5,M		;BEEP ON?
	JR	Z,MLED1
	LD	BC,2039H	;ZK
PEEP:	PUSH	BC
MPE3:	PUSH	BC
	LD	A,C		;TONH.=0->PAUSE
	OR	A
	LD	A,0FH
	JR	Z,MPE4
	LD	A,0EH
MPE4:	OUT	(LATCH),A
	POP	BC		;C=f, B=t
	PUSH	BC
MPE1:	DEC	C		;NEGATIVE HALBWELLE
	JR	NZ,MPE1
	LD	A,0FH
	OUT	(LATCH),A
	POP	BC
	PUSH	BC
MPE2:	DEC	C		;POSITIVE HALBWELLE
	JR	NZ,MPE2
	POP	BC
	DJNZ	MPE3
	POP	BC
;
;NEUSETZEN FLIP-FLOP's
;
SETFF:	PUSH	HL
	LD	HL,MOFL
	LD	A,0EH		;LED-FLIP-FLOP
	OUT	(LATCH),A	;NEU SETZEN 
	BIT	3,M
	JR	Z,MGR
	LD	A,0CH
	OUT	(LATCH),A
MGR:	BIT	4,M
	POP	HL
	JR	Z,MLED1
	LD	A,0DH
	OUT	(LATCH),A
MLED1:	LD	A,7H
	OUT	(LATCH),A
	LD	A,E
	OR	A
	RET
;
	IF	K7652
;
;FUNKTIONSTASTEN-POS.TABELLE
;
FTAB:	DB	2EH		;GRAFIK ON/OFF
	DB	35H		;SHIFT-LOCK
	DB	41H+60H		;BEEP ON/OFF
	DB	43H		;MON-RET/RST 38H
;	DB	48H		;32/64 ZEICHEN BS UND 3/6 MHZ WAHL
;	DB	4CH		;ZG-UMSCH.
	DB	48H+60H		;2 MHZ SOWIE 3 MHZ
	DB	4CH+60H		;4 MHZ SOWIE 6 MHZ
	DB	40H+60H		;JMP 100
	DB	2EH+60H		;INVERSEINSCHALTUNG
	DB	40H		;TST-SLOW/FAST
;
;FUNKTIONSTASTEN-ADRESSTABELLE
;
FATAB:	DW	GRF
	DW	SLOCK
	DW	BEEP
	DW	MONRET
;	DW	B3264
;	DW	ZGUM
	DW	F2MHZ
	DW	F4MHZ
	DW	J100
	DW	CRTW
	DW	SPEED
;
;TASTENBELEGUNGSTABELLE
;ERSTE SHIFTEBENE
; 
BELTAB:	DB	31H		;A4/1
	DB	51H		;B2/Q
	DB	41H		;C2/A
	DB	59H		;D3/Y
	DB	32H		;A5/2
	DB	57H		;B3/W
	DB	53H		;C3/S
	DB	58H		;D4/X
	DB	33H		;A6/3
	DB	45H		;B4/E
	DB	44H		;C4/D
	DB	43H		;D5/C
	DB	34H		;A7/4
	DB	52H		;B5/R
	DB	46H		;C5/F
	DB	56H		;D6/V
	DB	35H		;A8/5
	DB	54H		;B6/T
	DB	47H		;C6/G
	DB	42H		;D7/B
	DB	36H		;A9/6
	DB	5AH		;B7/Z
	DB	48H		;C7/H
	DB	4EH		;D8/N
	DB	37H		;A10/7
	DB	55H		;B8/U
	DB	4AH		;C8/J
	DB	4DH		;D9/M
	DB	38H		;A11/8
	DB	49H		;B9/I
	DB	4BH		;C9/K
	DB	2CH		;D10/,
	DB	39H		;A12/9
	DB	4FH		;B10/O
	DB	4CH		;C10/L
	DB	2EH		;D11/.
	DB	30H		;A13/0
	DB	50H		;B11/P
	DB	5CH		;C11/\ oder OE	
	DB	2DH		;D12/-
	DB	7EH		;A14/~ oder SZ	
	DB	5DH		;B12/] oder UE
	DB	5BH		;C12/[ oder AE
	DB	60H		;A15/` 
	DB	2BH		;B13/+
	DB	23H		;C13/DOPPELKREUZ
	DB	0		;A3/GRAPHIK
	DB	40H		;D2/KOMMERZIELLES A
	DB	3EH		;A16/>
	DB	0DH		;D14/ENTER/CTRL-M
	DB	5		;E2/CURSOR HOCH /CTRL-E
	DB	8		;E6/CURSOR LINKS /CTRL-H
	DB	20H		;E4/LEERTASTE
	DB	0		;B1/CAPS ON/OFF
	DB	18H		;E1/CURSOR RUNTER /CTRL-J
	DB	4		;E7/CURSOR RECHTS /CTRL-D
	DB	0
	DB	0
	DB	0
	DB	0
	DB	0
	DB	0
	DB	0		;D1,D13/SHIFT
	DB	0		;C1/CTRL-TASTE
	DB	0		;A2/SLOW-FAST
	DB	7		;B14/DEL /CTRL-G
	DB	3		;A17/BREAK /CTRL-C	
	DB	0		;A1/MONITORRUECKKEHR
	DB	82H		;S4/'B:'
	DB	81H		;S3/'A:'
	DB	9		;E5/TAB /CTRL-I
	DB	1BH		;E3/ESC
	DB	12H		;S1/CTRL-R (32/64-ZEICHEN)
	DB	83H		;S5/'BIOS'  
	DB	92H		;S7/'DIR'
	DB	16H		;S9/INS /CTRL-V
	DB	13H		;S2/CTRL-S (2.ZG)
	DB	84H		;S6/'D:'
	DB	88H		;S8/'COPY'
	DB	7FH		;S10/DEL
	DB	0
	DB	0
	DB	0
	DB	0
	DB	0
	DB	0
	DB	0
	DB	0
	DB	0
	DB	0
	DB	0
	DB	0
	DB	0
	DB	0
	DB	0
	DB	0
;
;ZWEITE SHIFTEBENE
; 
TAB2:	DB	21H		;A4/!
	DB	71H		;B2/q
	DB	61H		;C2/a
	DB	79H		;D3/y
	DB	22H		;A5/"
	DB	77H		;B3/w
	DB	73H		;C3/s
	DB	78H		;D4/x
	DB	40H		;A6/@
	DB	65H		;B4/e
	DB	64H		;C4/d
	DB	63H		;D5/c
	DB	24H		;A7/DOLLAR
	DB	72H		;B5/r
	DB	66H		;C5/f
	DB	76H		;D6/v
	DB	25H		;A8/%
	DB	74H		;B6/t
	DB	67H		;C6/g
	DB	62H		;D7/b
	DB	26H		;A9/&
	DB	7AH		;B7/z
	DB	68H		;C7/h
	DB	6EH		;D8/n
	DB	2FH		;A10//
	DB	75H		;B8/u
	DB	6AH		;C8/j
	DB	6DH		;D9/m
	DB	28H		;A11/(
	DB	69H		;B9/i
	DB	6BH		;C9/k
	DB	3BH		;D10/;
	DB	29H		;A12/)
	DB	6FH		;B10/o
	DB	6CH		;C10/l
	DB	3AH		;D11/:
	DB	3DH		;A13/=
	DB	70H		;B11/p
	DB	7CH		;C11/| oder oe
	DB	5FH		;D12/_
	DB	3FH		;A14/?
	DB	7DH		;B12/} oder ue
	DB	7BH		;C12/{ oder ae
	DB	5EH		;A15/CONTROL ZEICHEN ^
	DB	2AH		;B13/*
	DB	27H		;C13/'
	DB	0		;A3/INVERS
	DB	1EH		;D2/NL
	DB	3CH		;A16/<
	DB	0DH		;D14/ENTER/CR
	DB	0BH		;E2/C.HOCH
	DB	8H		;E6/C.LINKS
	DB	20H		;E4/LEERTASTE
	DB	0		;B1/CAPS
	DB	0AH		;E1/C.RUNTER
	DB	9H		;E7/C.RECHTS
	DB	0
	DB	0
	DB	0
	DB	0
	DB	0
	DB	0
	DB	0		;D1,D13/SHIFT
	DB	0		;C1/CTRL-TASTE
	DB	0		;A2/J 100
	DB	0		;B14/BEEP
	DB	10H		;A17/HARDCOPY /CTRL-P
	DB	0		;A1/
	DB	94H		;S4/'TYPE' 
	DB	90H		;S3/'POWER' 
	DB	14H		;E5/AB C. LOESCHEN
	DB	19H		;E3/DELLINE /CTRL-Y
	DB	0		;S1/2 MHZ
	DB	8FH		;S5/'POWER COPY'
	DB	85H		;S7/'EXIT'
	DB	87H		;S9/'GROUP'
	DB	0		;S2/4 MHZ
	DB	86H		;S6/'POWER STAT'
        DB	99H		;S8/'TEST'
	DB	9AH		;S10/'POWER SIZE ***'
	DB	0		
	DB	0
	DB	0
	DB	0
	DB	0
	DB	0
	DB	0
	DB	0
	DB	0
	DB	0
	DB	0
	DB	0
	DB	0
	DB	0
	DB	0
	DB	0
;
	ENDIF
;
IF K7659
	INCLUDE K7659.MAC
ENDIF
;
IF K7669
	INCLUDE K7669.MAC
ENDIF
;
;STRINGFELD 
;
SFELD:	DB	81H             ;A
	DB	'A:',0DH
	DB	82H             ;B
	DB	'B:',0DH
	DB	83H             ;C
	DB	'A:BIOS ',0DH
	DB	84H             ;D
	DB	'E:',0DH
	DB	85H             ;E
	DB	'EXIT',0DH    
	DB	87H		;G
	DB	'GROUP',0DH
	DB	86H		;S
	DB	'POWER STAT',0DH
	DB	92H		;I
	DB	'DIR',0DH
	DB	94H		;T
	DB	'TYPE '
	DB	90H		;P
	DB	'POWER',0DH
	DB	8FH		;O
	DB	'POWER COPY',0DH
	DB	99H		;Y
	DB	'TEST',0DH              
	DB	9AH		;Z
	DB	'POWER SIZE ***',0DH
        DB      88H             ;F UND D
        DB      'COPY',0DH
END$F:	DB	0		
;
;ENDE $FELD
;
;ARBEITSZELLEN FUER TASTATUR
;
TAPUF:	DB	0		;TASTATURPUFFER
MSTAT:	DB	0		;MERKE STATUS
MZEIC:	DB	0		;MERKE ERGEBNIS STATUSABFRAGE
ZZREP:	DW	0		;ZAEHLZELLE STATUS-REPEAT
NEXT$:	DW	0		;STRING-ARBEITSZELLE
MLZ:	DB	0		;MERKE LETZTES ZEICHEN TASTATUR
;
;ENDE MODUL BTAST.INC
;
