;	modul ZBOOT2.INC
;***************************************************************
;	KALTSTART
;***************************************************************
;
boot::	ld	sp,spber
	call	zanfb		;ZELLENANFANGSBELEGUNG	
;
;	GERAETE-KALTINITIALISIERUNG
; 	---------------------------
	call	igdc1		;INIT BILDSCHIRM 80*24 + 80*1
	call	astl		;ANZEIGE STATUSZEILE
	call	initast		;INIT TASTATUR
	ld	hl,bootms	;KALTSTARTMELDUNG
	ld	b,bootme-bootms
	call	out$		
	call	rfl.kalt	;RAM-FLOPPY 512K
	call	mfl.kalt	;MINI-FLOPPY-LW
;
;	HARDWARE-MODIFIKATIONEN
;	~~~~~~~~~~~~~~~~~~~~~~~
	LD	A,01H
	LD	(IOBYTE),A	;IOBYTE SETZEN
	XOR	A
	LD	(MINV),A	;RUECKSTELLEN INVERS -> NORMAL	
	LD	(DEFAUL),A	;SETZEN DEFAULT LW
	LD	(MBOOT),A	;MERKEN KALTSTART
;
IF WBOOTV EQ 0
	LD	HL,CCP
	LD	DE,CCPKOP	;CCP-KOPIE ERSTELLEN
	LD	BC,CCPLN
	LDIR
ENDIF
;
IF WBOOTV EQ 3
	LD	A,40H
	OUT	(0CH),A
	LD	HL,CCP
	LD	DE,8000H
	LD	BC,CCPLN
	LDIR
	LD	A,0
	OUT	(0CH),A 
ENDIF
;
;*************************************************************
; 	WARMSTART
;*************************************************************
;
wboot:	ld	sp,spber
	call	zanfb		;WIEDER ZELLENANFANGSBELEGUNG
;
;	ccp wiederherstellen
; 
 if	wbootv eq 1	;Warmstart=Kaltstart
warmst	equ	bios00
 endif

 if	(wbootv eq 0) or (wbootv eq 2) or (wbootv eq 3) or (wbootv eq 4) or (wbootv eq 5)
;
warmst:	
 if	wbootv eq 0
	ld	hl,ccpkop	;;CCP von Kopie wiederherst.
	ld	de,CCP
	ld	bc,ccpln
	ldir
 endif
;
 if	wbootv eq 3
	ld	a,40h
	out	(0ch),a
	ld	hl,8000h
	ld	de,ccp
	ld	bc,ccpln
	ldir
	ld	a,0
	out	(0ch),a
 endif
;
 if	wbootv eq 2	;;CCP von File @OS.COM wiederhst.
ccplod:
	ld	a,0
ccpldv	equ	$-1		;;Kaltstart-Laufwerk (A=1,B=2,..)
	ld	(fcb@os),a
	xor	a
	ld	e,a		;;user 0
	ld	(fcb@os+12),a	;;extent
	inc	a		;;ab Satz 1 lesen
	ld	(fcb@os+32),a
	ld	c,32		;;set user 0
	call	bdos+6
	out	(0f6h),a
	ld	c,14		;;Reset Disksystem (LOGIN neu)
	call	bdos+6
	ld	c,15		;;open file in fcb:=@OS.COM
	call	de@os
	inc	a		;;Datei da?
	jr	z,nosys@	;;nein
	ld	b,+(ccpln+127)/128	;;128er records
	ld	hl,ccp		;;Zieladresse
ccpldz:	push	bc
	push	hl
	ex	de,hl
	ld	c,26		;;setdma
	call	bdos+6
	call	rd@os		;;read
	or	a		;;Fehler?
	jr	nz,nosyst	;;ja
	ld	hl,(CCP+1)	;;Test, ob richtiges @OS.COM
	ld	bc,0		;;bevor BDOS-Anfang ueberladen!
ccpjpm	equ	$-2		;;vom Kaltstart hinterlegt
	sbc	hl,bc		;;stimmt Sprungadresse?
	jr	nz,nosyst	;;nein, falsches CCP
	pop	hl
	ld	bc,80h
	add	hl,bc
	pop	bc
	djnz	ccpldz
	jr	ccplde		;ok
nosyst:	pop	hl
	pop	bc
nosys@:	ld	hl,nosysd
	call	out$
	jp	ccplde
;
nosysd:
 IF cpastz eq 0
	db	0dh,0ah
 ENDIF
	db	'Systemdiskette!  '
 IF cpastz eq 0
	db	07h,0
 ENDIF
fcb@os:	db	0		;;LW
	db	'@OS     COM'
	ds	21,0
rd@os:	ld	c,21
de@os:	ld	de,fcb@os
	call	bdos+6
	ret
ccplde:
 endif

; IF (wbootv eq 3) or (wbootv eq 4) or (wbootv eq 5)
;	rflcpw
;	ld	hl,bdskop
;	ld	de,BDOS
;	ld	bc,bdskpl
;	ldir			;BDOS-Kopf wiederherstellen
; ENDIF
ENDIF
;
	ld	bc,80h		;DMA-PUFFER WIEDER AUF 80H
	call	setdm
;
; 	geraete warminitialisierung
; 	---------------------------
	call	mfl.warm	;Minifloppy: Formaterkennung freigeben
	ld	a,1
	ld	(pf10er),a
;
; 	systemanspruenge setzen
; 	-----------------------
	ld	hl,biosan-0e00h+6
	ld	(cubdos),hl
noadev::
;
	ld	a,(3)
	ld	(iobyt),a
	ld	a,(4)		; pruefen, ob current dev. gueltig ist
	ld	d,a
	ld	c,a
	ld	b,0
	ld	hl,dpha
	add	hl,bc
	add	hl,bc
	ld	a,(hl)
	inc	hl
	or	(hl)
	jr	z,m104		; -> nicht gueltige current dev.
	ld	a,d
m104::	ld	(cudev),a	; aktuelles geraet
	ld	hl,syspa
	ld	de,0
	ld	bc,8
	ldir
	ld	c,a
;
	ld	hl,ccpanf+3	;kommando-loeschen
	ld	a,0
MBOOT	equ	$-1		
	or	a
	jr	nz,njungf
;
;	automatic bootstrap
;	~~~~~~~~~~~~~~~~~~~
	LD	HL,KALTCMD	;KALTSTART-KOMMANDO
	LD	DE,CCPANF+7	;IN CCP EINTRAGEN
	LD	BC,LKALTC
	LDIR	

	ld	hl,ccpanf	;kein kommando-loeschen
	ld	a,0ffh
	ld	(MBOOT),a
;
njungf::ld	a,c
	jp	(hl)		;und ab in den ccp	
;
;**************************************************************
;	ZELLENANFANGSBELEGUNG
;**************************************************************
;
zanfb:	in	a,(HWMODI)
	or	0d0h		;ROM aus, 4MHz
	out	(HWMODI),a 
	ret
;
OUT$:	push	bc
	ld	a,(hl)
	inc	hl
	ld	c,a
	push	hl
	call	zag
	pop	hl
	pop	bc
	djnz	out$
	ret
;
.XLIST
;
bootms::mbootm
bootme::
boot04::	
;
.LIST
;
;**************************************************************
;
syspa::	jp	biosan+3	; -> wboot
iobyt::	defb	095h		; list=lpt:/punch=ptp:/reader=ptr:/console=crt:
cudev::	defb	0		; current device
	defb	0c3h		; jp
cubdos::defw	0
;
;**************************************************************
;	kaltstart-kommando
;
kaltcmd:db	kaltce-kaltc
kaltc:	coldcm
kaltce:	db	0
lkaltc	equ	$-kaltcmd
;
;**************************************************************
