;***  Modul biopdskt.mac ***
;
;***************************************************************
;
;BEDIENPROGRAMM FUER FLOPPY-KARTE MIT 8272 ohne DMA
;
;***************************************************************
;
;=========================================================
;Floppy-Transfer ausfuehren
;=========================================================
; Aufruf:
; -------
; Bereitstellung der Parameter auf den Bytes:

;       ft.kom: db      0       ; bit0 - lesen
;                                    1 - lesen ft.len von beliebigem Sektor
;                                    2 - schreiben (wenn auch bit0: mit verify)
;                                    3 - 0-FM; 1-MFM   (5"FM nur bei PC1715)
;                                    4 - 0-8"; 1-5"
;                                    5 - 0- 40-Spur-Laufwerk; 1- 80-Spur-LW
;                                    7 - =0 Vorderseite, =1 Rueckseite
;       ft.adr: dw      0       ; Transferadresse
;       ft.lwn: db      0       ; 0..3 phys. Laufwerksnummer
;       ft.trk: db      0       ; 0..  track
;       ft.sid: db      0       ; 0..ff side (side=0 auf Rueckseite moeglich!)
;       ft.sec: db      0       ; 0..  sector (beliebig bei SektId lesen)
;       ft.len: db      0       ; 0..3 Sektorlaenge (auch 0..3 bei SektId les.)
;       ft.anz: db      0       ; 0..4 Anzahl der zu uebertragenden Sektoren
;                               ;      =0: nur Positionieren
;                               ;      (<>0 bei SektId lesen)
;       ft.stp: db      0       ;      Anzahl der Stepimpulse von Spur zu Spur
;       ft.sti: db      0       ;      Schrittzeit von Spur zu Spur
;                               ;      in 0,1ms Einheiten
;
;       call    floppy
;       ...                     ; in A steht Ergebniskode
;                               ; alle Register (auch IX) undef.
;
; Ergebniskode (in Reg. A):
;       00h kein Fehler (Z-Flag nicht von floppy gesetzt)
;       'C' CRC-Fehler
;       'D' LW nicht existent
;       'L' unzulaessige Byteanzahl (nur 128, 256, 512, 1024 erlaubt)
;       'R' Geraet nicht bereit, aber existent
;       'S' Sektor nicht gefunden
;       'T' Spurnummer zu gross
;       'U' keine Marke gefunden
;       'W' Diskette schreibgeschuetzt

; Paramfeld wird an folgenden Stellen veraendert:
;  Komm. "Lesen Sekt,Id.":      ft.trk .. ft.len gestellt
;  Komm. "Schreiben mit Verify":ft.kom, bit 0 geloescht
;**************************************************

floppy:
 IF dsk8fm+dsk8mf+dsk5fm
 .printx * Floppy-Treiber kann nur 5" MFM Laufwerke bedienen!!! *
 ENDIF

 if dsk80
        ld      a,(ft.kom)
 if dsk8fm+dsk8mf
        bit     4,a             ;5" LW?
        jr      z,dprecn        ;nein
 endif
        bit     5,a             ;80-Spur-LW?
        ld      a,25            ;Spur, ab der mit Praekomp.
        jr      z,dprec2        ;nein
        ld      a,41
dprec2: ld      (dpretr),a
dprecn:
 endif

; Modifizieren entsprechend phys. Sektorlaenge und Sektorzahl
        ld      hl,(ft.anz-1)   ;HL:=ftanz*256
        ld      l,0
        sra     h
        rr      l               ;HL:=ftanz*128
        ld      a,(ft.len)
        or      a
        jr      z,trnl1         ;128er Sektorloaenge
        ld      b,a
trnl2:  add     hl,hl           ;HL:=ftanz*2**(7+ftlen) -> Gesamtlaenge
        djnz    trnl2
trnl1:
        ld      b,h
        ld      c,l
        ld      hl,dtablt       ;Tabelle der Transferroutinen
trnl3:  ld      e,(hl)
        inc     e               ;Tabellenende?
        ld      a,'L'
        ret     z               ;ja, unzulaessige Laenge
        dec     e
        inc     hl
        ld      d,(hl)
        inc     hl
        ex      de,hl
        or      a
        sbc     hl,bc           ;gefunden?
        ex      de,hl
        jr      z,trnl4         ;ja
        inc     hl
        inc     hl
        jr      trnl3
trnl4:  ld      e,(hl)
        inc     hl
        ld      d,(hl)
        ld      (fiortn),de     ;Transfer-Routine eintragen

; Modifizieren entsprechend Step-Zeiten (ft.sti in .1ms Einheiten)
        ld      a,(ft.sti)
        dec     a               ;ft.sti-1
        ld      b,16
stil1:  dec     b               ;b:=16-(ft.sti-1) div 20
        sub     2*10            ;specify-Angabe in 2ms Schritten
        jr      nc,stil1        ;weitere 2ms abziehen
        ld      a,b
        add     a,a
        add     a,a
        add     a,a
        add     a,a
        or      hut/16/2
;	ld      (cdbfdc+1),a	; Vorsicht ! veraendert SPECIFY-Byte !

; Modifizieren entspr. Seitenauswahl
        ld      a,(ft.kom)
        bit     7,a             ;Rueckseite?
        jr      z,sidl1         ;nein
        ld      hl,fiohdr
        set     2,(hl)
sidl1:


        ld      a,10
        LD      (fiorte),a      ;Anzahl der Fehlerwiederholungen

fltr3:

; FDC mit Laufwerks-Daten fuellen
        LD      HL,CDBFDC       ;Specify
        LD      BC,300H         ;ohne Warten auf Resultat
        call    flcomm

        LD      A,(fiohdr)      ;SELECT DRIVE
        CALL    DRON
        jr      nz,fltr7        ;Fehler, keine Fehlerwiederholung

;Spur anfahren
        ld      a,(fiohdr)
        and     3               ;loeschen evtl. gesetzte Seite
        ld      hl,fiorec
        ld      c,a
        ld      b,0
        add     hl,bc
        bit     7,(hl)          ;ist LW schon recalibriert?
        jr      z,flrec         ;ja
        push    hl
        call    drtrk0
        pop     hl
        jr      nz,fltr9        ;Fehler bei recal., wiederh.
        res     7,(hl)          ;LW ist nun recalibriert
flrec:
        ld      a,(fiotrk)
        ld      b,a
        LD      A,(fiohdr)
        CALL    DRTRK
        JR      NZ,fltr9        ;Fehler bei Kommando, Wiederholung

; Test auf Sonderkommandos
        ld      a,(ft.kom)
        bit     1,a             ;Lesen Sektorid?
        jr      nz,drrid        ;ja
; Datentransfer
        bit     2,a             ;Schreiben?
        ld      a,46h
        jr      z,flrddt        ;nein, Lesen
        dec     a               ;sonst Schreiben
flrddt: ld      (fiocom),a
        ld      a,0a2h          ;ini-Befehl
        jr      z,flddio        ;Lesen
        inc     a               ;sonst outi
flddio: ld      (flrw4i+1),a
        ld      (flrw3i+1),a
        ld      (flrw2i+1),a
        ld      (flrw1i+1),a
   
        ld      a,(ft.anz)
        or      a               ;ft.anz=0, d.h. nur positionieren?
        jr      z,fltr7         ;ja, fertig, A=0

        LD      BC,900H         ;Result-Phase nicht abwarten
        ld      hl,fiocom
     DI                      ;ab jetzt Echtzeit wegen fehlendem DMA
; wenn hier schon DI-Befehl, so koennen u.U. 200 ms mit geschlossenen
; Interrupts vergehen!!
; Als Alternative werden die Interrupts erst nach der Uebertragung
; des ersten Datenbytes geschlossen (d.h. DI fuer max. 40 ms bei 1k Sektlng),
; dann ist jedoch evtl. eine Fehlerwiederholung notwendig, wenn zufaellig
; zwischen Ende der Kommandophase und Beginn der Execution-Phase (d.h.
; gesuchter Sektor in Spur gefunden und erstes Datenbyte wird uebertragen)
; ein Interrupt (z.B. CTC o. Tastatur) reinplatzt!
; Stoeren die 200ms DI nicht, so obigen DI-Befehl scharf machen
; (DI-Befehl in fiorw-Routine kann bleiben).

        CALL    flcomm
        JR      NZ,fltr9        ;Fehler bei Kommando, Wiederholung
        LD      D,10100000b     ;RDY und NDM
        LD      hl,(ft.adr)     ;Transferadresse
        CALL    fiorw           ;Daten-Transfer
        EI                      ;Echtzeit beenden

;Resultatbytes abholen
        CALL    flcomr
        jr      z,fltr7         ;ok

;FEHLER
;------
fltr9:  EI                      ;evtl. Echtzeit beenden
        ld      hl,fiorte
        DEC     (hl)            ;blieb weiterer Versuch?
        JR      z,fltr7         ; nein
        ld      a,(fiohdr)
        call    drtrk0          ;recalibrate
        jp      fltr3

; Ausgang phys. Floppy-Transfer
;------------------------------
fltr7:
        or      a               ;z-Flag fuer evtl. Fehler stellen
        ret

; LESEN SEKTORID
;===============
drrid:  ld      a,(fiohdr)
        ld      (cdbri+1),a
        ld      hl,cdbri
        ld      bc,201h
        call    flcomm
        jr      nz,fltr9        ;Fehler bei Kommando, Wiederholung
        ld      hl,statfd+3
        ld      de,ft.trk
        ld      bc,4
        ldir
        jr      fltr7

;LAUFWERK ANWAEHLEN
;==================
; i A   Kopfnr. in Bit 2, Laufwerksnr. in Bit 1,0
; ret z: fehlerfrei; ret nz Fehler mit Code in A (Buchstabe)

dron:	AND	3		;(BIT0=0 + BIT1=0) -> LW A
	JR	Z,DRO1
	OUT	(MOEIN2),A
	JR	DRO2
DRO1:	OUT	(MOEIN),A
DRO2:   LD      (CDBDRV+1),A


;SENSE DRIVE STATUS
        LD      BC,3000 ;UEBERWACHUNGSZEIT
dron1:  PUSH    BC
        LD      HL,CDBDRV
        LD      BC,0200H
        CALL    flcomm
        jr      nz,dron2        ;Fehler, wiederholen
        call    rqmdio          ;Resultat ST3 holen
        in      a,(fdcdat)
        pop     bc
        BIT     5,A             ;LW ready?
        JR      nz,dron4        ;ja

;ZEITUEBERWACHUNG
dron2:  dec     bc
        ld      a,b
        or      c
        jr      nz,dron1
        or      'R'             ;ret nz, 'R' fuer Fehler "not ready"
        RET

dron4:  XOR     A               ;ret z fuer fehlerfrei, A:=0
        RET

;ANGEWAEHLTES LAUFWERK AUF SPUR 0 FAHREN
;=======================================

; i A   Laufwerksnr. in Bit 1-0 (0..3)
; ret z: fehlerfrei; ret nz Fehler mit Code in A (Buchstabe)

DRTRK0: and     3               ;loeschen evtl. Seitenauswahl-Bit
        LD      (CDBTR0+1),A
        CALL    DRON            ;LAUFWERK ANWAEHLEN UND MOTOR EIN
        RET     NZ              ;Fehler
drtr0r: LD      HL,CDBTR0       ;RECALIBRATE
        LD      BC,201H         ;INT ERWARTET
        CALL    flcomm
        jr      nz,drtr0r       ;falls mehr als 77 Spuren
        ret

;ANGEWAEHLTES LAUFWERK POSITIONIEREN
;===================================
; i A           phys. Laufwerksnr. in Bit 1-0 (0..3), Kopfnr. in Bit 2
; i B           phys. Spurnr. 0..79
; i ft.stp      Zahl der Step-Impulse von Spur zu Spur (1..2)
; ret z: fehlerfrei; ret nz Fehler mit Code in A (Buchstabe)

DRTRK:
        LD      (CDBTRK+1),A
        ld      a,(ft.stp)      ;Zahl der Step-Impulse
        dec     a               ;=1?
        ld      a,b
        jr      z,drtrk2        ;ja
        add     a,b
drtrk2: LD      (CDBTRK+2),A
        ld      hl,dpretr
        cp      (hl)            ;Spur, ab der Praekomp. erreicht?

        call    inlat
        set     2,a             ;Praekomp ein
        jr      nc,drtrsp       ;Spur >=, Praekom.
        res     2,a             ;keine Praekomp.
drtrsp: call    outlat

drtrk1: LD      A,(CDBTRK+1)
        CALL    DRON
        RET     NZ              ;FEHLER
        LD      HL,CDBTRK
        LD      BC,301H
        CALL    flcomm
        RET     NZ              ;FEHLER
        LD      A,(STATFD)
        BIT     3,A             ;Abbruch wegen not ready?
        JR      NZ,DRTRK1       ;ja, Wiederholung

        RET


;
;AUSFUEHRUNG COMMAND , EXECUTION UND RESULT PHASE
;================================================
; i HL - ADRESSE DER KOMMANDOBYTES
; i  B - ANZAHL KOMMANDOBYTES
; i  C - BIT 0   0 KEIN WARTEN AUF FDC-INT SIGNAL , SONDERN RETURN
;              1 WARTEN AUF FDC-INT SIGNAL UND RESULTATSBYTES LESEN
; o  C - fdcdat
; o  ret z : kein Fehler, A=00
; o  ret nz: FEHLER , A enthaelt Fehlercode:
;               'W'     Diskette schreibgeschuetzt
;               'S'     Sektor nicht gefunden
;               'T'     Spur nicht zu finden
;               'C'     CRC-Fehler
;               'U'     undefiniert (z.B. keine Adressmarke)
;
flcomm:
        xor     a
        ld      (statfd+1),a    ;simulieren restliche Statusbytes
        ld      (statfd+2),a    ;fuer Fehlermeldung

; Command-Phase
;--------------
        LD      D,C             ;merken Warte-Bit
        LD      C,fdcdat

flcom1: IN      A,(fdcsta)      ;RQM , DIO
	rlca			;RQM?
	jr	nc,flcom1	;nein, warten
	rlca			;kann data geschrieben werden ?
	jr	c,flcom2	;nein !
	outi			;Kommandobyte ausgeben
	jr	nz,flcom1	;noch nicht alle Byte ausgegeben
	jr	flcomx
;
;RQM=1, DIO=1 -> Fehlersituation
;
flcom2:	in	a,(c)		;FDC-Antwort holen
	ld	(statfd),a
	jr	flcoma		;Abbruch
;
;Execution-Phase
;
flcomx:	xor	a		;soll sofort auf Result gewartet werden ?
	or	d
	ret	z		;nein, also return ohne Fehler
;
; Result-Phase abwarten
; Hierher Einsprung bei flcomm-Aufruf ohne Abwarten Result-Phase
;
flcomr: LD      C,fdcdat
flcmrw: IN      A,(fdcsta)      ;WARTEN AUF RQM
        rlca
        JR      nc,flcmrw
; RQM=1
        rlca                    ;KANN DATA GELESEN WERDEN ?
        JR      c,flcom7        ; JA , ES KANN

;RQM=1 , DIO=0: FDC ist frei fuer naechstes Kommando (nach Start Seek)
; Versuch, ob Interrupt anliegt
        ld      a,8             ;sense interrupt status
        out     (fdcdat),a
        call    rqmdio
        in      a,(fdcdat)      ;ST0 holen
        ld      (statfd),a      ;fuer Fehlerausgang hinterlegen
        cp      80h             ;war sense interrupt status erlaubt?
        jr      z,flcomr        ;nein, es lag kein Interrupt an
        call    rqmdio
        in      a,(fdcdat)      ;sonst PCN wegschmeissen
        jr      flcom9          ;seek auswerten
;
;Resultatsbytes aus FDC einlesen
flcom7: ld      hl,statfd
        ld      b,7             ;7 Bytes lesen
flcom8: CALL    RQMDIO
        INI
        JR      NZ,flcom8       ;AUF NAECHSTES BYTE WARTEN

;ALLE BYTES EINGELESEN
flcom9: ld      a,(statfd)
        AND     0C0H            ;IST EIN FEHLER GEMELDET
        RET     Z               ; NEIN , RETURN NORMAL
;
; Fehlerausgang
;--------------
flcoma: call    fdctc           ;TC erzwingen
        LD      hl,STATFD+1     ;FEHLERCODE
        ld      a,'S'
        bit     2,(hl)          ;Sector not found?
        ret     nz
        ld      a,'C'
        bit     5,(hl)          ;CRC-Fehler?
        ret     nz
        ld      a,'W'
        bit     1,(hl)          ;Write protected?
        ret     nz
        inc     hl
        ld      a,'T'
        bit     4,(hl)          ;Track not found?
        ret     nz
        ld      a,'U'           ;restliche Fehler nicht klassifizieren
        or      a
        RET                     ;ret nz, FEHLERRUECKSPRUNG

;
;RQM=1 und DIO=1 erwarten
RQMDIO:
        IN      A,(fdcsta)
        AND     0C0H
        CP      0C0H
        JR      NZ,RQMDIO
        RET

; TC ausloesen
;-------------
fdctc:	out     (fdclat),a		;TC ausloesen, a bel.
        ret

; sofortige Motorabschaltung
headup: out	(moaus),a
	ret
;
; Modifizierungstabelle entsprechend Transferlaenge
;--------------------------------------------------
dtablt:
        dw      1024,l1024
        dw      512,l512
        dw      256,l256
        dw      128,l128
        dw      0,0
        db      0ffh            ;Tabellenende


;*****************************************************
;       Arbeitsbereiche phys. Floppy-Treiber
;*****************************************************

; Parameterfeld ft.xxx (z.T in fioxxx)
;=====================================

ft.adr: dw      0       ;Transferadresse
ft.kom: db      0       ;Kommando
ft.anz: db      0       ;Anzahl zu uebertragender phys. Sektoren
ft.stp: db      0       ; Anzahl der Stepimpulse pro Spur
ft.sti: db      0       ; Schrittzeit von Spur zu Spur

; CDB fuer Lesen/Schreiben
fiocom: db      46h     ;Kommando fuer 8272
ft.lwn:                 ;Laufwerksnr. 0..3
fiohdr: db      0       ;bit 2 head; bit 1-0 drive
ft.trk:                 ;Spurnr. 0..255
fiotrk: db      0ffh    ;phys. Spur
ft.sid:                 ;Side 0..255
fiohed: db      0ffh    ;phys. Kopf
ft.sec:                 ;Sektornr. 0..255
fiosec: db      0ffh    ;phys. Sektor
ft.len:                 ;Sektorlaenge 0..3
fioslc: db      0ffh    ;phys. Sektorlaengencode
fioeot: db      0ffh    ;phys. groesster Sektornr. auf Spur     - immer 0ffh
fiogp3: db      020h    ;Laenge Gap3                            - immer 00eh
fiodtl: db      0ffh    ;volle Laenge des Sektors benutzen

fiorte: db      0ffh    ;Wiederholungszaehler

fiorec: db      80h,80h,80h,80h ;Bit 7 <>0: Recalibrate notwendig
dpretr: db      41      ;Praekomp-Spur

fiorw:  jp      0       ;wird mit Routine fuer read/write Daten modif.
fiortn  equ     $-2

;CDB's fuer Floppy-Controller Intel 8272
;=======================================
 
;5" MFM 80, Track, DS (Zeiten und Schrittweiten *2 ergeben sich aus 4MHz clock)
srt     equ     14     ;ms step rate time   in  2 ms Schritten (2,4,...,32)
                        ;laut Daten 4ms gefordert
hut     equ     0	;ms head unload time in 32 ms Schritten (32,64,...,480)
hlt     equ     15     ;ms head load time   in  4 ms Schritten (4,8,...,508)
;
; Spezify, alle Zeiten /2 wegen 4MHz  clock
CDBFDC: db      3       ;SPECIFY
        db      srt*16+hut
        db      hlt*2+1   ;ND=1 (Arbeit ohne DMA)
;
CDBTR0: db      7       ;RECALIBRATE COMMAND
        db      0       ;LAUFWERKSNR
;
CDBTRK: db      0FH     ;SEEK
        db      0       ;LW-NR. 0...3
        db      0       ;SPURNR. 0...39
;
CDBDRV: db      04      ;SENSE DRIVE STATUS
        db      0       ;DRIVE NUMBER
;
CDBRI:  db      4AH     ;READ ID COMMAND
        db      0       ;LAUFWERKSNR


; Eigentlicher Datentransfer (im RAM, da ini/outi -Modif.)
;===========================
; Es koennen mehrere phys. Sektoren hintereinander uebertragen werden
; i C   fdcdat
; i D   Schnittmaske fuer fdcsta (RQM+NDM)
; io HL Zeiger auf Daten
; Reg E bleibt erhalten

; 128 BYTES
L128:   LD      B,128
        JR      flrw1

; 256 BYTES
L256:   LD      B,0
        JR      flrw1

; 512 BYTES
L512:   LD      B,0
        JR      flrw2

; 1024 BYTES
L1024:  LD      B,0

; Zur Verfuegung stehende Takte bei 9600*256 = 2.4576 MHz und einer
; 5" MFM Byterate von 27 Mikrosec pro Byte:
; 27 Mikrosec / (1/(9600*256)) = 27*10**(-6)*9600*256 = 66.3 Takte

flrw4:  IN      A,(fdcsta)      ;                                       11
        and     d
        jp      p,flrw4
        ret     po
flrw4i: INI                     ;wird auf outi modif. bei Ausgabe       16
        Jp      NZ,flrw4        ;                                       12
;               Gesamtsumme der Taktzahlen ergibt                       ---
;               Taktzahl zwischen 2 Bytes                               62

flrw3:  IN      A,(fdcsta)
        and     d
        jp      p,flrw3
        ret     po
flrw3i: INI                     ;wird auf outi modif. bei Ausgabe
        Jp      NZ,flrw3

flrw2:  IN      A,(fdcsta)
        and     d
        jp      p,flrw2
        ret     po
flrw2i: INI                     ;wird auf outi modif. bei Ausgabe
        Jp      NZ,flrw2

flrw1:  IN      A,(fdcsta)
        and     d
        jp      p,flrw1
        ret     po
flrw1i: INI                     ;wird auf outi modif. bei Ausgabe
        Jp      NZ,flrw1

        jp      fdctc           ;Gesamtlaenge erreicht, TC

; Resultat-Bytes letzter Floppy-Transfer (im Haupt-RAM fuer evtl. Fehlersuche)
STATFD: DEFS    7,0ffh  ;MAX 7 RESULT-BYTES VOM FDC

; Interruptroutine fuer Motor aus
ifdcmo: ld      (ifdcsp),sp     ;max. Stackbelastung nur Intadr.
        ld      sp,ifdcst
        push    af
        ld      a,0             ;Zaehler
fdcmcn  equ     $-1
        or      a               ;=0?
        jr      z,ifdcm1        ;ja, Interrupt ignorieren
        dec     a
        ld      (fdcmcn),a
        call    z,fdcmof        ;jetzt =0, Motor ausschalten
ifdcm1: pop     af
        ld      sp,0
ifdcsp  equ     $-2             ;geretteter Stackpointer
        ei
        reti
        ds      3*2,0fbh        ;Stack fuer Interruptroutine
ifdcst: ;Stack Interrupt-Routine rueckwaerts

; Motor aus
; nur Reg. AF darf zerstoert werden, kein push wegen Stackbelastung
fdcmof: OUT	(MOAUS),A
	ret

; FDC3-Latch-Register kann nicht rueckgelesen werden, daher merken
outlat:
; Kein Register darf zerstoert werden
        OUT     (fdclat),A
        LD      (fdclcp),A
        RET
inlat:
; Nur Register A darf zerstoert werden
        LD      A,0
fdclcp  equ     $-1
        RET

; Transfer Floppy-Puffer <-> Nutzer-DMA
flldir: ld      a,00100011b     ;ROM/RAM auf CPU aus
; Eingang fuer DRAM128 mit zuvor geladener Bank
flldix: ldir
        ld      a,00100000b     ;ROM/RAM auf CPU wieder zuschalten
        ret

