.TFCOND 
;
	NAME	('ZBOS3')
	TITLE	CBIOS FUER z 1013
.Z80
;***************************************************************
;
;	CP/M-BIOS fuer Z1013-System mit:
;
;	- 512 KByte (2 gelinkte) RAM-Floppy nach MP 3/88 
;	- Tastatur K7652/59/69 mit Hardware nach MP 7/88 	
;	- 80*25 Zeichen-BS mit GDC U82720
;	- Floppy-Treiber mit FDC U8272 (autom. Formaterkennung) 
;	- System-Uhr mit RTC 72421
;	
;	'public domain'
;
;	unter Verwendung von: BIOS503 (c) by R.Brosig
;			      CP/A fuer PC1715 (c) by AdW
;			      ZBOS fuer KC85/4
;			      CBIOS Y23VO (c) by M.Kramer
;
;	erstellt von Th. Herrmann (Y22VJ)      		Jena 5/91 	
;
;	Uebersetzen mit M80, linken mit LINKMT
;	A>M80 ZBOS3xx.ERL=ZBOS3xx
;	A>LINKMT ZBOS3xx
;
;***************************************************************
;
;	Kaltstartmeldung
;
mbootm	macro
	defb	0CH,0DH,0AH
	defb	'Z1013-CP/M 2.2+   Vers. 6.0 (Y22VJ)    Jena 05/91',0DH,0AH,0AH
	defb	' - 2 LW 1.6 (A:,B:) mit automatischer Formaterkennung',0DH,0AH
	defb	' - 512 KByte (2 gelinkte) RAM-Floppy (E:)',0DH,0AH	
	defb	' - Tastatur K 7652 RB',0DH,0AH
	defb	' - Druckertreiber ueber V24 ',0DH,0AH,0AH,0AH
 endm
;

;
;	DEFINITION VON KONSTANTEN
;	SCHALTER
;	
GDCK	EQU	1		;1 BEI 80*25 BILDSCHIRM MIT GDC
Z1013CRT EQU	0		;1 BEI Z1013 64*16 BILDSCHIRM
RTC	EQU	1		;1 BEI SYSTEMUHR MIT RTC 62/72 421
V24MOD	EQU	0		;1 BEI DRUCK UEBER V24-MODUL/0=USERPORT
V24     EQU     1               ;1 bei DRUCK UEBER V24
S3004A  EQU     0               ;1 BEI S3004
CENTRO	EQU	0		;1 BEI CENTRONICS-PORT/0 BEI V24 
ERRVAR	EQU	1		;1 BEI I/O-ERROR-AUSWERTUNG
PC1715	EQU	0		;1 BEI PC1715
MONITOR	EQU	0		;1 BEI BIOS-MONITOR
CPASTZ	EQU	1		;1 BEI STATUSZEILE
STPVAR	EQU	0		;OHNE STOP-FUNKTION
;	
;	SPEICHERADRESSEN
;
TPA	EQU	00100H
CCP	EQU	0C000H
CCPANF	EQU	CCP
CCPLN	EQU	00800H
BDOS	EQU	CCP+CCPLN
BDOSLN	EQU	00E00H
BIOS	EQU	BDOS+BDOSLN
BIOSAN	EQU	BIOS
;
REBOOT	EQU	0		;
IOBYTE	EQU	3		;I/O-BYTE
DEFAUL	EQU	4		;AKTUELLES LW BDOS
BDOSJP	EQU	5		;BDOS-EINSPRUNG
;
;	I/O-ADRESSEN
;
HWMODI	EQU	4		;HARWAREMODIFIKATIONEN
;
;IM NORMALFALL WIRD CCP VON EINER IM BIOS GEHALTENEN KOPIE BEI
;JEDEM WARMSTART VOR DAS BDOS KOPIERT. DAMIT SIND KEINE SYSTEM-
;SPUREN AUF DEM FOLIENSPEICHER ERFORDERLICH.
;UM ABER EINE MAX. GROSSE TPA ZU ERHALTEN, SIND AUCH ANDERE VA-
;RIANTEN DENKBAR:
;
WBOOTV	EQU	0
;   		= 0: CCP-KOPIE IM BIOS (2K-PUFFER)
;		= 1: KEINE KOPIE, BOOT=WBOOT
;		= 2: KEINE KOPIE, CCP AUS FILE "OS2.COM"
;		= 3: CCP-KOPIE IN RAM/ROM-BANK
;
;	KALTSTART-KOMMANDO
;
COLDCM	MACRO
KLTBEF:	DB	'DIR *.COM'
	ENDM
;
IF1
.PRINTX	* ZBOS-Uebersetzung PASS 1 *
ENDIF
;
IF2
.PRINTX	* ZBOS-Uebersetzung PASS 2 *
ENDIF
;
;**************************************************************
;
LADER:	LD	HL,ZBANF		;PROGRAMMANFANG
	LD	DE,CCP
	LD	BC,BIOSEN-CCP
	LDIR
	JP	BIOS
;
ZBANF	EQU	$
;
.PHASE	CCP
;
.XLIST
;
	INCLUDE	CCP.INC
	INCLUDE BDOS.INC
;
.LIST
;
BIOS00:	JP	BOOT		;EINSPRUNG VOM KALTSTART
BIOS03:	JP	WBOOT		;WARM-START-EINSPRUNG
;
;	EINFACHE ZEICHEN-E/A
;
BIOS06:	JP	CONST		;KONSOLSTATUS (IST ZEICHEN DA?)
BIOS09:	JP	CONIN		;KONSOLZEICHEN EINLESEN
BIOS0C:	JP	CONOU		;KONSOLAUSGABE
BIOS0F:	JP	LIST		;ZEICHEN AUF LISTER AUSGEBEN
BIOS12:	JP	RETURN		;ZEICHEN AUF PUNCH AUSGEBEN
BIOS15:	JP	RETURN		;ZEICHEN VOM READER EINLESEN
;
;	DISKETTEN-E/A
;
BIOS18:	JP	HOME		;LESEKOPF AUF AKTUELLEM LW
				;AUF SPUR 00 POSITIONIEREN
BIOS1B:	JP	SELDS		;LAUFWERK SELEKTIEREN
BIOS1E:	JP	SETTR		;SETZE SPURNUMMER
BIOS21:	JP	SETSE		;SETZE SEKTORNUMMER
BIOS24:	JP	SETDM		;SETZE DMA-ADRESSE
BIOS27:	JP	READ		;LESE SELEKTIERTEN SEKTOR
BIOS2A:	JP	WRITE		;SCHREIBE SELEKTIERTEN SEKTOR
BIOS2D:	JP	LISTS		;STATUS DES LISTERS
BIOS30:	JP	SECTR		;SEKTORUEBERSETZUNG
;	
bios33:	db	'Z10'		;scp-Kennzeichen ist 'BW '
bios36:	db	'13 '		;Z1013
bios39: dw ixtab		;fuer spaetere Anwendung Zeiger an def. Stelle
	db 0
bios3c:	jp	return
bios3f:	jp	return
bios42:	jp	return
bios45:	jp	return
;
;	ENDE DES FESTEN BIOS-BEREICHES
;
;***************************************************************
;	
;	DISK-PARAMETER-TABELLE
;
;	Minifloppy Drive 0
;
dphfl0:	dw	0		;kein Sektortranslate
	dw	0		;BDOS Spur
	dw	0		;BDOS Sektor
	dw	0		;BDOS Dir
	dw	dirbuf
	dw	dpbfl0
	dw	chkfl0
	dw	allfl0

;	Minifloppy Drive 1
;
dphfl1:	dw	0		;kein Sektortranslate
	dw	0		;BDOS Spur
	dw	0		;BDOS Sektor
	dw	0		;BDOS Dir
	dw	dirbuf
	dw	dpbfl1
	dw	chkfl1
	dw	allfl1
;
;***************************************************************
;	DISK-PARAMETER-BLOECKE
;
; 	Die Steuertabellen sind so dimensioniert, dass folgende Parameter
; 	moeglich sind (durch Dienstprogramm FORMAT von aussen setzen):
; 	800k Kapazitaet
; 	256 Dir-Eintraege
; 	26 phys. Sektoren pro Spur(seite)
; 	Damit sind alle gaengigen Formate (800, 720, 624, 360, 200, 148)
;	einstellbar!
;
;	5*1024*160, 0 Systemspuren (CP/A)
;
dpbfl0:	dw	40		;Sekt/Spur
	db	4		;2k Bloecke
	db	15
	db	0
	dw	800/2-1
	dw	192-1		;Dir Entries
	db	0E0h,0		;0C0h,0
	dw	192/4
	dw	0		;Systemspuren
;
	db	00100000b	;Floppy-DPB, DS betreiben, autom. FMT 
	db	3		;1k Sektorlaenge
	db	8-1		;8 128er Sektoren im Puffer
	db	1		;1 Stepimpuls von Spur zu Spur
	db	0		;kein Weiternummerieren auf Rueckseite
	db	160		;160 log. Spuren
;
	db	0		;phys. LW-Nr.
	db	80		;LW hat 80 phys. Spuren
	db	20		;Schrittzeit in 0.1ms Einheiten
	db	00111001b	;80 Spur/5"/MFM/DS
;
	db	1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16
	db	17,18,19,20,21,22,23,24,25,26
				;Reihenfolge fuer Sektorzugriff
;
;	5*1024*160, 0 Systemspuren (CP/A)
;
dpbfl1:	dw	40		;Sekt/Spur
	db	4		;2k Bloecke
	db	15
	db	0
	dw	800/2-1
	dw	192-1		;Dir Entries
	db	0E0h,0		;0C0h,0
	dw	192/4
	dw	0		;Systemspuren
;
	db	00100000b	;Floppy-DPB, DS betreiben, aut. FMT
	db	3		;1k Sektorlaenge
	db	8-1		;8 128er Sektoren im Puffer
	db	1		;1 Stepimpuls von Spur zu Spur
	db	0		;kein Weiternummerieren auf Rueckseite
	db	160		;160 log. Spuren
;
	db	1		;phys. LW-Nr.
	db	80		;LW hat 80 phys. Spuren
	db	20		;Schrittzeit in 0.1ms Einheiten
	db	00111001b	;80 Spur/5"/MFM/DS
;
	db	1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16
	db	17,18,19,20,21,22,23,24,25,26
				;Reihenfolge fuer Sektorzugriff
;
; 	stackrettung
; 	------------
;
reta::	ex	(sp),hl
	ld	(spret),sp
	ld	sp,spber
	push	de
	push	bc
	push	ix
	push	iy
	jp	(hl)
;
retu::	pop	iy
	pop	ix
	pop	bc
	pop	de
	ld	sp,(spret)
	pop	hl
return::ret
;
;	Verteiler fuer die 1-Zeichen-Kanaele entsprechend IOBYTE:
;	=========================================================

constv:			; iobyte  00 00 00 xx
	call	iodisp
	db	0
	dw	CONST0		;0 kbd:
	dw	CONST1		;1 kbd:
	dw	CONST2		;2 kbd:
	dw	CONST3		;3 kbd:

coninv:			; iobyte:  00 00 00 xx
	call	iodisp
	db	0
	dw	CONIN0		;0 kbd:
	dw	CONIN1		;1 kbd:
	dw	CONIN2		;2 kbd:
	dw	CONIN3		;3 kbd:

conouv:			; iobyte:  00 00 00 xx
	call	iodisp
	db	0
	dw	CONOU0		;0 crt:
	dw	CONOU1		;1 crt:
	dw	LISTOV		;2 lpt:
	dw	CONOU3		;3 crt + lpt:

readev:			; iobyte:   00 00 xx 00
	call	iodisp
	db	1
	dw	0		;0 
	dw	0		;1
	dw	0		;2 
	dw	0		;3 

reader:			; iobyte:   00 00 xx 00
	call	iodisp
	db	1
	dw	0		;0 
	dw	0		;1 
	dw	0		;2 
	dw	0		;3 
;
punchv:			; iobyte:   00 xx 00 00
	call	iodisp
	db	3
	dw	0		;0 
	dw	0		;1 
	dw	0		;2
	dw	0		;3 
;
listsv:			; iobyte:  xx 00 00 00
	call	iodisp
	db	6
	dw	LSST0		;0 lpt:
	dw	LSST1		;1 lpt:
	dw	LSST2		;2 lpt:
	dw	LSST3		;3 lpt:
;
listov:			; iobyte:  xx 00 00 00
	call	iodisp
	db	6
	dw	LIST0		;0 lpt:
	dw	LIST1		;1 lpt:
	dw	LIST2		;2 lpt:
	dw	LIST3		;3 lpt:
;
; 	IOBYTE-Auswertung - Verteilung auf die physischen Geraete
; 	---------------------------------------------------------
; 	A,HL werden zerstoert
;
iodisp::
	pop	hl		;iobyte-adr. des phys. geraetes 
	push	bc
	push	de
	ld	a,(hl)		;iobyte laden
	inc	hl		;hl auf verteiler
	ld	b,a
	or	a		;0 ?
	ld	a,(3)		;system-iobyte laden
	jr	z,iodis2
iodis1::
	rra
	djnz	iodis1		;rotation um wert des phys. iob.
iodis2::
	and	3
	rla
	ld	c,a
	add	hl,bc
	ld	e,(hl)
	inc	hl
	ld	d,(hl)
	ex	de,hl
	pop	de
	pop	bc
	jp	(hl)
;
; 	consol-status
; 	-------------
;
const::	call	reta		; iobyte  00 00 00 xx
	call	constv		; aufloesung entsprechend iobyte
	jp	retu
;
const0::
const1::
const2::
const3::
	call	statcon
	ret
;
; 	consol eingabe
; 	--------------
;
conin::				; iobyte:  00 00 00 xx
	call	reta
	call	coninv		; aufloesung iobyte
	jp	retu
;
conin0::
conin1::
conin2::
conin3::
	call	inchar
	ret
;
;
; 	console ausgabe
; 	---------------
;
conou::				; iobyte:   00 00 00 xx
	call	reta
	push	af
	call	conouv		; aufloesung iobyte
	pop	af
	jp	retu
;
conou0::
conou1::
conou3::
	call	zag		;zeichenausgabe
	ret
;
;       drucker status 
;       --------------
;
lists:	call	reta
	call	listsv
	jp	retu
;
lsst0::
	call statdr
	ret
lsst1::
lsst2::
lsst3::
	xor	a
	ret
;
;        drucker ausgabe
;        ---------------
;
list:
	call	reta
	push	af
	call	listov
	pop	af
	jp	retu
;
list0::	
	call zeidr
	ret
list1::
list2::
list3::
	ret
;
	INCLUDE BTAST.INC
	INCLUDE BGDCK.INC
 if RTC
	INCLUDE BRTC.INC
 endif
	INCLUDE BDRUCK.INC
	INCLUDE KCDEQU.INC
;	
;READ/WRITE HILFSROUTINEN
;------------------------
;
SETSE::	LD	(SEC),BC
	RET
;
home:	call	reta
	IF	dbufsz gt 7
	ld	hl,dbflg
	bit	dfbwr,(hl)		;veraenderter Puffer?
	jr	nz,home1		;ja, nicht freigeben
	ld	a,0ffh			;sonst Diskwechsel erlauben
	ld	(dbdev),a		;Puffer ist nicht aktiv
	ENDIF		;dbufsz
home1:	ld	c,0
settrk:	ld	a,c			;Spur 0 einstellen
	ld	(trk),a			;Spur merken
	jp	retu
;
settr:	ld	(trk),bc
	ret
;
SETDM:	LD	(DMA),BC
	RET
;
SELDS::	ld	b,e			;retten LOGIN-Bit
	call	dgetpb			;HL auf DPH stellen, IX auf DPB
	ret	z			;Geraet ex. nicht
	ld	a,c
	ld	(dev),a			;Laufwerk merken
	bit	0,b			;LOGIN von BDOS?
	ret	nz			;nein
	push	hl			;^DPB merken
;
	IF	dbufsz gt 7
	ld	hl,dbdev
	cp	(hl)			;LOGIN fuer gepuffertes Device?
	jr	nz,dselnb		;nein
	ld	(hl),0ffh		;Puffer ist ungueltig
	ld	hl,dbflg
	res	dfbwr,(hl)		;kein veraend. Puffer auszug.!
dselnb:
	ENDIF		;dbufsz
;
	IF	format
;
;***************************************************************
;	Automatische Format-Erkennung
;***************************************************************
;
	bit	dpbfrm,(ix+dpbflg)	;Formaterkennung unterdr.?
	jp	nz,selext		;ja
;
	IF	dbufsz gt 7
 	call	dbtrw			;Puffer freimachen
					;und auf Lesen schalten
	ENDIF
;
	ld	a,c
	ld	(dfrmdv),a
	ld	(dbdev),a

	xor	a
	ld	(ix+dpbflg),a		;ruecksetzen alle Flags
	ld	(ix+dpbsn0),a		;keine Weiter-Numm. auf Ruecks.
	ld	(ix+dpbofs),a		;keine Systemspuren

	ld	(dfrmtr),a		;Spur 0
	ld	(dbtrk),a
	inc	a
	ld	(dbsec),a		;Sektor 1
	ld	(dbsnb),a		;1 phys. Sektor lesen

;
; Stellen Sektor-Translate-Tabelle 1,2,3,...
;
	push	ix
	ld	b,26			;max. Laenge der Tabelle
selstz:	ld	(ix+dpbstr),a
	inc	ix
	inc	a
	djnz	selstz
	pop	ix
;
; Positionieren auf Spur 0 und analysieren Systemspuren
;
	call	dsidtr			;beliebigen Sektor ID lesen
	jp	z,selst1		;o.k.
;
; Fehler beim Lesen Spur 0 -> SCP 1700?
;
seldlk:	ld	a,1
	ld	(dfrmtr),a		;Spur 1 setzen
	ld	(dbtrk),a
	call	dsidtr			;und nochmal probieren
	jr	nz,seldlj		;wieder Fehler -> nicht erkennbar
;
selst1:	ld	a,h
	ld	(dbslc),a		;setzen Spurformat fuer Sp. 0 /(1 (scp 1700))
	IF	dbufsz le 7
	or	a			;Sektorlaenge 128?
	jr	nz,seldlj		;nein, Puffer zu klein
	ENDIF
	call	dbtran			;Lesen Spur 0, Sektor 1
seldlj:	jr	nz,seldle		;Fehler
 if dbufsz gt 7
	ld	a,(dbuf)		;Lesen 'USER' aus 'Directory'
 else
	ld	a,(dirbuf)
 endif
	cp	0e5h			;leere Diskette/geloeschter Eintrag ?
	jr	z,selsy0		;ja, kann Directory sein
 if ibmfrm
	cp	40h			;IBM-Format (SIOS-Daten-Diskette)?
	jr	z,selsy0		;ja, 0 Systemspuren annehmen
 endif
	cp	020h			;<=31 ?
	jr	nc,selsy1		;nein, kann kein Directory sein
					;Systemlader fuer PC1715 beginnt
					;mit 02 oder 03
selsy0:	dec	(ix+dpbofs)		;=255, wenn evtl. Directory
;
;	Analysieren Datenspur
;
;	SS / DS-Analyse
;
selsy1:	ld	(ix+dpbstp),2		;Doppel-Step-Impulse
	ld	a,dlgint		;auf LOGIN-Spur
	call	dsidtt			;belieb. SektId Vorderseite lesen
	jr	nz,seldle		;Fehler, unsicheres Format
	ld	d,h			;d:=Sektorlcode, e:=Spur
 if dskds
	bit	0,(ix+dpbsid)		;ist es ein DS-Laufwerk?
	jr	z,selss			;nein, SS
	push	de			;merken Sektorlaengencode und Spur
	set	dpbfds,(ix+dpbflg)
	ld	a,1+(dlgint*2)		;Rueckseite der Spur,
					;ab der Format bei SS konstant
	call	dsidtt			;beliebigen Sekt.Id Ruecks. lesen
	ld	a,d			;merken side Ruecks.
	ld	l,e			;h:=Sektorlcode, l:=Spur Rueckseite
	pop	de			;wiederherstellen Vorderseite
	jr	nz,selss		;Fehler beim Lesen, SS
	or	a
	sbc	hl,de			;Vorder- gleich Rueckseite?
	jr	z,sel48			;nein, SS
selss:	res	dpbfds,(ix+dpbflg)
 endif
;
; 40/80 Track Analyse
;
sel48:	ld	a,e			;trk
	sub	dlgint			;waren 2 Steps richtig?
	jr	z,seldl1		;ja
	dec	(ix+dpbstp)		;Einzelstep-Impulse
	sub	dlgint			;waere 1 Step richtig?
	jr	z,seldl1		;ja
					;nein, unsicher
seldle:	ld	(ix+dpbslc),0ffh	;provozieren 'BAD SECTOR'
	ld	hl,0			;erzeugen 'SELECT' Error
	ex	(sp),hl
	jp	selext
;
; DS/SS und 40/80 ist unterschieden, es fehlt Sektorlaenge
;
seldl1:	ld	a,d
	ld	(ix+dpbslc),a		;definieren Sektorlaengencode
 IF	dbufsz le 7
	or	a			;Sektorlaenge 128?
	jr	nz,seldle		;nein, Puffer reicht nicht
 ELSE
	IF	dbufsz lt 10		;Test, ob Disk-Puffer ausreicht
	cp	dbufsz-6		;dpbslc < dbufsz-6?
	jr	nc,seldle		;nein, zu klein
	ENDIF
	or	a			;Sektorlaenge 128?
	jr	nz,seldxl		;nein, normale Sektorfolge
 endif		;dbufsz gt 7
;
seldsv:
;
; Stellen Sektor-Translate-Tabelle 1,7,13,...
;
	push	ix
	pop	hl
	ld	bc,dpbstr
	add	hl,bc
	ex	de,hl
	ld	hl,xlt
	ld	c,26
	ldir
;
seldxl:	
	call	dtrsla			;stellen hl entspr. Sektorlaenge
	jr	nz,seldle		;unzulaessig
	ld	bc,dsll			;Laenge eines Eintrags
	bit	1,(ix+dpbstp)		;40 Tr. auf 80er LW?
	jr	nz,seld40		;ja
	ld	a,(ix+dpbptr)		;40er LW?
	cp	40+1
	jr	c,seld40		;ja, 40 Tr. auf 40er LW
	add	hl,bc			;auf 80er Format stellen
seld40:	bit	dpbfds,(ix+dpbflg)	;DS?
	jr	z,seldss		;nein
	add	hl,bc			;auf DS Format
	add	hl,bc
;
; DPB modifizieren entsprechend erkanntem Format
;
seldss:
selset:	ld	c,(hl)			;Zahl der benutzten Spuren
	ld	(ix+dpbtrk),c
	inc	hl
	ld	c,(hl)			;Anzahl 128er Sektoren pro Spur
	ld	(ix+dpbspt),c
	inc	hl
	ld	c,(hl)			;Anzahl der Dir-Eintraege -1
	inc	hl
	ld	a,(hl)			;Anzahl der Systemspuren
	srl	a			;feste Anzahl erzwungen?
	jr	c,seldof		;ja
	bit	7,(ix+dpbofs)		;kann Spur 0 Directory sein?
	jr	z,seldof		;nein, Standardanzahl setzen
	xor	a			;sonst ohne Systemspuren
seldof:	ld	(ix+dpbofs),a
	or	a			;0 Systemspuren ?
	jr	z,selddr		;ja
	ld	a,c			;Anzahl	Dir-Eintraege -1
	cp	192-1			;>=192 Dir-Eintraege ?
	jr	c,selddr		;nein
	ld	c,128-1			;780k hat 128 Dir-Eintraege
selddr:	ld	(ix+dpbdir),c
	inc	hl
	ld	c,(hl)			;Abstand der Blockgroessentab.
	add	hl,bc			;auf Blockgroessentabelld
	ld	c,(hl)
	ld	(ix+dpbbls),c
	inc	hl
	ld	c,(hl)
	ld	(ix+dpbblm),c
	inc	hl
	ld	c,(hl)
	ld	(ix+dpbexm),c
;
; Bestimmen Zahl der abweichenden 128er-Sektoren ab Spur 0
;
	xor	a
	ld	(dfrmtr),a		;ab Spur 0
sf128z:	call	dsidtr			;beliebigen Sektor ID lesen
	jr	nz,sf128e		;Fehler
	ld	a,h			;Sektorlaenge
	cp	(ix+dpbslc)		;gleich Disketten-Rest?
	jr	z,sf128e		;ja
	ld	a,(ix+dpbflg)
	and	dpbfsm			;bisherige Anzahl abweichender Spuren
	cp	dpbfsm			;Zaehler voll ?
	jr	z,sf128e		;ja
	inc	(ix+dpbflg)		;erhoehen abweichende Spurzahl
	ld	hl,dfrmtr		;naechste (logische!) Spur
	inc	(hl)
	jr	sf128z
;
sf128e:

; Setzen Anzahl der logischen 128er Rekords im Puffer -1
; Es wird immer das Maximum gesetzt, dies setzt eine dichte
; Sektorfolge beim Transfer voraus! (so in dpbstr)

	IF	dbufsz gt 7
	ld	(ix+dpbbfm),+(1 shl (dbufsz-7))-1
	ENDIF

; Berechnen Speicherkapazitaet-1 in BDOS-Bloecken aus
; ((Tracks-dpbofs)*dpbspt/(2**dpbbls))-1
	ld	l,(ix+dpbtrk)
	xor	a
	ld	h,a			;hl:=log. Spurzahl
	ld	e,(ix+dpbofs)
	ld	d,a			;de:=log. offset-Spurzahl
	sbc	hl,de
	ex	de,hl			;de:=log. Daten-Spurzahl
	ld	l,a			;hl:=0
	ld	b,(ix+dpbspt)
dsizmz:	add	hl,de
	djnz	dsizmz			;hl:=(tracks-dpbofs)*dpbspt
dsizme:	ld	b,(ix+dpbbls)
dsizdz:	srl	h
	rr	l
	djnz	dsizdz
	dec	hl
	ld	(ix+dpbsiz),l
	ld	(ix+dpbsiz+1),h
	ld	a,(ix+dpbdir)		;Dir-Groesse
	inc	a
	rrca
	rrca				;div 4, da 4 Dir-Eintr. /Sekt.
	ld	(ix+dpbchk),a		;ist Sektorzahl = Check size
	ld	b,(ix+dpbbls)		;block shift
seldla:	rrca				;BDOS-Bloecke fuer Dir.
	djnz	seldla
	ld	b,a
	xor	a
seldal:	scf				;Allocation-Bits fuer Dir.
	rra
	djnz	seldal
	ld	(ix+dpbalc),a
;
;***************************************************************
;	Ende automatische Formaterkennung
;
	ENDIF	;format
;
selext:
;
;	Anzeigen Diskformat als Speicherkapazitaet in kByte
;
 if gdck
;
	ld	l,(ix+dpbsiz)
	ld	h,(ix+dpbsiz+1)
	inc	hl
	ld	a,(ix+dpbbls)
	sub	3
	jr	z,selex1
selex2: add	hl,hl
	dec	a
	jr	nz,selex2
selex1:	ld	de,pufstl+9
	ld	(selex5),de
	ld	de,-100
	call	selex3
	ld	de,-10
	call	selex3
	ld	a,l
	or	'0'
	call	selex4
;
 if disknb le 3
;
	ld	a,'k'
	call	selex4
 endif
 ENDIF
;
selexx:	pop	hl			;hl auf DPH
	call	astl
	ret				;Return Seldsk
;
 if gdck
;
selex3:	call	mhldig
selex4:	ld	de,0
selex5	equ	$-2
	ld	(de),a
	inc	de
	ld	(selex5),de
	ret
;
mhldig: ld	a,'0'-1
mhdig1:	inc	a
	add	hl,de
	jr	c,mhdig1
	sbc	hl,de
	inc	c
	cp	'0'
	ret	nz
	dec	c
	ret
;
mbreco:	ld	a,(hl)
mrecoa:	call	mreca
mrecol:	
mreca:	rrca
	rrca
	rrca
	rrca
mrecor:	push	af
	and	0fh
	sub	9+1
	jr	c,mrecod
	add	a,7
mrecod:	add	a,'0'+10
	ld	(de),a
	inc	de
	pop	af
	ret
;
 ENDIF	
;
;SEKTORNUMMER TRANSFORMIEREN
;DE - ADR. UMWANDLUNGSTABELLE
;BC - SEKTORNUMMER
;
SECTR:	LD	A,D			;wenn de=0, dann keine Transformation
	or	e
	jr	z,sectr1
;
	ex	de,hl
	add	hl,bc
	ld	l,(hl)
	ld	h,0
	ret
;
sectr1:	ld	h,b
	ld	l,c
	inc	hl
	ret
;
setix::	ld	a,(dev)			; e/a-tabelldnadresse nach ix laden
	ld	e,a
	ld	d,0
	ld	hl,ixtab
	add	hl,de
	add	hl,de
	ld	e,(hl)
	inc	hl
	ld	d,(hl)
	ld	a,e
	or	d
	ret	z			; -> geraet nicht vorhanden
	push	de
	pop	ix
	ret
;
;   Berechnen der Adressen fuer dph und dpb
;   =======================================
;  ix auf dpb stellen, fuer log. Lw (c)
;  hl auf dph
;
dgetpb:	 push	de
	 ld     hl,0
         ld     a,c
         cp     10h            		;dph def.?
         jr     nc,dgetp0      		;nein
         ex     de,hl
         ld     hl,dpha        		;Kopf dph-Tabelld
         ld     e,c
         add    hl,de
         add    hl,de
         ld     a,(hl)
         inc    hl
         ld     h,(hl)
         ld     l,a            		;hl:=^dph
	 push	hl
	 ld	e,10
	 add	hl,de
	 ld	e,(hl)
	 inc 	hl
         ld     d,(hl)         		;de:=^dpb
         push   de
         pop    ix
         pop    hl
dgetp0:  pop	de 
	 ld     a,h
         or     l              		;ret z bei hl=0
         ret
;	
;FLOPPY LESEN/SCHREIBEN
;----------------------
;AUFTEILUNG AUF DIE PHYSISCHEN GERAETE:
;
write::	call	reta
	call	setix
	jr	z,wr15
	ld	l,(ix-ixwr)
	ld	h,(ix-ixwr+1)
	call	callhl			;writeroutine aufrufen
	jr	wr16
;
wr15::	ld	a,1			;fehler: falsches geraet
wr16::	jp	retu
;
read::	call	reta
	call	setix
	jr	z,wr15			; -> geraet nicht vorhanden
	ld	l,(ix-ixrd)
	ld	h,(ix-ixrd+1)
	call	callhl			; readroutine aufrufen
	jr	wr16
;
include KCDSKL.INC
include KCDSKT.INC
include KCDPB.INC
;
wrdir	equ	1			; write to directory
wrual	equ	2			; write to unallocated
;
callhl::jp	(hl)
;
	INCLUDE ZBBOOT2.INC
;
abort::	ld	sp,spber1
;
abortc::ld	a,3
	ld	(abcnt),a
	ld	de,aboms
	ld	c,9
	call	5
	jp	wboot
;
aboms::	defb	0dh,0ah,'abort$'
;
	INCLUDE ZBRFL2.INC
;
; 	hardware beschreibungstabellen
; 	------------------------------
;
; 	e/a tabellen-aufbau
; 	-------------------
;
isblk	equ	5		; 0 - geraet arbeitet ungeblockt
ixrd	equ	4		; read/write-anspruenge
ixwr	equ	2

eastat	equ	0		; bamos-arbeitszellen kmb
eafehl	equ	1
eakom	equ	4
eaep	equ	5
eaadr	equ	7
ealen	equ	9
eabm	equ	10
eawied	equ	11
eaverl	equ	12

eadpuf	equ	13		; directorypufferung kassetten
eadzei	equ	15

eawovo	equ	16		; positionierung kassetten

hstbuf	equ	18		; blockung/entblockung arbeitszellen
hsttrk	equ	20
hstsec	equ	22
hstact	equ	23
hstwrt	equ	24
unacnt	equ	25
unatrk	equ	26
unasec	equ	28

gelade	equ	29

hrd	equ	30		; blockung/entblockung parameter
hwr	equ	32
blklog	equ	34
cpmspt	equ	35
secshf	equ	36
secmsk	equ	37
;
;	Floppy-Beschreibungs-Tabelle
;
       defb     0
       defw     mflrd          ;read
       defw     mflwr          ;write
ixmfl0::defb     0
;
;  	arbeitszellen
;  	=============
;
ixtab:	rept	16
	defw	0
	endm
dpha::	defw	0		; dph geraet a
dphb::	defw	0		;            b
dphc::	defw	0		;            c
dphd::	defw	0		;            d
dphe::	defw	0		;	     e
dphf::	defw	0		;	     f
dphg::	defw	0		;	     g
dphh::	defw	0		;	     h
dphi::	defw	0		;	     i
dphj::	defw	0		;	     j
dphk::	defw	0		;	     k
dphl::	defw	0		;	     l
dphm::	defw	0		;	     m
dphn::	defw	0		;	     n
dpho::	defw	0		;	     o
dphp::	defw	0		;	     p
dma::	defw	0
trk::	defw	0
sec::	defw	0
dev::	defb	0
;
aboerl::defb	0		; 0 - sofortabort erlaubt
;				; 1 - abort erst nach kmb-ende
qabort::defb	0		; 0 - kein abort nach kmb-ende
;				; 1 - abort      nach kmb-ende
abcnt::	defb	0		; aborttastendruckzaehler
umscho::defb	20h		; aktuelle shiftmaske
cont::	defb	0		; merkzelle fuer control-taste
pf10er::defb	0		; 1 - kassettenladen/-entladen erlaubt
;
sverz::	defb	0		; zum verzoegern von const
sschr::	defb	0		; 00 - kein schnellschreiben
;
dirbuf:
dirbf::	defs	128
dbuf::	defs	400h	;Blockpuffer fuer Minifloppy
;
;**************************************************************
	defs	80h		; davon ?? benutzt
spber::	defs	0
	defs	20h		; davon ?? benutzt
spber1::defs	0
spret::	defs	2
;**************************************************************
chkfl0:	defs	64
allfl0:	defs	50
chkfl1:	defs	64
allfl1:	defs	50
;**************************************************************
;
BIOSEN	EQU	$
 if wbootv eq 0
REST	EQU	0F7FFH-BIOSEN
 else
REST	EQU	0FFFFH-BIOSEN
 endif
;
.DEPHASE
;
 if wbootv eq 0
.PHASE	0F800H
CCPKOP:	DEFS	0800H
.DEPHASE
 endif
;
;***************************************************************
;Hilfsmakros zur Ausgabe von Text und Zahlen auf den BS
;***************************************************************
;
;Aufruf mit if1 ... endif
;printd text,wert --> dez. Ausgabe
;printh text,wert --> hex. Ausgabe
;
if1
;Hilfsmakro fuer Dezimalausgabe
printd	MACRO   t,n
	printx  <t>,%(n)
	ENDM
;Hilfsmakro fuer Hexadezimalausgabe
printh	MACRO   t,n
	.RADIX	16
	printx	<t>,%(n)
	.RADIX	10
	ENDM
printx	MACRO	t,n
        .printx * t n
	ENDM
endif
;
if1 
;
printh <CCP   :          >,ccp
printh <BDOS  :          >,bdos
printh <BIOS  :          >,bios
printh <BIOSRAMENDE:     >,biosen
printd <REST:            >,rest

endif 
;
	end
